/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.handshake;

import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.TObjectLongMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearanceRGBColor;
import us.ihmc.graphicsDescription.color.MutableColor;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.RemoteYoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.plotting.ArtifactList;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.serializers.extra.AbstractSerializer;
import us.ihmc.idl.serializers.extra.YAMLSerializer;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.robotDataLogger.EnumType;
import us.ihmc.robotDataLogger.Handshake;
import us.ihmc.robotDataLogger.HandshakeFileType;
import us.ihmc.robotDataLogger.HandshakePubSubType;
import us.ihmc.robotDataLogger.JointDefinition;
import us.ihmc.robotDataLogger.ReferenceFrameInformation;
import us.ihmc.robotDataLogger.SCS1YoGraphicObjectMessage;
import us.ihmc.robotDataLogger.SCS2YoGraphicDefinitionMessage;
import us.ihmc.robotDataLogger.YoRegistryDefinition;
import us.ihmc.robotDataLogger.YoType;
import us.ihmc.robotDataLogger.YoVariableDefinition;
import us.ihmc.robotDataLogger.handshake.YoVariableHandshakeParser;
import us.ihmc.robotDataLogger.jointState.JointState;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicGroupDefinition;
import us.ihmc.yoVariables.euclid.referenceFrame.interfaces.FrameIndexMap;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.parameters.EnumParameter;
import us.ihmc.yoVariables.parameters.IntegerParameter;
import us.ihmc.yoVariables.parameters.LongParameter;
import us.ihmc.yoVariables.parameters.ParameterLoadStatus;
import us.ihmc.yoVariables.parameters.SingleParameterReader;
import us.ihmc.yoVariables.parameters.YoParameter;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

public class IDLYoVariableHandshakeParser
extends YoVariableHandshakeParser {
    private final AbstractSerializer<Handshake> serializer;
    private TIntIntHashMap variableOffsets = new TIntIntHashMap();

    public IDLYoVariableHandshakeParser(HandshakeFileType type) {
        switch (type) {
            case IDL_YAML: {
                this.serializer = new YAMLSerializer((TopicDataType)new HandshakePubSubType());
                break;
            }
            default: {
                this.serializer = null;
            }
        }
    }

    public static int getNumberOfVariables(Handshake handShake) {
        int jointStateVariables = 0;
        for (int i = 0; i < handShake.getJoints().size(); ++i) {
            jointStateVariables += JointState.getNumberOfVariables(((JointDefinition)((Object)handShake.getJoints().get(i))).getType());
        }
        return 1 + handShake.getVariables().size() + jointStateVariables;
    }

    @Override
    public void parseFrom(byte[] data) throws IOException {
        if (this.serializer == null) {
            throw new RuntimeException();
        }
        Handshake handshake = (Handshake)((Object)this.serializer.deserialize(data));
        this.parseFrom(handshake);
    }

    @Override
    public void parseFrom(Handshake handshake) {
        this.dt = handshake.getDt();
        List<YoRegistry> regs = IDLYoVariableHandshakeParser.parseRegistries(handshake);
        this.registries.clear();
        this.registries.addAll(regs);
        List<YoVariable> vars = this.parseVariables(handshake, regs);
        this.variables.clear();
        this.variables.addAll(vars);
        this.addJointStates(handshake);
        this.addGraphicObjects(handshake);
        this.scs2YoGraphics = IDLYoVariableHandshakeParser.parseSCS2YoGraphics(handshake);
        this.frameIndexMap = IDLYoVariableHandshakeParser.parseReferenceFrames(handshake);
        this.numberOfVariables = handshake.getVariables().size();
        this.numberOfJointStateVariables = this.getNumberOfJointStateVariables(handshake);
        this.stateVariables = 1 + this.numberOfVariables + this.numberOfJointStateVariables;
    }

    private static List<YoRegistry> parseRegistries(Handshake handshake) {
        YoRegistryDefinition rootDefinition = (YoRegistryDefinition)((Object)handshake.getRegistries().get(0));
        YoRegistry rootRegistry = new YoRegistry(rootDefinition.getNameAsString());
        ArrayList<YoRegistry> registryList = new ArrayList<YoRegistry>();
        registryList.add(rootRegistry);
        for (int i = 1; i < handshake.getRegistries().size(); ++i) {
            YoRegistryDefinition registryDefinition = (YoRegistryDefinition)((Object)handshake.getRegistries().get(i));
            YoRegistry registry = new YoRegistry(registryDefinition.getNameAsString());
            registryList.add(registry);
            ((YoRegistry)registryList.get(registryDefinition.getParent())).addChild(registry);
        }
        return registryList;
    }

    public int getVariableOffset(int registryIndex) {
        return this.variableOffsets.get(registryIndex);
    }

    private List<YoVariable> parseVariables(Handshake handshake, List<YoRegistry> registryList) {
        ArrayList<YoVariable> variableList = new ArrayList<YoVariable>();
        for (int i = 0; i < handshake.getVariables().size(); ++i) {
            boolean allowNullValues;
            String[] names;
            EnumType enumType;
            YoVariableDefinition yoVariableDefinition = (YoVariableDefinition)((Object)handshake.getVariables().get(i));
            String name = yoVariableDefinition.getNameAsString();
            String description = yoVariableDefinition.getDescriptionAsString();
            int registryIndex = yoVariableDefinition.getRegistry();
            YoRegistry parent = registryList.get(registryIndex);
            double min = yoVariableDefinition.getMin();
            double max = yoVariableDefinition.getMax();
            if (!this.variableOffsets.contains(registryIndex)) {
                this.variableOffsets.put(registryIndex, i);
            }
            YoType type = yoVariableDefinition.getType();
            if (yoVariableDefinition.getIsParameter()) {
                BooleanParameter newParameter = switch (type) {
                    case YoType.DoubleYoVariable -> new DoubleParameter(name, description, parent, min, max);
                    case YoType.IntegerYoVariable -> new IntegerParameter(name, description, parent, (int)min, (int)max);
                    case YoType.BooleanYoVariable -> new BooleanParameter(name, description, parent);
                    case YoType.LongYoVariable -> new LongParameter(name, description, parent, (long)min, (long)max);
                    case YoType.EnumYoVariable -> {
                        enumType = (EnumType)((Object)handshake.getEnumTypes().get(yoVariableDefinition.getEnumType()));
                        names = enumType.getEnumValues().toStringArray();
                        allowNullValues = yoVariableDefinition.getAllowNullValues();
                        yield new EnumParameter(name, description, parent, allowNullValues, names);
                    }
                    default -> throw new RuntimeException("Unknown YoVariable type: " + type.name());
                };
                if (yoVariableDefinition.getLoadStatus() == null) {
                    SingleParameterReader.readParameter((YoParameter)newParameter, (double)0.0, (ParameterLoadStatus)ParameterLoadStatus.LOADED);
                } else {
                    switch (yoVariableDefinition.getLoadStatus()) {
                        case Unloaded: {
                            SingleParameterReader.readParameter((YoParameter)newParameter, (double)0.0, (ParameterLoadStatus)ParameterLoadStatus.UNLOADED);
                            break;
                        }
                        case Default: {
                            SingleParameterReader.readParameter((YoParameter)newParameter, (double)0.0, (ParameterLoadStatus)ParameterLoadStatus.DEFAULT);
                            break;
                        }
                        case Loaded: {
                            SingleParameterReader.readParameter((YoParameter)newParameter, (double)0.0, (ParameterLoadStatus)ParameterLoadStatus.LOADED);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown load status: " + yoVariableDefinition.getLoadStatus());
                        }
                    }
                }
                YoVariable newVariable = parent.getVariable(parent.getNumberOfVariables() - 1);
                if (newParameter != newVariable.getParameter()) {
                    throw new RuntimeException("Last variable index in the registry is not the parameter just added.");
                }
                variableList.add(newVariable);
                continue;
            }
            YoDouble newVariable = switch (type) {
                case YoType.DoubleYoVariable -> new YoDouble(name, description, parent);
                case YoType.IntegerYoVariable -> new YoInteger(name, description, parent);
                case YoType.BooleanYoVariable -> new YoBoolean(name, description, parent);
                case YoType.LongYoVariable -> new YoLong(name, description, parent);
                case YoType.EnumYoVariable -> {
                    enumType = (EnumType)((Object)handshake.getEnumTypes().get(yoVariableDefinition.getEnumType()));
                    names = enumType.getEnumValues().toStringArray();
                    allowNullValues = yoVariableDefinition.getAllowNullValues();
                    yield new YoEnum(name, description, parent, allowNullValues, names);
                }
                default -> throw new RuntimeException("Unknown YoVariable type: " + type.name());
            };
            newVariable.setVariableBounds(min, max);
            variableList.add((YoVariable)newVariable);
        }
        return variableList;
    }

    private int getNumberOfJointStateVariables(Handshake handshake) {
        int numberOfJointStates = 0;
        for (int i = 0; i < handshake.getJoints().size(); ++i) {
            JointDefinition joint = (JointDefinition)((Object)handshake.getJoints().get(i));
            numberOfJointStates += JointState.getNumberOfVariables(joint.getType());
        }
        return numberOfJointStates;
    }

    private void addJointStates(Handshake handshake) {
        for (int i = 0; i < handshake.getJoints().size(); ++i) {
            JointDefinition joint = (JointDefinition)((Object)handshake.getJoints().get(i));
            this.jointStates.add(JointState.createJointState(joint.getNameAsString(), joint.getType()));
        }
    }

    private void addGraphicObjects(Handshake yoProtoHandshake) {
        HashMap<String, YoGraphicsList> dgoListMap = new HashMap<String, YoGraphicsList>();
        for (int i = 0; i < yoProtoHandshake.getGraphicObjects().size(); ++i) {
            YoGraphicsList dgoList;
            String listName = "default";
            if (!((SCS1YoGraphicObjectMessage)((Object)yoProtoHandshake.getGraphicObjects().get(i))).getListNameAsString().isEmpty()) {
                listName = ((SCS1YoGraphicObjectMessage)((Object)yoProtoHandshake.getGraphicObjects().get(i))).getListNameAsString();
            }
            if (dgoListMap.containsKey(listName)) {
                dgoList = (YoGraphicsList)dgoListMap.get(listName);
            } else {
                dgoList = new YoGraphicsList(listName);
                dgoListMap.put(listName, dgoList);
            }
            try {
                dgoList.add((YoGraphic)this.getRemoteGraphic((SCS1YoGraphicObjectMessage)((Object)yoProtoHandshake.getGraphicObjects().get(i))));
                continue;
            }
            catch (Exception e) {
                LogTools.error((String)("Got exception: " + e.getClass().getSimpleName() + " when loading a YoGraphic: " + e.getMessage()));
            }
        }
        for (String list : dgoListMap.keySet()) {
            this.scs1YoGraphics.registerYoGraphicsList((YoGraphicsList)dgoListMap.get(list));
        }
        ArtifactList artifactList = new ArtifactList("remote");
        for (int i = 0; i < yoProtoHandshake.getArtifacts().size(); ++i) {
            try {
                artifactList.add((Artifact)this.getRemoteGraphic((SCS1YoGraphicObjectMessage)((Object)yoProtoHandshake.getArtifacts().get(i))));
                continue;
            }
            catch (Exception e) {
                LogTools.error((String)("Got exception: " + e.getClass().getSimpleName() + " when loading a Artifact: " + e.getMessage()));
            }
        }
        this.scs1YoGraphics.registerArtifactList(artifactList);
    }

    private RemoteYoGraphic getRemoteGraphic(SCS1YoGraphicObjectMessage graphicObjectMessage) {
        int registrationID = graphicObjectMessage.getRegistrationID();
        String name = graphicObjectMessage.getNameAsString();
        YoVariable[] vars = new YoVariable[graphicObjectMessage.getYoVariableIndex().size()];
        for (int v = 0; v < vars.length; ++v) {
            vars[v] = (YoVariable)this.variables.get(graphicObjectMessage.getYoVariableIndex().get(v));
        }
        double[] consts = graphicObjectMessage.getConstants().toArray();
        YoAppearanceRGBColor appearance = new YoAppearanceRGBColor(new MutableColor((float)graphicObjectMessage.getAppearance().getR(), (float)graphicObjectMessage.getAppearance().getG(), (float)graphicObjectMessage.getAppearance().getB()), graphicObjectMessage.getAppearance().getTransparency());
        return this.yoGraphicFromMessage(registrationID, name, vars, consts, (AppearanceDefinition)appearance);
    }

    private static List<YoGraphicGroupDefinition> parseSCS2YoGraphics(Handshake handshake) {
        ArrayList<YoGraphicDefinition.YoGraphicFieldsSummary> yoGraphicFieldsSummaryList = new ArrayList<YoGraphicDefinition.YoGraphicFieldsSummary>();
        IDLSequence.Object<SCS2YoGraphicDefinitionMessage> msgList = handshake.getScs2YoGraphicDefinitions();
        for (int i = 0; i < msgList.size(); ++i) {
            SCS2YoGraphicDefinitionMessage msg = (SCS2YoGraphicDefinitionMessage)((Object)msgList.get(i));
            int fields = msg.getFieldNames().size();
            YoGraphicDefinition.YoGraphicFieldsSummary summary = new YoGraphicDefinition.YoGraphicFieldsSummary();
            for (int j = 0; j < fields; ++j) {
                summary.add((Object)new YoGraphicDefinition.YoGraphicFieldInfo(((StringBuilder)msg.getFieldNames().get(j)).toString(), ((StringBuilder)msg.getFieldValues().get(j)).toString()));
            }
            yoGraphicFieldsSummaryList.add(summary);
        }
        return YoGraphicDefinition.parseTreeYoGraphicFieldsSummary(yoGraphicFieldsSummaryList);
    }

    private static FrameIndexMap parseReferenceFrames(Handshake handshake) {
        ReferenceFrameInformation referenceFrameInformation = handshake.getReferenceFrameInformation();
        TObjectLongHashMap frameToIndex = new TObjectLongHashMap(10, 0.5f, -1L);
        TLongObjectHashMap indexToframe = new TLongObjectHashMap(10, 0.5f, -1L);
        for (int i = 0; i < referenceFrameInformation.getFrameNames().size(); ++i) {
            RigidBodyTransform transform = new RigidBodyTransform();
            String name = ((StringBuilder)referenceFrameInformation.getFrameNames().get(i)).toString();
            ReferenceFrame frame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)name, (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)transform);
            long index = referenceFrameInformation.getFrameIndices().get(i);
            frameToIndex.put((Object)frame, index);
            indexToframe.put(index, (Object)frame);
        }
        return new FrameIndexMap(){
            final /* synthetic */ TLongObjectMap val$indexToframe;
            final /* synthetic */ TObjectLongMap val$frameToIndex;
            {
                this.val$indexToframe = tLongObjectMap;
                this.val$frameToIndex = tObjectLongMap;
            }

            public void put(ReferenceFrame referenceFrame) {
                throw new UnsupportedOperationException();
            }

            public ReferenceFrame getReferenceFrame(long frameIndex) {
                return (ReferenceFrame)this.val$indexToframe.get(frameIndex);
            }

            public long getFrameIndex(ReferenceFrame referenceFrame) {
                return this.val$frameToIndex.get((Object)referenceFrame);
            }
        };
    }
}

