/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.compression;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.DoubleSupplier;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import us.ihmc.commons.Conversions;
import us.ihmc.robotDataLogger.logger.LogPropertiesReader;
import us.ihmc.robotDataLogger.logger.YoVariableLogReader;
import us.ihmc.tools.compression.SnappyUtils;

public class CompressionBenchmark
extends YoVariableLogReader {
    public static final File directory = new File("/home/jesper/robotLogs/20170315_165154_AtlasControllerFactory");
    private final ByteBuffer[] trainingSet;
    private final ByteBuffer[] testSet;

    public CompressionBenchmark() throws IOException {
        super(directory, new LogPropertiesReader(new File(directory, File.separator + "robotData.log")));
        int i;
        this.initialize();
        System.out.println("Loading " + this.getNumberOfEntries() + " data lines with " + this.getNumberOfVariables() + " variables.");
        System.out.println("Total memory required " + (long)this.getNumberOfEntries() * (long)this.getNumberOfVariables() * 8L / 0x100000L + "Mb");
        int trainingSetSize = this.getNumberOfEntries() / 10;
        int testSetSize = this.getNumberOfEntries() - trainingSetSize;
        this.trainingSet = new ByteBuffer[trainingSetSize];
        this.testSet = new ByteBuffer[testSetSize];
        for (i = 0; i < trainingSetSize; ++i) {
            this.trainingSet[i] = this.copyData(i);
        }
        for (i = 0; i < testSetSize; ++i) {
            this.testSet[i] = this.copyData(i + trainingSetSize);
        }
        System.out.println();
        System.out.println("--- TRAINING (JIT Warmup)---");
        System.out.println();
        this.benchmark(this.trainingSet);
        System.out.println();
        System.out.println("--- TEST ---");
        System.out.println();
        this.benchmark(this.testSet);
    }

    private void benchmarkFunction(String name, int elements, DoubleSupplier f) {
        System.out.println("--- " + name + " ---");
        long start = System.nanoTime();
        double compressionFactor = f.getAsDouble();
        long duration = System.nanoTime() - start;
        System.out.println("Compression factor: " + compressionFactor);
        System.out.println("Duration: " + Conversions.nanosecondsToSeconds((long)duration) + "s");
        System.out.println("Time per data line: " + Conversions.nanosecondsToMilliseconds((double)(duration / (long)elements)) + "ms");
        System.out.println();
    }

    private void benchmark(ByteBuffer[] set) throws IOException {
        this.benchmarkFunction("Copy", set.length, () -> this.benchMarkCopy(set));
        this.benchmarkFunction("Snappy (Xerial)", set.length, () -> this.benchMarkSnappy(set));
        LZ4Compressor safeCompressor = LZ4Factory.safeInstance().fastCompressor();
        this.benchmarkFunction("LZ4 (Safe)", set.length, () -> this.benchMarkLZ4(safeCompressor, set));
        LZ4Compressor unsafeCompressor = LZ4Factory.unsafeInstance().fastCompressor();
        this.benchmarkFunction("LZ4 (Unsafe)", set.length, () -> this.benchMarkLZ4(unsafeCompressor, set));
        LZ4Compressor jniCompressor = LZ4Factory.nativeInstance().fastCompressor();
        this.benchmarkFunction("LZ4 (JNI - java buffer)", set.length, () -> this.benchMarkLZ4(jniCompressor, set));
        ByteBuffer[] directSet = new ByteBuffer[set.length];
        for (int i = 0; i < set.length; ++i) {
            directSet[i] = ByteBuffer.allocateDirect(set[i].capacity());
            set[i].clear();
            directSet[i].put(set[i]);
        }
        this.benchmarkFunction("LZ4 (Unsafe - direct buffer)", set.length, () -> this.benchMarkLZ4(unsafeCompressor, directSet));
        this.benchmarkFunction("LZ4 (JNI - direct buffer)", directSet.length, () -> this.benchMarkLZ4(jniCompressor, directSet));
        this.benchmarkFunction("Copy (Direct)", directSet.length, () -> this.benchMarkCopy(directSet));
    }

    private double benchMarkCopy(ByteBuffer[] set) {
        ByteBuffer target = set[0].isDirect() ? ByteBuffer.allocateDirect(this.getNumberOfVariables() * 8) : ByteBuffer.allocate(this.getNumberOfVariables() * 8);
        long totalSize = (long)set.length * (long)(this.getNumberOfVariables() * 8);
        long compressedSize = 0L;
        for (int i = 0; i < set.length; ++i) {
            set[i].clear();
            target.clear();
            target.put(set[i]);
            compressedSize += (long)target.position();
        }
        return (double)compressedSize / (double)totalSize;
    }

    private double benchMarkSnappy(ByteBuffer[] set) {
        ByteBuffer target = ByteBuffer.allocate(SnappyUtils.maxCompressedLength(this.getNumberOfVariables() * 8));
        long totalSize = (long)set.length * (long)(this.getNumberOfVariables() * 8);
        long compressedSize = 0L;
        try {
            for (int i = 0; i < set.length; ++i) {
                set[i].clear();
                target.clear();
                SnappyUtils.compress(set[i], target);
                compressedSize += (long)target.position();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (double)compressedSize / (double)totalSize;
    }

    private double benchMarkLZ4(LZ4Compressor compressor, ByteBuffer[] set) {
        ByteBuffer target = ByteBuffer.allocateDirect(compressor.maxCompressedLength(this.getNumberOfVariables() * 8));
        long totalSize = (long)set.length * (long)(this.getNumberOfVariables() * 8);
        long compressedSize = 0L;
        for (int i = 0; i < set.length; ++i) {
            set[i].clear();
            target.clear();
            compressor.compress(set[i], target);
            compressedSize += (long)target.position();
        }
        return (double)compressedSize / (double)totalSize;
    }

    private ByteBuffer copyData(int i) throws IOException {
        ByteBuffer dataLine = this.readData(i);
        ByteBuffer copy = ByteBuffer.allocate(dataLine.remaining());
        copy.put(dataLine);
        copy.clear();
        return copy;
    }

    public static void main(String[] args) throws IOException {
        new CompressionBenchmark();
    }
}

