/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.logger;

import com.martiansoftware.jsap.JSAPException;
import java.io.IOException;
import java.util.HashSet;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.Announcement;
import us.ihmc.robotDataLogger.StaticHostListLoader;
import us.ihmc.robotDataLogger.interfaces.DataServerDiscoveryListener;
import us.ihmc.robotDataLogger.logger.YoVariableLogger;
import us.ihmc.robotDataLogger.logger.YoVariableLoggerOptions;
import us.ihmc.robotDataLogger.websocket.client.discovery.DataServerDiscoveryClient;
import us.ihmc.robotDataLogger.websocket.client.discovery.HTTPDataServerConnection;

public class YoVariableLoggerDispatcher
implements DataServerDiscoveryListener {
    private final DataServerDiscoveryClient discoveryClient;
    private final Object lock = new Object();
    private final HashSet<HashAnnouncement> activeLogSessions = new HashSet();
    private final YoVariableLoggerOptions options;

    public YoVariableLoggerDispatcher(YoVariableLoggerOptions options) throws IOException {
        this.options = options;
        LogTools.info((String)"Starting YoVariableLoggerDispatcher");
        boolean enableAutoDiscovery = !options.isDisableAutoDiscovery();
        this.discoveryClient = new DataServerDiscoveryClient(this, enableAutoDiscovery);
        this.discoveryClient.addHosts(StaticHostListLoader.load());
        LogTools.info((String)"Client started, waiting for data server sessions");
        ThreadTools.sleepForever();
    }

    public static void main(String[] args) throws JSAPException, IOException {
        YoVariableLoggerOptions options = YoVariableLoggerOptions.parse(args);
        new YoVariableLoggerDispatcher(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connected(HTTPDataServerConnection connection) {
        Object object = this.lock;
        synchronized (object) {
            Announcement announcement = connection.getAnnouncement();
            HashAnnouncement hashAnnouncement = new HashAnnouncement(announcement);
            LogTools.warn((String)("New control session came online\n" + connection.getTarget() + " (" + announcement.getHostNameAsString() + ")"));
            if (this.activeLogSessions.contains(hashAnnouncement)) {
                LogTools.warn((String)("A logging sessions for " + announcement.getNameAsString() + " is already started."));
            } else if (announcement.getLog()) {
                try {
                    new YoVariableLogger(connection, this.options, request -> this.finishedLog((Announcement)((Object)request)));
                    this.activeLogSessions.add(hashAnnouncement);
                    LogTools.info((String)("Logging session started for " + announcement.getNameAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                LogTools.info((String)"Not logging.");
            }
        }
    }

    @Override
    public void disconnected(HTTPDataServerConnection connection) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishedLog(Announcement request) {
        LogTools.info((String)"Finishing Log.");
        Object object = this.lock;
        synchronized (object) {
            ThreadTools.sleep((long)2000L);
            LogTools.info((String)"Removing log session.");
            HashAnnouncement hashRequest = new HashAnnouncement(request);
            this.activeLogSessions.remove(hashRequest);
            LogTools.info((String)("Logging session for " + request.getNameAsString() + " has finished."));
        }
    }

    private static class HashAnnouncement {
        private final Announcement announcement;

        public HashAnnouncement(Announcement announcement) {
            this.announcement = announcement;
        }

        public boolean equals(Object other) {
            if (other instanceof HashAnnouncement) {
                return this.announcement.equals((Object)((HashAnnouncement)other).announcement);
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.announcement.getIdentifierAsString().hashCode();
            result = 31 * result + (this.announcement.getLog() ? 1231 : 1237);
            result = 31 * result + this.announcement.getNameAsString().hashCode();
            result = 31 * result + this.announcement.getReconnectKeyAsString().hashCode();
            return result;
        }
    }
}

