/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.logger;

import java.io.File;
import java.io.IOException;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.Camera;
import us.ihmc.robotDataLogger.LogProperties;

public abstract class VideoDataLoggerInterface {
    public static final String timestampDataPostfix = "_Timestamps.dat";
    public static final String videoPostfix = "_Video.mov";
    protected final String videoFile;
    protected final String timestampData;

    public VideoDataLoggerInterface(File logPath, LogProperties logProperties, String description) {
        Camera newCamera = (Camera)((Object)logProperties.getCameras().add());
        newCamera.setVideoFile(description);
        newCamera.setInterlaced(false);
        String videoFilename = description + videoPostfix;
        newCamera.setVideoFile(videoFilename);
        String timestampDataFilename = description + timestampDataPostfix;
        newCamera.setTimestampFile(timestampDataFilename);
        newCamera.setName(description);
        this.timestampData = logPath.getAbsolutePath() + File.separator + timestampDataFilename;
        this.videoFile = logPath.getAbsolutePath() + File.separator + videoFilename;
    }

    public abstract void restart() throws IOException;

    public abstract void close();

    public void removeLogFiles() {
        File videoFileFile;
        File timestampFile = new File(this.timestampData);
        if (timestampFile.exists()) {
            LogTools.info((String)("Deleting timestamp data " + this.timestampData));
            timestampFile.delete();
        }
        if ((videoFileFile = new File(this.videoFile)).exists()) {
            LogTools.info((String)("Deleting video file " + this.videoFile));
            videoFileFile.delete();
        }
    }

    public abstract void timestampChanged(long var1);

    public abstract long getLastFrameReceivedTimestamp();
}

