/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.dataBuffers;

import java.util.concurrent.atomic.AtomicLong;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoInteger;

public class LoggerDebugRegistry {
    private static final AtomicLong counter = new AtomicLong();
    private final YoRegistry registry;
    private final YoInteger fullCircularBufferCounter;
    private final YoInteger lostTickInCircularBuffer;

    public LoggerDebugRegistry(YoRegistry parentRegistry) {
        String registryName = "LoggerDebugRegistry";
        long count = counter.getAndIncrement();
        if (count > 0L) {
            registryName = registryName + count;
        }
        this.registry = new YoRegistry(registryName);
        this.fullCircularBufferCounter = new YoInteger("FullCircularBuffer", this.registry);
        this.lostTickInCircularBuffer = new YoInteger("lostTickInCircularBuffer", this.registry);
        parentRegistry.addChild(this.registry);
    }

    public void circularBufferFull() {
        this.fullCircularBufferCounter.increment();
    }

    public void lostTickInCircularBuffer() {
        this.lostTickInCircularBuffer.increment();
    }
}

