/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.Camera;
import us.ihmc.robotDataLogger.CameraPubSubType;
import us.ihmc.robotDataLogger.LogProperties;
import us.ihmc.robotDataLogger.ModelPubSubType;
import us.ihmc.robotDataLogger.VariablesPubSubType;
import us.ihmc.robotDataLogger.VideoPubSubType;

public class LogPropertiesPubSubType
implements TopicDataType<LogProperties> {
    public static final String name = "us::ihmc::robotDataLogger::LogProperties";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public void serialize(LogProperties data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        LogPropertiesPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, LogProperties data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        LogPropertiesPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return LogPropertiesPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += VariablesPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += ModelPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < 255; ++i0) {
            current_alignment += CameraPubSubType.getMaxCdrSerializedSize(current_alignment);
        }
        current_alignment += VideoPubSubType.getMaxCdrSerializedSize(current_alignment);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(LogProperties data) {
        return LogPropertiesPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(LogProperties data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getVersion().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getName().length() + 1;
        current_alignment += VariablesPubSubType.getCdrSerializedSize(data.getVariables(), current_alignment);
        current_alignment += ModelPubSubType.getCdrSerializedSize(data.getModel(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getTimestamp().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < data.getCameras().size(); ++i0) {
            current_alignment += CameraPubSubType.getCdrSerializedSize((Camera)((Object)data.getCameras().get(i0)), current_alignment);
        }
        current_alignment += VideoPubSubType.getCdrSerializedSize(data.getVideo(), current_alignment);
        return current_alignment - initial_alignment;
    }

    public static void write(LogProperties data, CDR cdr) {
        if (data.getVersion().length() > 255) {
            throw new RuntimeException("version field exceeds the maximum length");
        }
        cdr.write_type_d(data.getVersion());
        if (data.getName().length() > 255) {
            throw new RuntimeException("name field exceeds the maximum length");
        }
        cdr.write_type_d(data.getName());
        VariablesPubSubType.write(data.getVariables(), cdr);
        ModelPubSubType.write(data.getModel(), cdr);
        if (data.getTimestamp().length() > 255) {
            throw new RuntimeException("timestamp field exceeds the maximum length");
        }
        cdr.write_type_d(data.getTimestamp());
        if (data.getCameras().size() > 255) {
            throw new RuntimeException("cameras field exceeds the maximum length");
        }
        cdr.write_type_e(data.getCameras());
        VideoPubSubType.write(data.getVideo(), cdr);
    }

    public static void read(LogProperties data, CDR cdr) {
        cdr.read_type_d(data.getVersion());
        cdr.read_type_d(data.getName());
        VariablesPubSubType.read(data.getVariables(), cdr);
        ModelPubSubType.read(data.getModel(), cdr);
        cdr.read_type_d(data.getTimestamp());
        cdr.read_type_e(data.getCameras());
        VideoPubSubType.read(data.getVideo(), cdr);
    }

    public final void serialize(LogProperties data, InterchangeSerializer ser) {
        ser.write_type_d("version", data.getVersion());
        ser.write_type_d("name", data.getName());
        ser.write_type_a("variables", (TopicDataType)new VariablesPubSubType(), (Object)data.getVariables());
        ser.write_type_a("model", (TopicDataType)new ModelPubSubType(), (Object)data.getModel());
        ser.write_type_d("timestamp", data.getTimestamp());
        ser.write_type_e("cameras", data.getCameras());
        ser.write_type_a("video", (TopicDataType)new VideoPubSubType(), (Object)data.getVideo());
    }

    public final void deserialize(InterchangeSerializer ser, LogProperties data) {
        ser.read_type_d("version", data.getVersion());
        ser.read_type_d("name", data.getName());
        ser.read_type_a("variables", (TopicDataType)new VariablesPubSubType(), (Object)data.getVariables());
        ser.read_type_a("model", (TopicDataType)new ModelPubSubType(), (Object)data.getModel());
        ser.read_type_d("timestamp", data.getTimestamp());
        ser.read_type_e("cameras", data.getCameras());
        ser.read_type_a("video", (TopicDataType)new VideoPubSubType(), (Object)data.getVideo());
    }

    public static void staticCopy(LogProperties src, LogProperties dest) {
        dest.set(src);
    }

    public LogProperties createData() {
        return new LogProperties();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)LogPropertiesPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(LogProperties data, CDR cdr) {
        LogPropertiesPubSubType.write(data, cdr);
    }

    public void deserialize(LogProperties data, CDR cdr) {
        LogPropertiesPubSubType.read(data, cdr);
    }

    public void copy(LogProperties src, LogProperties dest) {
        LogPropertiesPubSubType.staticCopy(src, dest);
    }

    public LogPropertiesPubSubType newInstance() {
        return new LogPropertiesPubSubType();
    }
}

