/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.EnumType;
import us.ihmc.robotDataLogger.EnumTypePubSubType;
import us.ihmc.robotDataLogger.GraphicObjectMessage;
import us.ihmc.robotDataLogger.GraphicObjectMessagePubSubType;
import us.ihmc.robotDataLogger.Handshake;
import us.ihmc.robotDataLogger.JointDefinition;
import us.ihmc.robotDataLogger.JointDefinitionPubSubType;
import us.ihmc.robotDataLogger.ReferenceFrameInformationPubSubType;
import us.ihmc.robotDataLogger.SummaryPubSubType;
import us.ihmc.robotDataLogger.YoRegistryDefinition;
import us.ihmc.robotDataLogger.YoRegistryDefinitionPubSubType;
import us.ihmc.robotDataLogger.YoVariableDefinition;
import us.ihmc.robotDataLogger.YoVariableDefinitionPubSubType;

public class HandshakePubSubType
implements TopicDataType<Handshake> {
    public static final String name = "us::ihmc::robotDataLogger::Handshake";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public void serialize(Handshake data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        HandshakePubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, Handshake data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        HandshakePubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return HandshakePubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int i0;
        int initial_alignment = current_alignment;
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < 1024; ++i0) {
            current_alignment += YoRegistryDefinitionPubSubType.getMaxCdrSerializedSize(current_alignment);
        }
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < Short.MAX_VALUE; ++i0) {
            current_alignment += YoVariableDefinitionPubSubType.getMaxCdrSerializedSize(current_alignment);
        }
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < 128; ++i0) {
            current_alignment += JointDefinitionPubSubType.getMaxCdrSerializedSize(current_alignment);
        }
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < 2048; ++i0) {
            current_alignment += GraphicObjectMessagePubSubType.getMaxCdrSerializedSize(current_alignment);
        }
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < 2048; ++i0) {
            current_alignment += GraphicObjectMessagePubSubType.getMaxCdrSerializedSize(current_alignment);
        }
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < 1024; ++i0) {
            current_alignment += EnumTypePubSubType.getMaxCdrSerializedSize(current_alignment);
        }
        current_alignment += ReferenceFrameInformationPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += SummaryPubSubType.getMaxCdrSerializedSize(current_alignment);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(Handshake data) {
        return HandshakePubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(Handshake data, int current_alignment) {
        int i0;
        int initial_alignment = current_alignment;
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < data.getRegistries().size(); ++i0) {
            current_alignment += YoRegistryDefinitionPubSubType.getCdrSerializedSize((YoRegistryDefinition)((Object)data.getRegistries().get(i0)), current_alignment);
        }
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < data.getVariables().size(); ++i0) {
            current_alignment += YoVariableDefinitionPubSubType.getCdrSerializedSize((YoVariableDefinition)((Object)data.getVariables().get(i0)), current_alignment);
        }
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < data.getJoints().size(); ++i0) {
            current_alignment += JointDefinitionPubSubType.getCdrSerializedSize((JointDefinition)((Object)data.getJoints().get(i0)), current_alignment);
        }
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < data.getGraphicObjects().size(); ++i0) {
            current_alignment += GraphicObjectMessagePubSubType.getCdrSerializedSize((GraphicObjectMessage)((Object)data.getGraphicObjects().get(i0)), current_alignment);
        }
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < data.getArtifacts().size(); ++i0) {
            current_alignment += GraphicObjectMessagePubSubType.getCdrSerializedSize((GraphicObjectMessage)((Object)data.getArtifacts().get(i0)), current_alignment);
        }
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < data.getEnumTypes().size(); ++i0) {
            current_alignment += EnumTypePubSubType.getCdrSerializedSize((EnumType)((Object)data.getEnumTypes().get(i0)), current_alignment);
        }
        current_alignment += ReferenceFrameInformationPubSubType.getCdrSerializedSize(data.getReferenceFrameInformation(), current_alignment);
        current_alignment += SummaryPubSubType.getCdrSerializedSize(data.getSummary(), current_alignment);
        return current_alignment - initial_alignment;
    }

    public static void write(Handshake data, CDR cdr) {
        cdr.write_type_6(data.getDt());
        if (data.getRegistries().size() > 1024) {
            throw new RuntimeException("registries field exceeds the maximum length");
        }
        cdr.write_type_e(data.getRegistries());
        if (data.getVariables().size() > Short.MAX_VALUE) {
            throw new RuntimeException("variables field exceeds the maximum length");
        }
        cdr.write_type_e(data.getVariables());
        if (data.getJoints().size() > 128) {
            throw new RuntimeException("joints field exceeds the maximum length");
        }
        cdr.write_type_e(data.getJoints());
        if (data.getGraphicObjects().size() > 2048) {
            throw new RuntimeException("graphicObjects field exceeds the maximum length");
        }
        cdr.write_type_e(data.getGraphicObjects());
        if (data.getArtifacts().size() > 2048) {
            throw new RuntimeException("artifacts field exceeds the maximum length");
        }
        cdr.write_type_e(data.getArtifacts());
        if (data.getEnumTypes().size() > 1024) {
            throw new RuntimeException("enumTypes field exceeds the maximum length");
        }
        cdr.write_type_e(data.getEnumTypes());
        ReferenceFrameInformationPubSubType.write(data.getReferenceFrameInformation(), cdr);
        SummaryPubSubType.write(data.getSummary(), cdr);
    }

    public static void read(Handshake data, CDR cdr) {
        data.setDt(cdr.read_type_6());
        cdr.read_type_e(data.getRegistries());
        cdr.read_type_e(data.getVariables());
        cdr.read_type_e(data.getJoints());
        cdr.read_type_e(data.getGraphicObjects());
        cdr.read_type_e(data.getArtifacts());
        cdr.read_type_e(data.getEnumTypes());
        ReferenceFrameInformationPubSubType.read(data.getReferenceFrameInformation(), cdr);
        SummaryPubSubType.read(data.getSummary(), cdr);
    }

    public final void serialize(Handshake data, InterchangeSerializer ser) {
        ser.write_type_6("dt", data.getDt());
        ser.write_type_e("registries", data.getRegistries());
        ser.write_type_e("variables", data.getVariables());
        ser.write_type_e("joints", data.getJoints());
        ser.write_type_e("graphicObjects", data.getGraphicObjects());
        ser.write_type_e("artifacts", data.getArtifacts());
        ser.write_type_e("enumTypes", data.getEnumTypes());
        ser.write_type_a("referenceFrameInformation", (TopicDataType)new ReferenceFrameInformationPubSubType(), (Object)data.getReferenceFrameInformation());
        ser.write_type_a("summary", (TopicDataType)new SummaryPubSubType(), (Object)data.getSummary());
    }

    public final void deserialize(InterchangeSerializer ser, Handshake data) {
        data.setDt(ser.read_type_6("dt"));
        ser.read_type_e("registries", data.getRegistries());
        ser.read_type_e("variables", data.getVariables());
        ser.read_type_e("joints", data.getJoints());
        ser.read_type_e("graphicObjects", data.getGraphicObjects());
        ser.read_type_e("artifacts", data.getArtifacts());
        ser.read_type_e("enumTypes", data.getEnumTypes());
        ser.read_type_a("referenceFrameInformation", (TopicDataType)new ReferenceFrameInformationPubSubType(), (Object)data.getReferenceFrameInformation());
        ser.read_type_a("summary", (TopicDataType)new SummaryPubSubType(), (Object)data.getSummary());
    }

    public static void staticCopy(Handshake src, Handshake dest) {
        dest.set(src);
    }

    public Handshake createData() {
        return new Handshake();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)HandshakePubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(Handshake data, CDR cdr) {
        HandshakePubSubType.write(data, cdr);
    }

    public void deserialize(Handshake data, CDR cdr) {
        HandshakePubSubType.read(data, cdr);
    }

    public void copy(Handshake src, Handshake dest) {
        HandshakePubSubType.staticCopy(src, dest);
    }

    public HandshakePubSubType newInstance() {
        return new HandshakePubSubType();
    }
}

