/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.AppearanceDefinitionMessagePubSubType;
import us.ihmc.robotDataLogger.GraphicObjectMessage;

public class GraphicObjectMessagePubSubType
implements TopicDataType<GraphicObjectMessage> {
    public static final String name = "us::ihmc::robotDataLogger::GraphicObjectMessage";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public void serialize(GraphicObjectMessage data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        GraphicObjectMessagePubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, GraphicObjectMessage data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        GraphicObjectMessagePubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return GraphicObjectMessagePubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 2048 + CDR.alignment((int)current_alignment, (int)2);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 1024 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += AppearanceDefinitionMessagePubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(GraphicObjectMessage data) {
        return GraphicObjectMessagePubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(GraphicObjectMessage data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getName().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += data.getYoVariableIndex().size() * 2 + CDR.alignment((int)current_alignment, (int)2);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += data.getConstants().size() * 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += AppearanceDefinitionMessagePubSubType.getCdrSerializedSize(data.getAppearance(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getListName().length() + 1;
        return current_alignment - initial_alignment;
    }

    public static void write(GraphicObjectMessage data, CDR cdr) {
        cdr.write_type_2(data.getRegistrationID());
        if (data.getName().length() > 255) {
            throw new RuntimeException("name field exceeds the maximum length");
        }
        cdr.write_type_d(data.getName());
        if (data.getYoVariableIndex().size() > 1024) {
            throw new RuntimeException("yoVariableIndex field exceeds the maximum length");
        }
        cdr.write_type_e((IDLSequence)data.getYoVariableIndex());
        if (data.getConstants().size() > 128) {
            throw new RuntimeException("constants field exceeds the maximum length");
        }
        cdr.write_type_e((IDLSequence)data.getConstants());
        AppearanceDefinitionMessagePubSubType.write(data.getAppearance(), cdr);
        if (data.getListName().length() > 255) {
            throw new RuntimeException("listName field exceeds the maximum length");
        }
        cdr.write_type_d(data.getListName());
    }

    public static void read(GraphicObjectMessage data, CDR cdr) {
        data.setRegistrationID(cdr.read_type_2());
        cdr.read_type_d(data.getName());
        cdr.read_type_e((IDLSequence)data.getYoVariableIndex());
        cdr.read_type_e((IDLSequence)data.getConstants());
        AppearanceDefinitionMessagePubSubType.read(data.getAppearance(), cdr);
        cdr.read_type_d(data.getListName());
    }

    public final void serialize(GraphicObjectMessage data, InterchangeSerializer ser) {
        ser.write_type_2("registrationID", data.getRegistrationID());
        ser.write_type_d("name", data.getName());
        ser.write_type_e("yoVariableIndex", (IDLSequence)data.getYoVariableIndex());
        ser.write_type_e("constants", (IDLSequence)data.getConstants());
        ser.write_type_a("appearance", (TopicDataType)new AppearanceDefinitionMessagePubSubType(), (Object)data.getAppearance());
        ser.write_type_d("listName", data.getListName());
    }

    public final void deserialize(InterchangeSerializer ser, GraphicObjectMessage data) {
        data.setRegistrationID(ser.read_type_2("registrationID"));
        ser.read_type_d("name", data.getName());
        ser.read_type_e("yoVariableIndex", (IDLSequence)data.getYoVariableIndex());
        ser.read_type_e("constants", (IDLSequence)data.getConstants());
        ser.read_type_a("appearance", (TopicDataType)new AppearanceDefinitionMessagePubSubType(), (Object)data.getAppearance());
        ser.read_type_d("listName", data.getListName());
    }

    public static void staticCopy(GraphicObjectMessage src, GraphicObjectMessage dest) {
        dest.set(src);
    }

    public GraphicObjectMessage createData() {
        return new GraphicObjectMessage();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)GraphicObjectMessagePubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(GraphicObjectMessage data, CDR cdr) {
        GraphicObjectMessagePubSubType.write(data, cdr);
    }

    public void deserialize(GraphicObjectMessage data, CDR cdr) {
        GraphicObjectMessagePubSubType.read(data, cdr);
    }

    public void copy(GraphicObjectMessage src, GraphicObjectMessage dest) {
        GraphicObjectMessagePubSubType.staticCopy(src, dest);
    }

    public GraphicObjectMessagePubSubType newInstance() {
        return new GraphicObjectMessagePubSubType();
    }
}

