/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.websocket.client.discovery;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import us.ihmc.idl.serializers.extra.JSONSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.robotDataLogger.Announcement;
import us.ihmc.robotDataLogger.AnnouncementPubSubType;
import us.ihmc.robotDataLogger.websocket.client.discovery.HTTPDataServerDescription;

public class HTTPDataServerConnection {
    private static final int TIMEOUT_MS = 1000;
    private final EventLoopGroup group = new NioEventLoopGroup();
    private final HTTPDataServerDescription target;
    private final HTTPDataServerConnectionListener listener;
    private final Announcement announcement = new Announcement();
    private Channel channel;
    private CompletableFuture<ByteBuf> requestFuture;
    private ByteBuf requestedBuffer;
    private boolean taken = false;

    public static HTTPDataServerConnection connect(String host, int port) throws IOException {
        HTTPDataServerDescription target = new HTTPDataServerDescription(host, port, null, false);
        final CompletableFuture connectionFuture = new CompletableFuture();
        new HTTPDataServerConnection(target, new HTTPDataServerConnectionListener(){

            @Override
            public void connectionRefused(HTTPDataServerDescription target) {
                connectionFuture.completeExceptionally(new IOException("Connection refused"));
            }

            @Override
            public void connected(HTTPDataServerConnection connection) {
                connectionFuture.complete(connection);
            }
        });
        try {
            return (HTTPDataServerConnection)connectionFuture.get();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public HTTPDataServerConnection(HTTPDataServerDescription target, HTTPDataServerConnectionListener listener) {
        this.target = target;
        this.listener = listener;
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new HttpSnoopClientInitializer());
        b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)1000);
        ChannelFuture connectFuture = b.connect(target.getHost(), target.getPort());
        connectFuture.addListener(f -> {
            if (f.isSuccess()) {
                this.connected(((ChannelFuture)f.sync()).channel());
            } else {
                this.group.shutdownGracefully().addListener(e -> listener.connectionRefused(target));
            }
        });
    }

    private void connected(Channel channel) {
        this.channel = channel;
        this.requestResource("/announcement.json", buf -> this.receivedAnnouncement((ByteBuf)buf));
    }

    public boolean isConnected() {
        if (this.channel != null) {
            return this.channel.isActive();
        }
        return false;
    }

    private void receivedAnnouncement(ByteBuf buf) {
        JSONSerializer serializer = new JSONSerializer((TopicDataType)new AnnouncementPubSubType());
        try {
            this.announcement.set((Announcement)((Object)serializer.deserialize(buf.toString(CharsetUtil.UTF_8))));
            this.listener.connected(this);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.channel.close();
        }
    }

    public Future<ByteBuf> requestResource(String path) {
        return this.requestResource(path, null);
    }

    public Future<ByteBuf> requestResource(String path, Consumer<ByteBuf> action) {
        if (this.requestFuture != null && !this.requestFuture.isDone()) {
            throw new RuntimeException("Previous request still pending");
        }
        this.requestFuture = new CompletableFuture();
        if (action != null) {
            this.requestFuture.thenAccept((Consumer)action);
        }
        if (this.channel != null) {
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, path);
            request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)this.target);
            request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            request.headers().set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.GZIP);
            try {
                this.channel.writeAndFlush((Object)request).syncUninterruptibly();
            }
            catch (Exception e) {
                this.requestFuture.completeExceptionally(e);
                this.channel.close();
            }
        } else {
            this.requestFuture.completeExceptionally(new IOException("Channel not open"));
        }
        return this.requestFuture;
    }

    public void close() {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    public DisconnectPromise take() {
        this.taken = true;
        this.channel.close();
        return new DisconnectPromise(this.listener, this);
    }

    public HTTPDataServerDescription getTarget() {
        return this.target;
    }

    public Announcement getAnnouncement() {
        return this.announcement;
    }

    public static void main(String[] args) {
        new HTTPDataServerConnection(new HTTPDataServerDescription("127.0.0.1", 8008, null, false), new HTTPDataServerConnectionListener(){

            @Override
            public void disconnected(HTTPDataServerConnection connection) {
                System.out.println("Disconnected");
            }

            @Override
            public void connectionRefused(HTTPDataServerDescription target) {
                System.out.println("Connection refused");
            }

            @Override
            public void connected(HTTPDataServerConnection connection) {
                System.out.println("Connected");
            }

            @Override
            public void closed(HTTPDataServerConnection httpDataServerConnection) {
                System.out.println("Connection closed");
            }
        });
    }

    private class Handler
    extends SimpleChannelInboundHandler<HttpObject> {
        private Handler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
            if (msg instanceof HttpResponse || msg instanceof HttpContent) {
                if (HTTPDataServerConnection.this.requestFuture == null || HTTPDataServerConnection.this.requestFuture.isDone()) {
                    throw new IOException("HTTP response received without matching request");
                }
                if (msg instanceof HttpResponse) {
                    HttpResponse response = (HttpResponse)msg;
                    if (response.status() != HttpResponseStatus.OK) {
                        HTTPDataServerConnection.this.requestFuture.completeExceptionally(new IOException("Invalid response received " + response.status()));
                        ctx.close();
                        return;
                    }
                    int contentLength = response.headers().getInt((CharSequence)"content-length", 0);
                    if (contentLength <= 0) {
                        HTTPDataServerConnection.this.requestFuture.completeExceptionally(new IOException("No content-length set."));
                        ctx.close();
                        return;
                    }
                    HTTPDataServerConnection.this.requestedBuffer = Unpooled.buffer((int)contentLength);
                }
                if (msg instanceof HttpContent) {
                    HttpContent content = (HttpContent)msg;
                    if (!HTTPDataServerConnection.this.requestedBuffer.isWritable(content.content().readableBytes())) {
                        HTTPDataServerConnection.this.requestFuture.completeExceptionally(new IOException("Content-length exceeds allocated space"));
                        ctx.close();
                        return;
                    }
                    HTTPDataServerConnection.this.requestedBuffer.writeBytes(((HttpContent)msg).content());
                    if (content instanceof LastHttpContent) {
                        HTTPDataServerConnection.this.requestFuture.complete(HTTPDataServerConnection.this.requestedBuffer);
                        HTTPDataServerConnection.this.requestedBuffer = null;
                    }
                }
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            if (!HTTPDataServerConnection.this.taken) {
                HTTPDataServerConnection.this.listener.disconnected(HTTPDataServerConnection.this);
                HTTPDataServerConnection.this.group.shutdownGracefully().addListener(e -> HTTPDataServerConnection.this.listener.closed(HTTPDataServerConnection.this));
            } else {
                HTTPDataServerConnection.this.group.shutdownGracefully();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            cause.printStackTrace();
            ctx.close();
        }
    }

    private class HttpSnoopClientInitializer
    extends ChannelInitializer<SocketChannel> {
        public void initChannel(SocketChannel ch) {
            ChannelPipeline p = ch.pipeline();
            p.addLast(new ChannelHandler[]{new HttpClientCodec()});
            p.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
            p.addLast(new ChannelHandler[]{new Handler()});
        }
    }

    public static class DisconnectPromise {
        private final HTTPDataServerConnectionListener listener;
        private final HTTPDataServerConnection connection;

        private DisconnectPromise(HTTPDataServerConnectionListener listener, HTTPDataServerConnection connection) {
            this.listener = listener;
            this.connection = connection;
        }

        public void complete() {
            this.listener.disconnected(this.connection);
            this.listener.closed(this.connection);
        }
    }

    public static interface HTTPDataServerConnectionListener {
        public void connected(HTTPDataServerConnection var1);

        default public void disconnected(HTTPDataServerConnection connection) {
        }

        public void connectionRefused(HTTPDataServerDescription var1);

        default public void closed(HTTPDataServerConnection httpDataServerConnection) {
        }
    }
}

