/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.websocket.client;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import us.ihmc.robotDataLogger.listeners.TimestampListener;

public class UDPTimestampClient {
    private final DatagramSocket clientSocket;
    private final int port;
    private final Thread thread;
    private volatile boolean running = true;
    private final TimestampListener listener;

    public UDPTimestampClient(TimestampListener listener) throws SocketException {
        this.listener = listener;
        this.clientSocket = new DatagramSocket();
        this.clientSocket.setSoTimeout(100);
        this.port = this.clientSocket.getLocalPort();
        this.thread = new Thread((Runnable)new ReceiveThread(), this.getClass().getSimpleName() + "Recieve");
    }

    public void start() {
        if (!this.running || this.thread.isAlive()) {
            throw new RuntimeException("Thread already started");
        }
        this.thread.start();
    }

    public int getPort() {
        return this.port;
    }

    public void stop() {
        this.running = false;
    }

    public void join() {
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class ReceiveThread
    implements Runnable {
        private ReceiveThread() {
        }

        @Override
        public void run() {
            byte[] data = new byte[12];
            ByteBuffer wrappedData = ByteBuffer.wrap(data);
            DatagramPacket incoming = new DatagramPacket(data, 12);
            while (UDPTimestampClient.this.running) {
                try {
                    UDPTimestampClient.this.clientSocket.receive(incoming);
                    if (wrappedData.getInt(0) != 1563802659) continue;
                    UDPTimestampClient.this.listener.receivedTimestampOnly(wrappedData.getLong(4));
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

