/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.jointState;

import java.nio.DoubleBuffer;
import java.nio.LongBuffer;
import java.util.List;
import us.ihmc.robotDataLogger.JointType;
import us.ihmc.robotDataLogger.jointState.OneDoFState;
import us.ihmc.robotDataLogger.jointState.SixDoFState;

public abstract class JointState {
    private final JointType type;
    private final String name;

    public JointState(String name, JointType type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public JointType getType() {
        return this.type;
    }

    public abstract void update(LongBuffer var1);

    public abstract void update(DoubleBuffer var1);

    public abstract void get(double[] var1);

    public abstract void get(LongBuffer var1);

    public abstract int getNumberOfStateVariables();

    public static int getNumberOfVariables(JointType type) {
        switch (type) {
            case OneDoFJoint: {
                return 2;
            }
            case SiXDoFJoint: {
                return 13;
            }
        }
        throw new RuntimeException("Unknown joint type" + (Object)((Object)type));
    }

    public static JointState createJointState(String name, JointType type) {
        switch (type) {
            case OneDoFJoint: {
                return new OneDoFState(name);
            }
            case SiXDoFJoint: {
                return new SixDoFState(name);
            }
        }
        throw new RuntimeException("Unknown joint type" + (Object)((Object)type));
    }

    public static int getNumberOfJointStates(List<JointState> jointStates) {
        int numberOfJointStates = 0;
        for (int i = 0; i < jointStates.size(); ++i) {
            numberOfJointStates += jointStates.get(i).getNumberOfStateVariables();
        }
        return numberOfJointStates;
    }
}

