/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.dataBuffers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import us.ihmc.concurrent.Builder;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.robotDataLogger.dataBuffers.LoggerDebugRegistry;
import us.ihmc.robotDataLogger.dataBuffers.RegistrySendBuffer;
import us.ihmc.robotDataLogger.jointState.JointHolder;
import us.ihmc.robotDataLogger.jointState.JointHolderFactory;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class RegistrySendBufferBuilder
implements Builder<RegistrySendBuffer> {
    private final YoRegistry registry;
    private final List<? extends JointBasics> jointsToPublish;
    private final List<YoVariable> variables = new ArrayList<YoVariable>();
    private final List<JointHolder> jointHolders = new ArrayList<JointHolder>();
    private final LoggerDebugRegistry loggerDebugRegistry;
    private final YoGraphicsListRegistry graphics;
    private int registryID = -1;

    public RegistrySendBufferBuilder(YoRegistry registry, YoGraphicsListRegistry graphics) {
        this(registry, Collections.emptyList(), graphics);
    }

    public RegistrySendBufferBuilder(YoRegistry registry, RigidBodyBasics rootBody, YoGraphicsListRegistry graphics) {
        this(registry, rootBody == null ? Collections.emptyList() : SubtreeStreams.fromChildren(JointBasics.class, (RigidBodyReadOnly)rootBody).collect(Collectors.toList()), graphics);
    }

    public RegistrySendBufferBuilder(YoRegistry registry, List<? extends JointBasics> jointsToPublish, YoGraphicsListRegistry graphics) {
        this.registry = registry;
        this.jointsToPublish = jointsToPublish;
        this.graphics = graphics;
        this.loggerDebugRegistry = new LoggerDebugRegistry(registry);
    }

    public YoRegistry getYoRegistry() {
        return this.registry;
    }

    public List<YoVariable> getVariables() {
        return this.variables;
    }

    public void build(int registryID) {
        this.registryID = registryID;
        if (this.jointsToPublish != null) {
            for (JointBasics jointBasics : this.jointsToPublish) {
                JointHolder jointHolder = JointHolderFactory.getJointHolder(jointBasics);
                this.jointHolders.add(jointHolder);
            }
        }
    }

    public List<JointHolder> getJointHolders() {
        return this.jointHolders;
    }

    public YoGraphicsListRegistry getYoGraphicsListRegistry() {
        return this.graphics;
    }

    public RegistrySendBuffer newInstance() {
        if (this.registryID == -1) {
            throw new RuntimeException("RegistrySendBufferBuilder.build() not called");
        }
        if (this.variables.size() == 0) {
            throw new RuntimeException("Variables not populated");
        }
        return new RegistrySendBuffer(this.registryID, this.variables, this.jointHolders);
    }

    public int getRegistryID() {
        return this.registryID;
    }

    public int getNumberOfJointStates() {
        return RegistrySendBufferBuilder.getNumberOfJointStates(this.jointHolders);
    }

    public int getNumberOfVariables() {
        return this.variables.size();
    }

    public static int getNumberOfJointStates(List<JointHolder> jointHolders) {
        int numberOfJointStates = 0;
        for (int i = 0; i < jointHolders.size(); ++i) {
            numberOfJointStates += jointHolders.get(i).getNumberOfStateVariables();
        }
        return numberOfJointStates;
    }

    public LoggerDebugRegistry getLoggerDebugRegistry() {
        return this.loggerDebugRegistry;
    }
}

