/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import us.ihmc.commons.MathTools;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.Announcement;
import us.ihmc.robotDataLogger.Handshake;
import us.ihmc.robotDataLogger.HandshakeFileType;
import us.ihmc.robotDataLogger.YoVariableClientInterface;
import us.ihmc.robotDataLogger.YoVariablesUpdatedListener;
import us.ihmc.robotDataLogger.handshake.IDLYoVariableHandshakeParser;
import us.ihmc.robotDataLogger.handshake.LogHandshake;
import us.ihmc.robotDataLogger.interfaces.VariableChangedProducer;
import us.ihmc.robotDataLogger.util.DaemonThreadFactory;
import us.ihmc.robotDataLogger.util.DebugRegistry;
import us.ihmc.robotDataLogger.websocket.client.WebsocketDataConsumer;
import us.ihmc.robotDataLogger.websocket.client.discovery.HTTPDataServerConnection;
import us.ihmc.robotDataLogger.websocket.command.DataServerCommand;

public class YoVariableClientImplementation
implements YoVariableClientInterface {
    private String serverName;
    private final VariableChangedProducer variableChangedProducer;
    private final Executor commandExecutor = Executors.newSingleThreadExecutor(DaemonThreadFactory.getNamedDaemonThreadFactory(this.getClass().getSimpleName()));
    private final YoVariablesUpdatedListener yoVariablesUpdatedListener;
    private WebsocketDataConsumer dataConsumer;

    YoVariableClientImplementation(YoVariablesUpdatedListener yoVariablesUpdatedListener) {
        this.yoVariablesUpdatedListener = yoVariablesUpdatedListener;
        this.variableChangedProducer = yoVariablesUpdatedListener.changesVariables() ? new VariableChangedProducer() : null;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    public void connectionClosed() {
        LogTools.info((String)"Disconnected, closing client.");
        this.yoVariablesUpdatedListener.disconnected();
    }

    public synchronized void start(int timeout, HTTPDataServerConnection connection) throws IOException {
        if (this.dataConsumer != null) {
            throw new RuntimeException("Client already started");
        }
        Announcement announcement = connection.getAnnouncement();
        this.dataConsumer = new WebsocketDataConsumer(connection, timeout);
        this.serverName = connection.getAnnouncement().getNameAsString();
        LogTools.info((String)"Requesting handshake from {}", (Object)connection.getAnnouncement().getHostNameAsString());
        Handshake handshake = this.dataConsumer.getHandshake();
        IDLYoVariableHandshakeParser handshakeParser = new IDLYoVariableHandshakeParser(HandshakeFileType.IDL_CDR);
        handshakeParser.parseFrom(handshake);
        LogHandshake logHandshake = new LogHandshake();
        logHandshake.setHandshake(handshake);
        if (announcement.getModelFileDescription().getHasModel()) {
            String modelName = announcement.getModelFileDescription().getNameAsString();
            logHandshake.setModelName(modelName);
            LogTools.info((String)("Requesting model file from " + modelName));
            logHandshake.setModel(this.dataConsumer.getModelFile());
            logHandshake.setModelLoaderClass(announcement.getModelFileDescription().getModelLoaderClassAsString());
            logHandshake.setResourceDirectories(announcement.getModelFileDescription().getResourceDirectories().toStringArray());
            if (announcement.getModelFileDescription().getHasResourceZip()) {
                LogTools.info((String)"Requesting resource bundle");
                logHandshake.setResourceZip(this.dataConsumer.getResourceZip());
            }
            LogTools.info((String)"Received model");
        }
        if (this.variableChangedProducer != null) {
            this.variableChangedProducer.startVariableChangedProducers(handshakeParser.getYoVariablesList(), this.dataConsumer);
        }
        DebugRegistry debugRegistry = new DebugRegistry();
        this.yoVariablesUpdatedListener.start(this, logHandshake, handshakeParser, debugRegistry);
        this.connectToSession(handshakeParser, debugRegistry);
    }

    void connectToSession(IDLYoVariableHandshakeParser handshakeParser, DebugRegistry debugRegistry) throws IOException {
        if (this.dataConsumer.isSessionActive()) {
            throw new RuntimeException("Client already connected");
        }
        if (this.dataConsumer.isClosed()) {
            throw new RuntimeException("Client has closed completely");
        }
        this.dataConsumer.startSession(handshakeParser, this, this.variableChangedProducer, this.yoVariablesUpdatedListener, this.yoVariablesUpdatedListener, debugRegistry);
    }

    @Override
    public synchronized void stop() {
        if (this.dataConsumer == null) {
            throw new RuntimeException("Session not started");
        }
        this.dataConsumer.close();
        this.dataConsumer = null;
    }

    @Override
    public void sendClearLogRequest() {
        try {
            this.dataConsumer.sendCommand(DataServerCommand.CLEAR_LOG, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void receivedTimestampAndData(long timestamp) {
        this.yoVariablesUpdatedListener.receivedTimestampAndData(timestamp);
    }

    @Override
    public void disconnect() {
        this.dataConsumer.disconnectSession();
    }

    @Override
    public synchronized boolean reconnect() throws IOException {
        if (this.dataConsumer == null) {
            throw new RuntimeException("Session not started");
        }
        return this.dataConsumer.reconnect();
    }

    public void receivedCommand(DataServerCommand command, int argument) {
        this.commandExecutor.execute(() -> this.yoVariablesUpdatedListener.receivedCommand(command, argument));
    }

    public void connected() {
        this.yoVariablesUpdatedListener.connected();
    }

    @Override
    public void setVariableUpdateRate(int updateRate) {
        updateRate = MathTools.clamp((int)updateRate, (int)0, (int)99999);
        try {
            this.dataConsumer.sendCommand(DataServerCommand.LIMIT_RATE, updateRate);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isConnected() {
        return this.dataConsumer != null && this.dataConsumer.isSessionActive();
    }

    @Override
    public void sendCommand(DataServerCommand command, int argument) {
        try {
            this.dataConsumer.sendCommand(command, argument);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setVariableSynchronizer(Object variableSynchronizer) {
        this.dataConsumer.setVariableSynchronizer(variableSynchronizer);
    }
}

