/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.YoVariableClientImplementation;
import us.ihmc.robotDataLogger.YoVariablesUpdatedListener;
import us.ihmc.robotDataLogger.gui.DataServerSelectorGUI;
import us.ihmc.robotDataLogger.rtps.LogProducerDisplay;
import us.ihmc.robotDataLogger.websocket.client.discovery.HTTPDataServerConnection;

public class YoVariableClient {
    public static final int DEFAULT_TIMEOUT = 25000;
    private final YoVariableClientImplementation yoVariableClientImplementation;

    @Deprecated
    public YoVariableClient(YoVariablesUpdatedListener listener, LogProducerDisplay.LogSessionFilter ... filters) {
        this(listener);
    }

    public YoVariableClient(YoVariablesUpdatedListener listener) {
        this.yoVariableClientImplementation = new YoVariableClientImplementation(listener);
    }

    @Deprecated
    public void start() {
        this.startWithHostSelector();
    }

    public void startWithHostSelector() {
        this.startWithHostSelector(true);
    }

    public void startWithHostSelector(boolean enableAutoDiscovery) {
        DataServerSelectorGUI selector = new DataServerSelectorGUI(enableAutoDiscovery);
        HTTPDataServerConnection connection = selector.select();
        if (connection != null) {
            try {
                this.start(25000, connection);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(0);
            }
        } else {
            LogTools.warn((String)"No host selected. Shutting down.");
            System.exit(0);
        }
    }

    public void start(String host, int port) {
        try {
            HTTPDataServerConnection connection = HTTPDataServerConnection.connect(host, port);
            this.start(25000, connection);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void start(int timeout, HTTPDataServerConnection connection) throws IOException {
        this.yoVariableClientImplementation.start(timeout, connection);
    }

    public void stop() {
        this.yoVariableClientImplementation.stop();
    }

    public void reconnect() throws IOException {
        this.yoVariableClientImplementation.reconnect();
    }

    public void disconnect() {
        this.yoVariableClientImplementation.disconnect();
    }

    public void setVariableSynchronizer(Object variableSynchronizer) {
        this.yoVariableClientImplementation.setVariableSynchronizer(variableSynchronizer);
    }
}

