/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import gnu.trove.list.array.TByteArrayList;
import java.io.File;
import java.io.IOException;
import us.ihmc.idl.serializers.extra.PropertiesSerializer;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.robotDataLogger.LoggerConfiguration;
import us.ihmc.robotDataLogger.LoggerConfigurationPubSubType;

public class LoggerConfigurationLoader {
    public static final String location = System.getProperty("user.home") + File.separator + ".ihmc" + File.separator + "IHMCLoggerConfiguration.ini";
    private final boolean publicBroadcast;
    private final TByteArrayList cameras = new TByteArrayList();

    public LoggerConfigurationLoader() throws IOException {
        PropertiesSerializer ser = new PropertiesSerializer((TopicDataType)new LoggerConfigurationPubSubType());
        boolean publicBroadcast = false;
        String cameraString = null;
        File in = new File(location);
        if (in.exists()) {
            LoggerConfiguration config = (LoggerConfiguration)((Object)ser.deserialize(in));
            publicBroadcast = config.getPublicBroadcast();
            cameraString = config.getCamerasToCaptureAsString();
        }
        String publicFromCmd = System.getProperty("ihmc.publicBroadcast");
        String cameraFromCmd = System.getProperty("ihmc.camerasToCapture");
        if (publicFromCmd != null) {
            publicBroadcast = Boolean.parseBoolean(publicFromCmd);
        }
        if (cameraFromCmd != null) {
            cameraString = cameraFromCmd;
        }
        if (!publicBroadcast) {
            LogTools.warn((String)("Public broadcasting of logger data is OFF. The logger will only connect to your local computer. To enable public broadcasting, add \"publicBroadcast=true\" to " + location + " or pass in -Dihmc.publicBroadcast=true"));
        }
        this.publicBroadcast = publicBroadcast;
        if (cameraString != null && !cameraString.trim().isEmpty()) {
            String[] split = cameraString.split(",");
            for (int i = 0; i < split.length; ++i) {
                try {
                    byte camera = Byte.parseByte(split[i].trim());
                    if (camera < 0 || camera > 127) {
                        throw new NumberFormatException();
                    }
                    this.cameras.add(camera);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IOException("Invalid camera id " + split[i].trim() + ",  Please edit " + location + " or pass in a camera list with -Dihmc.camerasToCapture=[cameras, comma seperated]");
                }
            }
        }
    }

    public boolean getPublicBroadcast() {
        return this.publicBroadcast;
    }

    public TByteArrayList getCameras() {
        return this.cameras;
    }

    public static void main(String[] args) throws IOException {
        new LoggerConfigurationLoader();
        LoggerConfiguration config = new LoggerConfiguration();
        LoggerConfigurationPubSubType type = new LoggerConfigurationPubSubType();
        PropertiesSerializer ser = new PropertiesSerializer((TopicDataType)type);
        LogTools.info((String)ser.serializeToString((Object)config));
    }
}

