/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.CameraAnnouncement;
import us.ihmc.robotDataLogger.CameraType;

public class CameraAnnouncementPubSubType
implements TopicDataType<CameraAnnouncement> {
    public static final String name = "us::ihmc::robotDataLogger::CameraAnnouncement";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public void serialize(CameraAnnouncement data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        CameraAnnouncementPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, CameraAnnouncement data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        CameraAnnouncementPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return CameraAnnouncementPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(CameraAnnouncement data) {
        return CameraAnnouncementPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(CameraAnnouncement data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getName().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getIdentifier().length() + 1;
        return current_alignment - initial_alignment;
    }

    public static void write(CameraAnnouncement data, CDR cdr) {
        cdr.write_type_c(data.getType().ordinal());
        if (data.getName().length() > 255) {
            throw new RuntimeException("name field exceeds the maximum length");
        }
        cdr.write_type_d(data.getName());
        if (data.getIdentifier().length() > 255) {
            throw new RuntimeException("identifier field exceeds the maximum length");
        }
        cdr.write_type_d(data.getIdentifier());
    }

    public static void read(CameraAnnouncement data, CDR cdr) {
        data.setType(CameraType.values[cdr.read_type_c()]);
        cdr.read_type_d(data.getName());
        cdr.read_type_d(data.getIdentifier());
    }

    public final void serialize(CameraAnnouncement data, InterchangeSerializer ser) {
        ser.write_type_c("type", (Enum)data.getType());
        ser.write_type_d("name", data.getName());
        ser.write_type_d("identifier", data.getIdentifier());
    }

    public final void deserialize(InterchangeSerializer ser, CameraAnnouncement data) {
        data.setType((CameraType)ser.read_type_c("type", CameraType.class));
        ser.read_type_d("name", data.getName());
        ser.read_type_d("identifier", data.getIdentifier());
    }

    public static void staticCopy(CameraAnnouncement src, CameraAnnouncement dest) {
        dest.set(src);
    }

    public CameraAnnouncement createData() {
        return new CameraAnnouncement();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)CameraAnnouncementPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(CameraAnnouncement data, CDR cdr) {
        CameraAnnouncementPubSubType.write(data, cdr);
    }

    public void deserialize(CameraAnnouncement data, CDR cdr) {
        CameraAnnouncementPubSubType.read(data, cdr);
    }

    public void copy(CameraAnnouncement src, CameraAnnouncement dest) {
        CameraAnnouncementPubSubType.staticCopy(src, dest);
    }

    public CameraAnnouncementPubSubType newInstance() {
        return new CameraAnnouncementPubSubType();
    }
}

