/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.rtps;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.ReliabilityKind;
import us.ihmc.pubsub.common.LogLevel;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.SampleInfo;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;
import us.ihmc.robotDataLogger.VariableChangeRequest;
import us.ihmc.robotDataLogger.VariableChangeRequestPubSubType;

public class VariableChangeRequestTest {
    @Test
    public void testSendingVariableChangedMessage() throws IOException {
        Domain domain = DomainFactory.getDomain((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS);
        domain.setLogLevel(LogLevel.WARNING);
        ParticipantAttributes attr = domain.createParticipantAttributes(1, "TestParticipant");
        attr.bindToLocalhost();
        Participant participant = domain.createParticipant(attr);
        VariableChangeRequestPubSubType type = new VariableChangeRequestPubSubType();
        Publisher publisher1 = domain.createPublisher(participant, domain.createPublisherAttributes(participant, (TopicDataType)type, "testTopic", ReliabilityKind.RELIABLE, new String[]{"us/ihmc"}));
        Publisher publisher2 = domain.createPublisher(participant, domain.createPublisherAttributes(participant, (TopicDataType)type, "testTopic", ReliabilityKind.RELIABLE, new String[]{"us/ihmc"}));
        final AtomicInteger receivedMessages = new AtomicInteger(0);
        SubscriberListener listener = new SubscriberListener(){

            public void onSubscriptionMatched(Subscriber subscriber, MatchingInfo info) {
                if (info.getStatus() == MatchingInfo.MatchingStatus.MATCHED_MATCHING) {
                    System.out.println("Connected " + info.getGuid());
                } else {
                    System.out.println("Disconnected " + info.getGuid());
                }
            }

            public void onNewDataMessage(Subscriber subscriber) {
                VariableChangeRequest req = new VariableChangeRequest();
                SampleInfo info = new SampleInfo();
                if (subscriber.takeNextData((Object)req, info)) {
                    receivedMessages.incrementAndGet();
                } else {
                    System.err.println("Could not decode message");
                }
            }
        };
        domain.createSubscriber(participant, domain.createSubscriberAttributes(participant, (TopicDataType)type, "testTopic", ReliabilityKind.RELIABLE, new String[]{"us/ihmc"}), listener);
        ThreadTools.sleep((long)1000L);
        for (int i = 0; i < 10; ++i) {
            VariableChangeRequest msg = new VariableChangeRequest();
            msg.setVariableID(i + 100);
            msg.setRequestedValue((double)i * 13.37);
            publisher1.write((Object)msg);
            VariableChangeRequest msg2 = new VariableChangeRequest();
            msg2.setVariableID(i + 200);
            msg2.setRequestedValue((double)i * 2.0);
            publisher2.write((Object)msg2);
            ThreadTools.sleep((long)100L);
        }
        Assertions.assertEquals((int)20, (int)receivedMessages.get());
    }
}

