/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.captureVideo;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.bytedeco.javacv.Frame;
import us.ihmc.log.LogTools;
import us.ihmc.tools.CaptureTimeTools;

public class ExampleBytedecoJavaCVWindowsScreenRecord {
    private static long startTime = 0L;
    public static String videoPath = "ihmc-robot-data-logger/out/windowsBytedecoScreenRecordingVideo.mov";
    public static final String timestampPath = "ihmc-robot-data-logger/out/windowsBytedecoScreenRecordingTimestamps.dat";
    private static FileWriter timestampWriter;
    public static File videoFile;
    public static File timestampFile;

    public static void main(String[] args) throws IOException {
        try (FFmpegFrameGrabber grabber = new FFmpegFrameGrabber("desktop");){
            grabber.setFormat("gdigrab");
            grabber.setFrameRate(60.0);
            grabber.start();
            ExampleBytedecoJavaCVWindowsScreenRecord.setupTimestampWriter();
            try (FFmpegFrameRecorder recorder = new FFmpegFrameRecorder(videoFile, 1280, 720);){
                Frame capturedFrame;
                recorder.setVideoOption("tune", "zerolatency");
                recorder.setVideoCodec(12);
                recorder.setFormat("mov");
                recorder.setFrameRate(60.0);
                recorder.start();
                for (int timer = 0; timer < 50 && (capturedFrame = grabber.grab()) != null; ++timer) {
                    long videoTS;
                    if (startTime == 0L) {
                        startTime = System.currentTimeMillis();
                    }
                    if ((videoTS = CaptureTimeTools.timeSinceStartedCaptureInMicroseconds((long)System.currentTimeMillis(), (long)startTime)) > recorder.getTimestamp()) {
                        if (timer % 5 == 0) {
                            System.out.println("Lip-flap correction: " + videoTS + " : " + recorder.getTimestamp() + " -> " + (videoTS - recorder.getTimestamp()));
                        }
                        recorder.setTimestamp(videoTS);
                    }
                    recorder.record(capturedFrame);
                    ExampleBytedecoJavaCVWindowsScreenRecord.writeTimestampToFile(System.nanoTime(), recorder.getTimestamp());
                }
                recorder.stop();
                grabber.stop();
                timestampWriter.close();
            }
        }
    }

    public static void setupTimestampWriter() {
        try {
            timestampWriter = new FileWriter(timestampFile);
            timestampWriter.write("1\n");
            timestampWriter.write("60000\n");
        }
        catch (IOException e) {
            LogTools.info((String)"Didn't setup the timestamp file correctly");
        }
    }

    public static void writeTimestampToFile(long controllerTimestamp, long pts) {
        try {
            timestampWriter.write(controllerTimestamp + " " + pts + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        videoFile = new File(videoPath);
        timestampFile = new File(timestampPath);
    }
}

