/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.YoVariableClient;
import us.ihmc.robotDataLogger.YoVariableClientInterface;
import us.ihmc.robotDataLogger.YoVariableServer;
import us.ihmc.robotDataLogger.YoVariablesUpdatedListener;
import us.ihmc.robotDataLogger.handshake.LogHandshake;
import us.ihmc.robotDataLogger.handshake.YoVariableHandshakeParser;
import us.ihmc.robotDataLogger.logger.DataServerSettings;
import us.ihmc.robotDataLogger.util.DebugRegistry;
import us.ihmc.robotDataLogger.websocket.client.discovery.HTTPDataServerConnection;
import us.ihmc.robotDataLogger.websocket.command.DataServerCommand;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ClientImplementationTest {
    private static final double dt = 0.001;
    private static final DataServerSettings logSettings = new DataServerSettings(true);
    public YoVariableServer yoVariableServer;
    public YoVariableClient yoVariableClient;
    public YoVariableClient yoVariableClientShouldFail;
    private final YoRegistry serverRegistry = new YoRegistry("Main");
    private final YoRegistry clientListenerRegistry = new YoRegistry("ListenerRegistry");
    private final ClientUpdatedListener clientListener = new ClientUpdatedListener(this.clientListenerRegistry);

    @BeforeEach
    public void setupServer() {
        this.yoVariableServer = new YoVariableServer("TestServer", null, logSettings, 0.001);
    }

    @AfterEach
    public void shutdownServer() {
        this.yoVariableServer.close();
        LogTools.info((String)"Shutting down server successfully");
    }

    @Test
    public void testClientBadHostException() {
        this.yoVariableServer.setMainRegistry(this.serverRegistry, null);
        this.yoVariableServer.start();
        this.yoVariableClient = new YoVariableClient((YoVariablesUpdatedListener)this.clientListener);
        for (int i = 0; i < 3; ++i) {
            Throwable thrown = Assertions.assertThrows(RuntimeException.class, () -> this.yoVariableClient.start("1.1.1.1.1.1", 9009));
            Assertions.assertEquals((Object)"java.io.IOException: java.util.concurrent.ExecutionException: java.io.IOException: Connection refused", (Object)thrown.getMessage());
        }
    }

    @Test
    public void testClientBadConnectionException() throws IOException {
        this.yoVariableServer.setMainRegistry(this.serverRegistry, null);
        this.yoVariableServer.start();
        this.yoVariableClient = new YoVariableClient((YoVariablesUpdatedListener)this.clientListener);
        for (int i = 0; i < 2; ++i) {
            HTTPDataServerConnection connection = HTTPDataServerConnection.connect((String)"localhost", (int)8008);
            connection.getAnnouncement().getModelFileDescription().setHasModel(true);
            Throwable thrown = Assertions.assertThrows(IOException.class, () -> this.yoVariableClient.start(25000, connection));
            Assertions.assertEquals((Object)"java.util.concurrent.ExecutionException: java.io.IOException: Invalid response received 404 Not Found", (Object)thrown.getMessage());
            this.yoVariableClient.stop();
        }
    }

    @Disabled
    @Test
    public void testDuplicateClientException() {
        this.yoVariableServer = new YoVariableServer("TestServer", null, logSettings, 0.001);
        this.yoVariableServer.setMainRegistry(this.serverRegistry, null);
        this.yoVariableServer.start();
        this.yoVariableClient = new YoVariableClient((YoVariablesUpdatedListener)this.clientListener);
        this.yoVariableClientShouldFail = new YoVariableClient((YoVariablesUpdatedListener)this.clientListener);
        this.yoVariableClient.startWithHostSelector();
        Throwable thrown = Assertions.assertThrows(RuntimeException.class, () -> this.yoVariableClientShouldFail.startWithHostSelector());
        Assertions.assertEquals((Object)"Name collision for new child: testservercontainer. Parent name space = ListenerRegistry", (Object)thrown.getMessage());
        thrown = Assertions.assertThrows(RuntimeException.class, () -> this.yoVariableClientShouldFail.startWithHostSelector());
        Assertions.assertEquals((Object)"Client already started", (Object)thrown.getMessage());
        this.yoVariableClient.stop();
    }

    public static class ClientUpdatedListener
    implements YoVariablesUpdatedListener {
        private final YoRegistry parentRegistry;

        public ClientUpdatedListener(YoRegistry parentRegistry) {
            this.parentRegistry = parentRegistry;
        }

        public boolean updateYoVariables() {
            return true;
        }

        public boolean changesVariables() {
            return false;
        }

        public void setShowOverheadView(boolean showOverheadView) {
        }

        public void start(YoVariableClientInterface yoVariableClientInterface, LogHandshake handshake, YoVariableHandshakeParser handshakeParser, DebugRegistry debugRegistry) {
            YoRegistry clientRootRegistry = handshakeParser.getRootRegistry();
            YoRegistry serverRegistry = new YoRegistry(yoVariableClientInterface.getServerName() + "Container");
            serverRegistry.addChild(clientRootRegistry);
            this.parentRegistry.addChild(serverRegistry);
        }

        public void disconnected() {
        }

        public void receivedTimestampAndData(long timestamp) {
        }

        public void connected() {
        }

        public void receivedCommand(DataServerCommand command, int argument) {
        }

        public void receivedTimestampOnly(long timestamp) {
        }
    }
}

