/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.compression;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Predicate;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.tools.ResourceLoaderTools;

public class ResourceLoaderToolsTest {
    private final String[] topLevelResourceDirectories = new String[]{"models/", "models/gazebo/", "models/nadia_description/", "models/nadia_description/sdf/"};
    private String[] resourceDirectories;
    private final ByteArrayOutputStream os = new ByteArrayOutputStream();

    @BeforeEach
    public void startServerAndClientAndSetupResourceDirectories() {
        this.resourceDirectories = new String[this.topLevelResourceDirectories.length];
        System.arraycopy(this.topLevelResourceDirectories, 0, this.resourceDirectories, 0, this.resourceDirectories.length);
    }

    @Test
    public void testCreatingZipBundleWithAllModels() throws IOException {
        ResourceLoaderTools.createZipBundle((OutputStream)this.os, null, (String[])this.resourceDirectories);
    }

    @Test
    public void testCreatingZipBundleWithFilteredModels() throws IOException {
        String[] resourceModelsToBeLogged = new String[]{"models\\nadia_V17"};
        Predicate<String> filter = resourcePath -> {
            for (String model : resourceModelsToBeLogged) {
                if (!resourcePath.startsWith(model)) continue;
                return true;
            }
            return false;
        };
        ResourceLoaderTools.createZipBundle((OutputStream)this.os, filter, (String[])this.resourceDirectories);
    }
}

