/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.YoVariableClient;
import us.ihmc.robotDataLogger.YoVariableClientInterface;
import us.ihmc.robotDataLogger.YoVariableServer;
import us.ihmc.robotDataLogger.YoVariablesUpdatedListener;
import us.ihmc.robotDataLogger.handshake.LogHandshake;
import us.ihmc.robotDataLogger.handshake.YoVariableHandshakeParser;
import us.ihmc.robotDataLogger.logger.DataServerSettings;
import us.ihmc.robotDataLogger.util.DebugRegistry;
import us.ihmc.robotDataLogger.websocket.command.DataServerCommand;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

public class ServerClientConnectionTest {
    boolean CHANGEDVARIABLES = false;
    private static final double dt = 0.001;
    private static final int variablesPerType = 24;
    private long timestamp = 0L;
    private final Random random = new Random(666L);
    private static final DataServerSettings logSettings = new DataServerSettings(true);
    private final List<YoVariable> mainChangingVariables = new ArrayList<YoVariable>();
    public YoVariableServer yoVariableServer;
    public YoVariableClient yoVariableClient;
    private final YoRegistry serverRegistry = new YoRegistry("Main");
    private final YoRegistry clientListenerRegistry = new YoRegistry("ListenerRegistry");
    private final ClientUpdatedListener clientListener = new ClientUpdatedListener(this.clientListenerRegistry);

    @Test
    public void testReconnectToClient() throws IOException {
        Stopwatch timer = new Stopwatch();
        timer.start();
        this.createVariables("Main", 24, this.serverRegistry, this.mainChangingVariables);
        this.yoVariableServer = new YoVariableServer("TestServer", null, logSettings, 0.001);
        this.yoVariableServer.setMainRegistry(this.serverRegistry, null);
        this.yoVariableServer.start();
        this.yoVariableClient = new YoVariableClient((YoVariablesUpdatedListener)this.clientListener);
        this.yoVariableClient.start("localhost", 8008);
        LogTools.info((String)"Server and Client are started!");
        while (timer.totalElapsed() < 12.0) {
            Assertions.assertTrue((boolean)this.yoVariableClient.isConnected());
            this.yoVariableClient.disconnect();
            ThreadTools.sleepSeconds((double)1.0);
            Assertions.assertFalse((boolean)this.yoVariableClient.isConnected());
            this.yoVariableClient.reconnect();
            Assertions.assertTrue((boolean)this.yoVariableClient.isConnected());
            String receivedServerName = this.yoVariableClient.getServerName();
            Assertions.assertEquals((Object)"TestServer", (Object)receivedServerName);
        }
        this.yoVariableClient.stop();
        Assertions.assertFalse((boolean)this.yoVariableClient.isConnected());
        this.yoVariableServer.close();
    }

    @Test
    public void testServerClientChangedVariablesTrue() {
        this.CHANGEDVARIABLES = true;
        this.testSendingVariablesToClient();
        this.CHANGEDVARIABLES = false;
    }

    @Test
    public void testSendingVariablesToClient() {
        this.createVariables("Main", 24, this.serverRegistry, this.mainChangingVariables);
        this.yoVariableServer = new YoVariableServer("TestServer", null, logSettings, 0.001);
        this.yoVariableServer.setMainRegistry(this.serverRegistry, null);
        this.yoVariableServer.start();
        this.yoVariableClient = new YoVariableClient((YoVariablesUpdatedListener)this.clientListener);
        this.yoVariableClient.start("localhost", 8008);
        LogTools.info((String)"Server and Client are started!");
        for (int i = 0; i < 3; ++i) {
            LogTools.info((String)("Running updates variables for the (" + i + ") time!"));
            this.timestamp += Conversions.secondsToNanoseconds((double)0.001);
            long dtFactor = Conversions.secondsToNanoseconds((double)0.001) / 2L;
            long jitteryTimestamp = this.timestamp + (long)((this.random.nextDouble() - 0.5) * (double)dtFactor);
            this.updateVariables(this.mainChangingVariables);
            this.update(jitteryTimestamp);
            ArrayList serverVariables = new ArrayList(this.serverRegistry.collectSubtreeVariables());
            ArrayList clientVariables = new ArrayList(this.clientListenerRegistry.collectSubtreeVariables());
            for (int j = 0; j < serverVariables.size(); ++j) {
                Assertions.assertEquals((Object)((YoVariable)serverVariables.get(j)).getValueAsString(), (Object)((YoVariable)clientVariables.get(j)).getValueAsString(), (String)("The server variable: " + serverVariables.get(j) + ", the client variable: " + clientVariables.get(j)));
            }
        }
        this.yoVariableClient.stop();
        this.yoVariableServer.close();
    }

    public void update(long jitteryTimestamp) {
        this.yoVariableServer.update(jitteryTimestamp);
        this.yoVariableServer.update(jitteryTimestamp);
        ThreadTools.sleepSeconds((double)6.0);
        this.yoVariableServer.update(jitteryTimestamp);
        this.yoVariableServer.update(jitteryTimestamp);
        ThreadTools.sleepSeconds((double)6.0);
        this.yoVariableServer.update(jitteryTimestamp);
        this.yoVariableServer.update(jitteryTimestamp);
        ThreadTools.sleepSeconds((double)18.0);
        this.yoVariableServer.update(jitteryTimestamp);
        this.yoVariableServer.update(jitteryTimestamp);
    }

    public void createVariables(String prefix, int variablesPerType, YoRegistry registry, List<YoVariable> allChangingVariables) {
        for (int i = 0; i < variablesPerType; ++i) {
            new YoBoolean(prefix + "Boolean" + i, registry);
            new YoDouble(prefix + "Double" + i, registry);
            new YoInteger(prefix + "Integer" + i, registry);
            new YoLong(prefix + "Long" + i, registry);
            new YoEnum(prefix + "Enum" + i, registry, SomeEnum.class, true);
        }
        allChangingVariables.addAll(registry.collectSubtreeVariables());
    }

    private void updateVariables(List<YoVariable> allChangingVariables) {
        for (YoVariable allChangingVariable : allChangingVariables) {
            this.updateVariable(allChangingVariable);
        }
    }

    private void updateVariable(YoVariable variable) {
        if (variable instanceof YoBoolean) {
            ((YoBoolean)variable).set(this.random.nextBoolean());
        } else if (variable instanceof YoDouble) {
            ((YoDouble)variable).set(this.random.nextDouble());
        } else if (variable instanceof YoInteger) {
            ((YoInteger)variable).set(this.random.nextInt());
        } else if (variable instanceof YoLong) {
            ((YoLong)variable).set(this.random.nextLong());
        } else if (variable instanceof YoEnum) {
            int enumSize = ((YoEnum)variable).getEnumSize();
            ((YoEnum)variable).set(this.random.nextInt(enumSize));
        }
    }

    public class ClientUpdatedListener
    implements YoVariablesUpdatedListener {
        private final YoRegistry parentRegistry;

        public ClientUpdatedListener(YoRegistry parentRegistry) {
            this.parentRegistry = parentRegistry;
        }

        public boolean updateYoVariables() {
            return true;
        }

        public boolean changesVariables() {
            return ServerClientConnectionTest.this.CHANGEDVARIABLES;
        }

        public void setShowOverheadView(boolean showOverheadView) {
        }

        public void start(YoVariableClientInterface yoVariableClientInterface, LogHandshake handshake, YoVariableHandshakeParser handshakeParser, DebugRegistry debugRegistry) {
            YoRegistry clientRootRegistry = handshakeParser.getRootRegistry();
            YoRegistry serverRegistry = new YoRegistry(yoVariableClientInterface.getServerName() + "Container");
            serverRegistry.addChild(clientRootRegistry);
            this.parentRegistry.addChild(serverRegistry);
        }

        public void disconnected() {
        }

        public void receivedTimestampAndData(long timestamp) {
        }

        public void connected() {
        }

        public void receivedCommand(DataServerCommand command, int argument) {
        }

        public void receivedTimestampOnly(long timestamp) {
        }
    }

    public static enum SomeEnum {
        A,
        B,
        C,
        D,
        E,
        F;

    }
}

