/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.captureVideo;

import gnu.trove.list.array.TLongArrayList;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.Java2DFrameConverter;
import us.ihmc.codecs.generated.YUVPicture;
import us.ihmc.codecs.yuv.YUVPictureConverter;
import us.ihmc.robotDataLogger.Camera;
import us.ihmc.robotDataLogger.logger.MagewellDemuxer;

public class ExampleMagewellVideoDataPlayer {
    private final boolean interlaced;
    private long[] robotTimestamps;
    private long[] videoTimestamps;
    private final MagewellDemuxer magewellDemuxer;
    private final HideableMediaFrame viewer;
    private final YUVPictureConverter converter = new YUVPictureConverter();
    private YUVPictureConverter convertedYUVPicture;
    private Java2DFrameConverter frameConverter;

    public ExampleMagewellVideoDataPlayer(Camera camera, File dataDirectory, boolean hasTimeBase) throws IOException {
        this.interlaced = camera.getInterlaced();
        if (!hasTimeBase) {
            System.err.println("Video data is using timestamps instead of frame numbers. Falling back to seeking based on timestamp.");
        }
        if (!dataDirectory.exists()) {
            throw new IOException("Cannot find video: " + dataDirectory);
        }
        File videoFile = new File(dataDirectory, camera.getVideoFileAsString());
        File timestampFile = new File(dataDirectory, camera.getTimestampFileAsString());
        this.parseTimestampData(timestampFile);
        this.magewellDemuxer = new MagewellDemuxer(videoFile);
        this.viewer = new HideableMediaFrame(camera.getNameAsString(), this.magewellDemuxer.getImageWidth(), this.magewellDemuxer.getImageHeight());
    }

    public synchronized void showVideoFrame(long timestamp) {
        long videoTimestamp = this.getVideoTimestampFromRobotTimestamp(timestamp);
        this.magewellDemuxer.seekToPTS(videoTimestamp);
        Frame nextFrame = this.magewellDemuxer.getNextFrame();
        if (nextFrame != null) {
            this.viewer.update(this.convertFrameToYUVPicture(nextFrame));
        }
    }

    public YUVPicture convertFrameToYUVPicture(Frame frame) {
        if (this.convertedYUVPicture == null) {
            this.convertedYUVPicture = new YUVPictureConverter();
            this.frameConverter = new Java2DFrameConverter();
        }
        BufferedImage bufferedImage = this.frameConverter.getBufferedImage(frame);
        return this.convertedYUVPicture.fromBufferedImage(bufferedImage, YUVPicture.YUVSubsamplingType.YUV420);
    }

    public void setVisible(boolean visible) {
        this.viewer.setVisible(visible);
    }

    public long getVideoTimestampFromRobotTimestamp(long queryRobotTimestamp) {
        int currentIndex = this.searchRobotTimestampsForIndex(queryRobotTimestamp);
        return this.videoTimestamps[currentIndex];
    }

    private int searchRobotTimestampsForIndex(long queryRobotTimestamp) {
        if (queryRobotTimestamp <= this.robotTimestamps[0]) {
            return 0;
        }
        if (queryRobotTimestamp >= this.robotTimestamps[this.robotTimestamps.length - 1]) {
            return this.robotTimestamps.length - 1;
        }
        int index = Arrays.binarySearch(this.robotTimestamps, queryRobotTimestamp);
        if (index < 0) {
            int nextIndex;
            index = nextIndex = -index - 1;
        }
        return index;
    }

    private void parseTimestampData(File timestampFile) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(timestampFile));){
            String line;
            if (reader.readLine() == null) {
                throw new IOException("Cannot read numerator");
            }
            if (reader.readLine() == null) {
                throw new IOException("Cannot read denumerator");
            }
            TLongArrayList robotTimestamps = new TLongArrayList();
            TLongArrayList videoTimestamps = new TLongArrayList();
            while ((line = reader.readLine()) != null) {
                String[] stamps = line.split("\\s");
                long robotStamp = Long.parseLong(stamps[0]);
                long videoStamp = Long.parseLong(stamps[1]);
                if (this.interlaced) {
                    videoStamp /= 2L;
                }
                robotTimestamps.add(robotStamp);
                videoTimestamps.add(videoStamp);
            }
            this.robotTimestamps = robotTimestamps.toArray();
            this.videoTimestamps = videoTimestamps.toArray();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        Camera camera = new Camera();
        camera.setName("test");
        camera.setInterlaced(false);
        String videoName = "PoleCamera";
        camera.setTimestampFile(videoName + "_Timestamps.dat");
        camera.setVideoFile(videoName + "_Video.mov");
        File dataDirectory = new File("/home/ketchup/robotLogs/20240808_093303_SCS2AvatarSimulationFactory/");
        ExampleMagewellVideoDataPlayer player = new ExampleMagewellVideoDataPlayer(camera, dataDirectory, true);
        player.viewer.setDefaultCloseOperation(3);
        player.setVisible(true);
        for (int i = 1; i < player.robotTimestamps.length; ++i) {
            player.showVideoFrame(player.robotTimestamps[i]);
        }
        System.out.println(player.robotTimestamps.length);
    }

    private class HideableMediaFrame
    extends JFrame {
        private static final long serialVersionUID = -3494797002318746347L;
        final JLabel label;
        private BufferedImage img;
        private int width;
        private int height;

        public HideableMediaFrame(String name, int width, int height) {
            super(name);
            this.label = new JLabel();
            this.label.setPreferredSize(new Dimension(width, height));
            this.getContentPane().add(this.label);
            this.width = width;
            this.height = height;
            this.pack();
        }

        public void update(YUVPicture nextFrame) {
            SwingUtilities.invokeLater(() -> {
                if (nextFrame == null) {
                    return;
                }
                this.img = ExampleMagewellVideoDataPlayer.this.converter.toBufferedImage(nextFrame, this.img);
                nextFrame.delete();
                ImageIcon icon = new ImageIcon(this.img);
                this.label.setIcon(icon);
                if (this.img.getWidth() != this.width || this.img.getHeight() != this.height) {
                    this.width = this.img.getWidth();
                    this.height = this.img.getHeight();
                    this.label.setPreferredSize(new Dimension(this.width, this.height));
                    this.pack();
                }
            });
        }
    }
}

