/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.captureVideo;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.bytedeco.javacv.CanvasFrame;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.OpenCVFrameGrabber;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.logger.MagewellMuxer;

public class ExampleMagewellCapture {
    private static final int DEVICE_INDEX = 0;
    private static final String ubuntuMagewell = "ubuntuMagewell";
    public static String videoPath;
    public static String timestampPath;
    private static FileWriter timestampWriter;
    private static MagewellMuxer magewellMuxer;
    public static File videoFile;
    public static File timestampFile;
    private static long timestampsWritten;
    private static final int CAPTURE_TIME_DURATION = 10;
    private static final int FRAME_RATE = 60;

    public static void main(String[] args) throws InterruptedException {
        videoPath = "ihmc-robot-data-logger/out/ubuntuMagewell_Video.mov";
        timestampPath = "ihmc-robot-data-logger/out/ubuntuMagewell.dat";
        videoFile = new File(videoPath);
        timestampFile = new File(timestampPath);
        int captureWidth = 1280;
        int captureHeight = 720;
        try (OpenCVFrameGrabber grabber = new OpenCVFrameGrabber(0);){
            Frame capturedFrame;
            grabber.setImageWidth(1280);
            grabber.setImageHeight(720);
            grabber.setFrameRate(60.0);
            grabber.start();
            ExampleMagewellCapture.setupTimestampWriter();
            magewellMuxer = new MagewellMuxer(videoFile, 1280, 720);
            magewellMuxer.start();
            CanvasFrame cFrame = new CanvasFrame("Capture Preview", CanvasFrame.getDefaultGamma() / grabber.getGamma());
            long startTime = System.currentTimeMillis();
            ThreadTools.startAThread(ExampleMagewellCapture::keepTime, (String)"MagewellCapture");
            LogTools.info((String)"Starting capture");
            while (!magewellMuxer.isCloseOutputStream() && (capturedFrame = grabber.grabAtFrameRate()) != null) {
                long videoTimestamp = 1000L * (System.currentTimeMillis() - startTime);
                magewellMuxer.recordFrame(capturedFrame, videoTimestamp);
                if (cFrame.isVisible()) {
                    cFrame.showImage(capturedFrame);
                }
                ExampleMagewellCapture.writeTimestampToFile(System.nanoTime(), magewellMuxer.getTimeStamp());
            }
            LogTools.info((String)"Stopping Capture");
            LogTools.info((String)("Number of timestamps is: " + timestampsWritten));
            LogTools.info((String)("FPS was: " + timestampsWritten / 10L));
            cFrame.dispose();
            grabber.stop();
            timestampWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setupTimestampWriter() {
        try {
            timestampWriter = new FileWriter(timestampFile);
            timestampWriter.write("1\n");
            timestampWriter.write("60000\n");
        }
        catch (IOException e) {
            LogTools.info((String)"Didn't setup the timestamp file correctly");
        }
    }

    private static void keepTime() {
        ThreadTools.sleepSeconds((double)10.0);
        magewellMuxer.close();
    }

    public static void writeTimestampToFile(long controllerTimestamp, long pts) {
        try {
            ++timestampsWritten;
            timestampWriter.write(controllerTimestamp + " " + pts + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        timestampsWritten = 0L;
    }
}

