/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.websocket.command;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import us.ihmc.robotDataLogger.YoVariableServer;
import us.ihmc.robotDataLogger.logger.DataServerSettings;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

@Tag(value="robot-data-logger-2")
public class ServerImplementationTest {
    private static final double dt = 0.001;
    private static final DataServerSettings logSettings = new DataServerSettings(true);
    public YoVariableServer yoVariableServer;
    private final YoRegistry serverRegistry = new YoRegistry("Main");
    private final YoRegistry otherRegistry = new YoRegistry("OtherRegistry");

    @BeforeEach
    public void setupServer() {
        this.yoVariableServer = new YoVariableServer("TestServer", null, logSettings, 0.001);
    }

    @AfterEach
    public void shutdownServer() {
        this.yoVariableServer.close();
    }

    @Test
    public void testYoVariableConnections() {
        this.yoVariableServer.setMainRegistry(this.serverRegistry, null);
        this.yoVariableServer.createSummary((YoVariable)new YoDouble("YoDoubleSummarize", this.serverRegistry));
        this.yoVariableServer.addSummarizedVariable("Main.YoDoubleSummarize");
        for (int i = 0; i < 4; ++i) {
            Throwable thrown = Assertions.assertThrows(RuntimeException.class, () -> this.yoVariableServer.addSummarizedVariable("BadVariableInformation"));
            Assertions.assertEquals((Object)"Variable BadVariableInformation is not registered with the logger", (Object)thrown.getMessage());
        }
    }

    @Test
    public void testRegistryHolderException() {
        this.yoVariableServer.setMainRegistry(this.serverRegistry, null);
        this.yoVariableServer.start();
        for (int i = 0; i < 6; ++i) {
            Throwable thrown = Assertions.assertThrows(RuntimeException.class, () -> this.yoVariableServer.getRegistryHolder(this.otherRegistry));
            Assertions.assertEquals((Object)"Registry OtherRegistry not registered with addRegistry() or setMainRegistry()", (Object)thrown.getMessage());
        }
    }

    @Test
    public void testStartServerConditions() {
        Throwable thrown;
        int i;
        this.yoVariableServer.setMainRegistry(this.serverRegistry, null);
        this.yoVariableServer.start();
        for (i = 0; i < 6; ++i) {
            thrown = Assertions.assertThrows(RuntimeException.class, () -> this.yoVariableServer.start());
            Assertions.assertEquals((Object)"Server already started", (Object)thrown.getMessage());
        }
        this.yoVariableServer.close();
        for (i = 0; i < 6; ++i) {
            thrown = Assertions.assertThrows(RuntimeException.class, () -> this.yoVariableServer.start());
            Assertions.assertEquals((Object)"Server already started", (Object)thrown.getMessage());
        }
    }

    @Test
    public void testMainRegistryExceptions() {
        Throwable thrown;
        int i;
        for (i = 0; i < 4; ++i) {
            thrown = Assertions.assertThrows(RuntimeException.class, () -> this.yoVariableServer.addRegistry(this.otherRegistry, null));
            Assertions.assertEquals((Object)"Main registry is not set. Set main registry first", (Object)thrown.getMessage());
        }
        this.yoVariableServer.setMainRegistry(this.serverRegistry, null);
        for (i = 0; i < 4; ++i) {
            thrown = Assertions.assertThrows(RuntimeException.class, () -> this.yoVariableServer.setMainRegistry(this.serverRegistry, null));
            Assertions.assertEquals((Object)"Main registry is already set", (Object)thrown.getMessage());
        }
    }
}

