/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.websocket.command;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.robotDataLogger.YoVariableServer;
import us.ihmc.robotDataLogger.logger.DataServerSettings;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

@Tag(value="robot-data-logger-2")
public class ServerImplementationTest {
    private static final double dt = 0.001;
    private static final DataServerSettings logSettings = new DataServerSettings(true);
    public YoVariableServer yoVariableServer;
    private final YoRegistry serverRegistry = new YoRegistry("Main");
    private final YoRegistry otherRegistry = new YoRegistry("OtherRegistry");

    @Test
    public void testYoVariableConnections() {
        boolean failure = false;
        Stopwatch timerToEndLoop = new Stopwatch();
        timerToEndLoop.start();
        this.yoVariableServer = new YoVariableServer("TestServer", null, logSettings, 0.001);
        this.yoVariableServer.setMainRegistry(this.serverRegistry, null);
        this.yoVariableServer.createSummary((YoVariable)new YoDouble("YoDoubleSummarize", this.serverRegistry));
        this.yoVariableServer.addSummarizedVariable("Main.YoDoubleSummarize");
        for (int i = 0; i < 4; ++i) {
            try {
                this.yoVariableServer.addSummarizedVariable("BadVariableInformation");
            }
            catch (Exception e) {
                failure = true;
            }
            Assertions.assertTrue((boolean)failure);
        }
        this.yoVariableServer.close();
    }

    @Test
    public void testRegistryHolderException() {
        boolean failure = false;
        this.yoVariableServer = new YoVariableServer("TestServer", null, logSettings, 0.001);
        this.yoVariableServer.setMainRegistry(this.serverRegistry, null);
        this.yoVariableServer.start();
        for (int i = 0; i < 6; ++i) {
            try {
                this.yoVariableServer.getRegistryHolder(this.otherRegistry);
            }
            catch (Exception e) {
                failure = true;
            }
            Assertions.assertTrue((boolean)failure);
        }
        this.yoVariableServer.close();
    }

    @Test
    public void testStartServerConditions() {
        int i;
        boolean failure = false;
        this.yoVariableServer = new YoVariableServer("TestServer", null, logSettings, 0.001);
        this.yoVariableServer.setMainRegistry(this.serverRegistry, null);
        this.yoVariableServer.start();
        for (i = 0; i < 6; ++i) {
            try {
                this.yoVariableServer.start();
            }
            catch (Exception e) {
                failure = true;
            }
            Assertions.assertTrue((boolean)failure);
        }
        failure = false;
        this.yoVariableServer.close();
        for (i = 0; i < 6; ++i) {
            try {
                this.yoVariableServer.start();
            }
            catch (Exception e) {
                failure = true;
            }
            Assertions.assertTrue((boolean)failure);
        }
        this.yoVariableServer.close();
    }

    @Test
    public void testMainRegistryExceptions() {
        int i;
        boolean failure = false;
        this.yoVariableServer = new YoVariableServer("TestServer", null, logSettings, 0.001);
        for (i = 0; i < 4; ++i) {
            try {
                this.yoVariableServer.addRegistry(this.otherRegistry, null);
            }
            catch (Exception e) {
                failure = true;
            }
            Assertions.assertTrue((boolean)failure);
        }
        failure = false;
        this.yoVariableServer.setMainRegistry(this.serverRegistry, null);
        for (i = 0; i < 4; ++i) {
            try {
                this.yoVariableServer.setMainRegistry(this.serverRegistry, null);
            }
            catch (Exception e) {
                failure = true;
            }
            Assertions.assertTrue((boolean)failure);
        }
        this.yoVariableServer.close();
    }
}

