/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.websocket.command;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.YoVariableClient;
import us.ihmc.robotDataLogger.YoVariableClientInterface;
import us.ihmc.robotDataLogger.YoVariableServer;
import us.ihmc.robotDataLogger.YoVariablesUpdatedListener;
import us.ihmc.robotDataLogger.handshake.LogHandshake;
import us.ihmc.robotDataLogger.handshake.YoVariableHandshakeParser;
import us.ihmc.robotDataLogger.logger.DataServerSettings;
import us.ihmc.robotDataLogger.util.DebugRegistry;
import us.ihmc.robotDataLogger.websocket.client.discovery.HTTPDataServerConnection;
import us.ihmc.robotDataLogger.websocket.command.DataServerCommand;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ClientImplementationTest {
    private static final double dt = 0.001;
    private static final DataServerSettings logSettings = new DataServerSettings(true);
    public YoVariableServer yoVariableServer;
    public YoVariableClient yoVariableClient;
    public YoVariableClient yoVariableClientShouldFail;
    private final YoRegistry serverRegistry = new YoRegistry("Main");
    private final YoRegistry clientListenerRegistry = new YoRegistry("ListenerRegistry");
    private final ClientUpdatedListener clientListener = new ClientUpdatedListener(this.clientListenerRegistry);

    @Test
    public void testClientBadHostException() {
        boolean failure = false;
        this.yoVariableServer = new YoVariableServer("TestServer", null, logSettings, 0.001);
        this.yoVariableServer.setMainRegistry(this.serverRegistry, null);
        this.yoVariableServer.start();
        this.yoVariableClient = new YoVariableClient((YoVariablesUpdatedListener)this.clientListener);
        for (int i = 0; i < 4; ++i) {
            try {
                this.yoVariableClient.start("1.1.1.1.1.1.1", 9009);
            }
            catch (Exception e) {
                failure = true;
            }
            Assertions.assertTrue((boolean)failure);
        }
        LogTools.info((String)"Closing down server and client successfully");
        this.yoVariableServer.close();
    }

    @Test
    public void testClientBadConnectionException() {
        this.yoVariableServer = new YoVariableServer("TestServer", null, logSettings, 0.001);
        this.yoVariableServer.setMainRegistry(this.serverRegistry, null);
        this.yoVariableServer.start();
        this.yoVariableClient = new YoVariableClient((YoVariablesUpdatedListener)this.clientListener);
        for (int i = 0; i < 4; ++i) {
            boolean failure = this.startWithSetModelTrue("localhost", 8008, this.yoVariableClient);
            this.yoVariableClient.stop();
            Assertions.assertTrue((boolean)failure);
        }
        LogTools.info((String)"Closing down server and client successfully, test passed");
        this.yoVariableServer.close();
    }

    public boolean startWithSetModelTrue(String host, int port, YoVariableClient yoVariableClient) {
        try {
            HTTPDataServerConnection connection = HTTPDataServerConnection.connect((String)host, (int)port);
            connection.getAnnouncement().getModelFileDescription().setHasModel(true);
            yoVariableClient.start(25000, connection);
        }
        catch (IOException e) {
            return true;
        }
        return false;
    }

    @Disabled
    @Test
    public void testDuplicateClientException() {
        boolean failure = false;
        this.yoVariableServer = new YoVariableServer("TestServer", null, logSettings, 0.001);
        this.yoVariableServer.setMainRegistry(this.serverRegistry, null);
        this.yoVariableServer.start();
        this.yoVariableClient = new YoVariableClient((YoVariablesUpdatedListener)this.clientListener);
        this.yoVariableClientShouldFail = new YoVariableClient((YoVariablesUpdatedListener)this.clientListener);
        this.yoVariableClient.startWithHostSelector();
        for (int i = 0; i < 2; ++i) {
            try {
                this.yoVariableClientShouldFail.startWithHostSelector();
            }
            catch (Exception e) {
                failure = true;
            }
            Assertions.assertTrue((boolean)failure);
        }
        LogTools.info((String)"Closing down server and client successfully");
        this.yoVariableClient.stop();
        this.yoVariableServer.close();
    }

    public static class ClientUpdatedListener
    implements YoVariablesUpdatedListener {
        private final YoRegistry parentRegistry;

        public ClientUpdatedListener(YoRegistry parentRegistry) {
            this.parentRegistry = parentRegistry;
        }

        public boolean updateYoVariables() {
            return true;
        }

        public boolean changesVariables() {
            return false;
        }

        public void setShowOverheadView(boolean showOverheadView) {
        }

        public void start(YoVariableClientInterface yoVariableClientInterface, LogHandshake handshake, YoVariableHandshakeParser handshakeParser, DebugRegistry debugRegistry) {
            YoRegistry clientRootRegistry = handshakeParser.getRootRegistry();
            YoRegistry serverRegistry = new YoRegistry(yoVariableClientInterface.getServerName() + "Container");
            serverRegistry.addChild(clientRootRegistry);
            this.parentRegistry.addChild(serverRegistry);
        }

        public void disconnected() {
        }

        public void receivedTimestampAndData(long timestamp) {
        }

        public void connected() {
        }

        public void receivedCommand(DataServerCommand command, int argument) {
        }

        public void receivedTimestampOnly(long timestamp) {
        }
    }
}

