/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataCommunication;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class DoubleToLongBitsSpeedTest {
    int numberOfVariables = 100000;
    Random random = new Random();

    Supplier<ArrayList<YoDouble>> generateRandomData() {
        return () -> {
            YoRegistry registry = new YoRegistry("TestRegistry");
            ArrayList<YoDouble> variables = new ArrayList<YoDouble>(this.numberOfVariables);
            for (int i = 0; i < this.numberOfVariables; ++i) {
                YoDouble v = new YoDouble("test-" + i, registry);
                v.set(this.random.nextDouble());
                variables.add(v);
            }
            return variables;
        };
    }

    @Test
    public void testDoubleToLongBitsSpeed() {
        int i;
        Stopwatch doubleTime = new Stopwatch();
        Stopwatch longTime = new Stopwatch();
        ByteBuffer buffer = ByteBuffer.allocate(this.numberOfVariables * 8);
        DoubleBuffer doubleBuffer = buffer.asDoubleBuffer();
        LongBuffer longBuffer = buffer.asLongBuffer();
        ArrayList<YoDouble> variables = this.generateRandomData().get();
        for (i = 0; i < 4200; ++i) {
            DoubleToLongBitsSpeedTest.fillDoubleBuffer(this.numberOfVariables, variables, doubleBuffer);
            DoubleToLongBitsSpeedTest.fillLongBuffer(this.numberOfVariables, variables, longBuffer);
            doubleBuffer.clear();
            longBuffer.clear();
        }
        doubleTime.start();
        for (i = 0; i < 10000; ++i) {
            DoubleToLongBitsSpeedTest.fillDoubleBuffer(this.numberOfVariables, variables, doubleBuffer);
            doubleBuffer.clear();
        }
        double doubleTimeTaken = doubleTime.totalElapsed();
        longTime.start();
        for (i = 0; i < 10000; ++i) {
            DoubleToLongBitsSpeedTest.fillLongBuffer(this.numberOfVariables, variables, longBuffer);
            longBuffer.clear();
        }
        double longTimeTaken = longTime.totalElapsed();
        Assertions.assertTrue((doubleTimeTaken < longTimeTaken ? 1 : 0) != 0, (String)("Double Buffer took: " + doubleTimeTaken + ", and Long Buffer took: " + longTimeTaken));
        Assertions.assertEquals((int)doubleBuffer.capacity(), (int)longBuffer.capacity());
    }

    private static void fillDoubleBuffer(int numberOfVariables, ArrayList<YoDouble> variables, DoubleBuffer doubleBuffer) {
        for (int i = 0; i < numberOfVariables; ++i) {
            doubleBuffer.put(variables.get(i).getDoubleValue());
        }
    }

    private static void fillLongBuffer(int numberOfVariables, ArrayList<YoDouble> variables, LongBuffer longBuffer) {
        for (int i = 0; i < numberOfVariables; ++i) {
            longBuffer.put(Double.doubleToLongBits(variables.get(i).getDoubleValue()));
        }
    }
}

