/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.rtps;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ReliabilityKind;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.SampleInfo;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;
import us.ihmc.robotDataLogger.VariableChangeRequest;
import us.ihmc.robotDataLogger.VariableChangeRequestPubSubType;

public class VariableChangedMessageTest {
    @Test
    public void testSendingVariableChangedMessage() throws IOException {
        Domain domain = DomainFactory.getDomain((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS);
        Participant participant = domain.createParticipant(domain.createParticipantAttributes(1, "TestParticipant"));
        VariableChangeRequestPubSubType type = new VariableChangeRequestPubSubType();
        Publisher publisher = domain.createPublisher(participant, domain.createPublisherAttributes(participant, (TopicDataType)type, "testTopic", ReliabilityKind.RELIABLE, new String[]{"us.ihmc"}));
        final AtomicInteger receivedMessages = new AtomicInteger(0);
        SubscriberListener listener = new SubscriberListener(){

            public void onSubscriptionMatched(Subscriber subscriber, MatchingInfo info) {
            }

            public void onNewDataMessage(Subscriber subscriber) {
                VariableChangeRequest req = new VariableChangeRequest();
                if (subscriber.takeNextData((Object)req, new SampleInfo())) {
                    receivedMessages.incrementAndGet();
                    System.out.println("Received: " + req);
                } else {
                    System.err.println("COULD NOT DECODE MESSAGE");
                }
            }
        };
        domain.createSubscriber(participant, domain.createSubscriberAttributes(participant, (TopicDataType)type, "testTopic", ReliabilityKind.RELIABLE, new String[]{"us.ihmc"}), listener);
        ThreadTools.sleep((long)1000L);
        for (int i = 0; i < 10; ++i) {
            VariableChangeRequest msg = new VariableChangeRequest();
            msg.variableID_ = i + 100;
            msg.requestedValue_ = (double)i * 13.37;
            publisher.write((Object)msg);
            System.out.println("Writing: " + msg);
            ThreadTools.sleep((long)1000L);
        }
        Assertions.assertEquals((int)10, (int)receivedMessages.get());
    }
}

