/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedUI.graphics;

import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Sphere;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.javafx.JavaFXGraphicTools;

public class PositionGraphic {
    private final Sphere sphere;
    private final PhongMaterial material;
    private final FramePose3D pose = new FramePose3D();

    public PositionGraphic(Color color, double radius) {
        this.sphere = new Sphere(radius);
        this.material = new PhongMaterial(color);
        this.sphere.setMaterial((Material)this.material);
    }

    public FramePose3DBasics getPose() {
        return this.pose;
    }

    public void update() {
        JavaFXGraphicTools.setNodeTransformFromPose((Node)this.sphere, (Pose3DReadOnly)this.pose);
    }

    public Node getNode() {
        return this.sphere;
    }

    public void clear() {
        this.pose.getPosition().setToNaN();
        this.update();
    }

    public void setPosition(Point3DReadOnly position) {
        this.pose.getPosition().set((Tuple3DReadOnly)position);
        this.update();
    }

    public void setMouseTransparent(boolean transparent) {
        this.sphere.setMouseTransparent(transparent);
    }
}

