/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedUI;

import ihmc_common_msgs.msg.dds.SE3TrajectoryMessage;
import ihmc_common_msgs.msg.dds.SE3TrajectoryPointMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javafx.animation.AnimationTimer;
import net.java.games.input.Event;
import org.apache.commons.lang3.mutable.MutableDouble;
import quadruped_msgs.msg.dds.QuadrupedBodyTrajectoryMessage;
import quadruped_msgs.msg.dds.QuadrupedTeleopDesiredVelocity;
import us.ihmc.commons.MathTools;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.messager.Messager;
import us.ihmc.quadrupedBasics.QuadrupedSteppingStateEnum;
import us.ihmc.quadrupedBasics.referenceFrames.QuadrupedReferenceFrames;
import us.ihmc.quadrupedPlanning.QuadrupedXGaitSettings;
import us.ihmc.quadrupedPlanning.QuadrupedXGaitSettingsBasics;
import us.ihmc.quadrupedPlanning.QuadrupedXGaitSettingsReadOnly;
import us.ihmc.quadrupedUI.QuadrupedUIMessagerAPI;
import us.ihmc.quadrupedUI.QuadrupedXBoxBindings;
import us.ihmc.robotModels.FullQuadrupedRobotModel;
import us.ihmc.tools.inputDevices.joystick.Joystick;
import us.ihmc.tools.inputDevices.joystick.JoystickCustomizationFilter;
import us.ihmc.tools.inputDevices.joystick.JoystickEventListener;
import us.ihmc.tools.inputDevices.joystick.mapping.JoystickMapping;
import us.ihmc.tools.inputDevices.joystick.mapping.XBoxOneMapping;

public class QuadrupedJoystickModule
extends AnimationTimer
implements JoystickEventListener {
    private static final int pollRateMillis = 50;
    private static final double maximumBodyHeightOffset = 0.1;
    private static final double bodyHeightDeltaPerClick = 0.01;
    private static final double endPhaseDeltaPerClick = 90.0;
    private static final double maxBodyYaw = 0.25;
    private static final double maxBodyRoll = 0.15;
    private static final double maxBodyPitch = 0.15;
    private static final double bodyOrientationShiftTime = 0.1;
    private static final double maxTranslationX = 0.25;
    private static final double maxTranslationY = 0.15;
    private final MutableDouble maxVelocityY = new MutableDouble();
    private final MutableDouble maxVelocityYaw = new MutableDouble();
    private final MutableDouble bodyHeightOffset = new MutableDouble();
    private final Messager messager;
    private final double nominalBodyHeight;
    private final Map<XBoxOneMapping, ChannelData> channelDataMap = new HashMap<XBoxOneMapping, ChannelData>();
    private final QuadrupedXGaitSettingsBasics xGaitSettings;
    private final QuadrupedReferenceFrames referenceFrames;
    private final AtomicReference<QuadrupedSteppingStateEnum> currentSteppingState;
    private final AtomicReference<Boolean> joystickEnabled;
    private final AtomicReference<Boolean> stepTeleopEnabled;
    private final AtomicReference<Boolean> heightTeleopEnabled;
    private final AtomicReference<Boolean> bodyPoseTeleopEnabled;
    private final AtomicBoolean resetBodyPose = new AtomicBoolean();

    public QuadrupedJoystickModule(Messager messager, QuadrupedXGaitSettingsReadOnly defaultXGaitSettings, FullQuadrupedRobotModel robotModel, double nominalBodyHeight, Joystick joystick) {
        this.messager = messager;
        this.xGaitSettings = new QuadrupedXGaitSettings(defaultXGaitSettings);
        this.nominalBodyHeight = nominalBodyHeight;
        this.referenceFrames = new QuadrupedReferenceFrames(robotModel);
        joystick.addJoystickEventListener((JoystickEventListener)this);
        joystick.setPollInterval(50);
        QuadrupedJoystickModule.configureJoystickFilters(joystick);
        for (XBoxOneMapping channel : XBoxOneMapping.values) {
            this.channelDataMap.put(channel, new ChannelData());
        }
        this.channelDataMap.get(XBoxOneMapping.LEFT_TRIGGER).initialize(-1.0);
        this.channelDataMap.get(XBoxOneMapping.RIGHT_TRIGGER).initialize(-1.0);
        this.joystickEnabled = messager.createInput(QuadrupedUIMessagerAPI.EnableJoystickTopic, (Object)false);
        this.stepTeleopEnabled = messager.createInput(QuadrupedUIMessagerAPI.EnableStepTeleopTopic, (Object)false);
        this.heightTeleopEnabled = messager.createInput(QuadrupedUIMessagerAPI.EnableHeightTeleopTopic, (Object)false);
        this.bodyPoseTeleopEnabled = messager.createInput(QuadrupedUIMessagerAPI.EnableBodyTeleopTopic, (Object)false);
        messager.addTopicListener(QuadrupedUIMessagerAPI.XGaitSettingsTopic, arg_0 -> ((QuadrupedXGaitSettingsBasics)this.xGaitSettings).set(arg_0));
        messager.addTopicListener(QuadrupedUIMessagerAPI.CurrentControllerNameTopic, state -> {
            if (state != HighLevelControllerName.WALKING) {
                messager.submitMessage(QuadrupedUIMessagerAPI.EnableJoystickTopic, (Object)false);
            }
        });
        this.currentSteppingState = messager.createInput(QuadrupedUIMessagerAPI.CurrentSteppingStateNameTopic, null);
    }

    private static void configureJoystickFilters(Joystick device) {
        device.setCustomizationFilter(new JoystickCustomizationFilter((JoystickMapping)QuadrupedXBoxBindings.xVelocityMapping, QuadrupedXBoxBindings.xVelocityInvert, 0.1, 1));
        device.setCustomizationFilter(new JoystickCustomizationFilter((JoystickMapping)QuadrupedXBoxBindings.yVelocityMapping, QuadrupedXBoxBindings.yVelocityInvert, 0.1, 1));
        device.setCustomizationFilter(new JoystickCustomizationFilter((JoystickMapping)QuadrupedXBoxBindings.leftTurnMapping, false, 0.05, 1, 1.0));
        device.setCustomizationFilter(new JoystickCustomizationFilter((JoystickMapping)QuadrupedXBoxBindings.rightTurnMapping, false, 0.05, 1, 1.0));
        device.setCustomizationFilter(new JoystickCustomizationFilter((JoystickMapping)QuadrupedXBoxBindings.negativeYawMapping, QuadrupedXBoxBindings.negativeYawInvert, 0.05, 1, 1.0));
        device.setCustomizationFilter(new JoystickCustomizationFilter((JoystickMapping)QuadrupedXBoxBindings.positiveYawMapping, QuadrupedXBoxBindings.positiveYawInvert, 0.05, 1, 1.0));
        device.setCustomizationFilter(new JoystickCustomizationFilter((JoystickMapping)QuadrupedXBoxBindings.rollMapping, QuadrupedXBoxBindings.rollInvert, 0.1, 1));
        device.setCustomizationFilter(new JoystickCustomizationFilter((JoystickMapping)QuadrupedXBoxBindings.pitchMapping, QuadrupedXBoxBindings.pitchInvert, 0.1, 1));
    }

    public void handle(long now) {
        this.processEnableCommand();
        if (!this.joystickEnabled.get().booleanValue()) {
            return;
        }
        this.processResetBodyCommand();
        this.processPauseWalkingCommand();
        this.referenceFrames.updateFrames();
        if (this.resetBodyPose.getAndSet(false)) {
            this.sendResetCommands();
        }
        this.processBodyHeightCommands();
        this.processBodyOrientationCommands();
        this.processXGaitSettingCommands();
        this.processStepCommands();
    }

    private void processEnableCommand() {
        ChannelData enableChannel = this.channelDataMap.get(XBoxOneMapping.START);
        if (enableChannel.hasNewData() && enableChannel.getValue() > 0.5) {
            this.messager.submitMessage(QuadrupedUIMessagerAPI.EnableJoystickTopic, (Object)(this.joystickEnabled.get() == false ? 1 : 0));
            this.messager.submitMessage(QuadrupedUIMessagerAPI.EnableStepTeleopTopic, (Object)false);
        }
    }

    private void processResetBodyCommand() {
        ChannelData resetChannel = this.channelDataMap.get(XBoxOneMapping.SELECT);
        if (resetChannel.hasNewData() && resetChannel.getValue() > 0.5) {
            this.resetBodyPose.set(true);
        }
    }

    private void processPauseWalkingCommand() {
        ChannelData pauseWalkingChannel = this.channelDataMap.get(XBoxOneMapping.SELECT);
        if (pauseWalkingChannel.hasNewData() && pauseWalkingChannel.getValue() > 0.5) {
            boolean walking = this.currentSteppingState.get() != null && this.currentSteppingState.get() == QuadrupedSteppingStateEnum.STEP;
            this.messager.submitMessage(QuadrupedUIMessagerAPI.PauseWalkingTopic, (Object)walking);
        }
    }

    private void sendResetCommands() {
        this.bodyHeightOffset.setValue(0.0);
        this.sendBodyHeightSetpoint();
        this.sendOrientationSetpoint(0.0, 0.0, 0.0);
    }

    private void processBodyHeightCommands() {
        ChannelData enableHeightChannel = this.channelDataMap.get(QuadrupedXBoxBindings.enableHeightTeleop);
        if (enableHeightChannel.hasNewData() && enableHeightChannel.getValue() > 0.5) {
            this.messager.submitMessage(QuadrupedUIMessagerAPI.EnableHeightTeleopTopic, (Object)(this.heightTeleopEnabled.get() == false ? 1 : 0));
        }
        if (!this.heightTeleopEnabled.get().booleanValue()) {
            return;
        }
        ChannelData heightChannel = this.channelDataMap.get(QuadrupedXBoxBindings.heightMapping);
        boolean hasNewData = heightChannel.hasNewData();
        double value = heightChannel.getValue();
        if (hasNewData && (value == 0.25 || value == 0.75)) {
            double heightAdjustment = value == 0.25 ? 0.01 : -0.01;
            this.bodyHeightOffset.add(heightAdjustment);
            this.bodyHeightOffset.setValue(MathTools.clamp((double)this.bodyHeightOffset.getValue(), (double)0.1));
            this.sendBodyHeightSetpoint();
        }
    }

    private void sendBodyHeightSetpoint() {
        ReferenceFrame bodyHeightFrame = this.referenceFrames.getCenterOfFeetZUpFrameAveragingLowestZHeightsAcrossEnds();
        FramePoint3D bodyHeight = new FramePoint3D(bodyHeightFrame, 0.0, 0.0, this.nominalBodyHeight + this.bodyHeightOffset.getValue());
        bodyHeight.changeFrame(ReferenceFrame.getWorldFrame());
        this.messager.submitMessage(QuadrupedUIMessagerAPI.DesiredBodyHeightTopic, (Object)bodyHeight.getZ());
    }

    private void processBodyOrientationCommands() {
        ChannelData enableOrientationChannel = this.channelDataMap.get(QuadrupedXBoxBindings.enableOrientationTeleop);
        if (enableOrientationChannel.hasNewData() && enableOrientationChannel.getValue() > 0.5) {
            this.messager.submitMessage(QuadrupedUIMessagerAPI.EnableBodyTeleopTopic, (Object)(this.bodyPoseTeleopEnabled.get() == false ? 1 : 0));
        }
        if (!this.bodyPoseTeleopEnabled.get().booleanValue()) {
            return;
        }
        ChannelData negativeYawChannel = this.channelDataMap.get(QuadrupedXBoxBindings.negativeYawMapping);
        ChannelData positiveYawChannel = this.channelDataMap.get(QuadrupedXBoxBindings.positiveYawMapping);
        ChannelData rollChannel = this.channelDataMap.get(QuadrupedXBoxBindings.rollMapping);
        ChannelData pitchChannel = this.channelDataMap.get(QuadrupedXBoxBindings.pitchMapping);
        if (negativeYawChannel.hasNewData() || positiveYawChannel.hasNewData() || rollChannel.hasNewData() || pitchChannel.hasNewData()) {
            double bodyYaw = 0.5 * (positiveYawChannel.getValue() - negativeYawChannel.getValue()) * 0.25;
            double bodyRoll = rollChannel.getValue() * 0.15;
            double bodyPitch = pitchChannel.getValue() * 0.15;
            this.sendOrientationSetpoint(bodyYaw, bodyRoll, bodyPitch);
        }
    }

    private void sendOrientationSetpoint(double bodyYaw, double bodyRoll, double bodyPitch) {
        QuadrupedBodyTrajectoryMessage bodyTrajectoryMessage = new QuadrupedBodyTrajectoryMessage();
        bodyTrajectoryMessage.setIsExpressedInAbsoluteTime(false);
        SE3TrajectoryMessage se3Trajectory = bodyTrajectoryMessage.getSe3Trajectory();
        se3Trajectory.getFrameInformation().setDataReferenceFrameId(MessageTools.toFrameId((ReferenceFrame)ReferenceFrame.getWorldFrame()));
        se3Trajectory.getAngularSelectionMatrix().setXSelected(true);
        se3Trajectory.getAngularSelectionMatrix().setYSelected(true);
        se3Trajectory.getAngularSelectionMatrix().setZSelected(true);
        se3Trajectory.getLinearSelectionMatrix().setXSelected(false);
        se3Trajectory.getLinearSelectionMatrix().setYSelected(false);
        se3Trajectory.getLinearSelectionMatrix().setZSelected(false);
        SE3TrajectoryPointMessage trajectoryPointMessage = (SE3TrajectoryPointMessage)se3Trajectory.getTaskspaceTrajectoryPoints().add();
        trajectoryPointMessage.getOrientation().setYawPitchRoll(bodyYaw, bodyPitch, bodyRoll);
        trajectoryPointMessage.setTime(0.1);
        this.messager.submitMessage(QuadrupedUIMessagerAPI.DesiredBodyTrajectoryTopic, (Object)bodyTrajectoryMessage);
    }

    private void processXGaitSettingCommands() {
        ChannelData increaseEndPhaseShiftChannel = this.channelDataMap.get(QuadrupedXBoxBindings.endPhaseShiftUp);
        ChannelData decreaseEndPhaseShiftChannel = this.channelDataMap.get(QuadrupedXBoxBindings.endPhaseShiftDown);
        if (increaseEndPhaseShiftChannel.hasNewData() && increaseEndPhaseShiftChannel.getValue() > 0.5) {
            this.xGaitSettings.setEndPhaseShift(this.xGaitSettings.getEndPhaseShift() + 90.0);
            this.messager.submitMessage(QuadrupedUIMessagerAPI.XGaitSettingsTopic, (Object)this.xGaitSettings);
        } else if (decreaseEndPhaseShiftChannel.hasNewData() && decreaseEndPhaseShiftChannel.getValue() > 0.5) {
            this.xGaitSettings.setEndPhaseShift(this.xGaitSettings.getEndPhaseShift() - 90.0);
            this.messager.submitMessage(QuadrupedUIMessagerAPI.XGaitSettingsTopic, (Object)this.xGaitSettings);
        }
    }

    private void processStepCommands() {
        ChannelData enableSteppingChannel = this.channelDataMap.get(QuadrupedXBoxBindings.enableWalkingTeleop);
        if (enableSteppingChannel.hasNewData() && enableSteppingChannel.getValue() > 0.5) {
            this.messager.submitMessage(QuadrupedUIMessagerAPI.EnableStepTeleopTopic, (Object)(this.stepTeleopEnabled.get() == false ? 1 : 0));
        }
        if (!this.stepTeleopEnabled.get().booleanValue()) {
            return;
        }
        ChannelData xVelocityChannel = this.channelDataMap.get(QuadrupedXBoxBindings.xVelocityMapping);
        ChannelData yVelocityChannel = this.channelDataMap.get(QuadrupedXBoxBindings.yVelocityMapping);
        ChannelData leftTurnChannel = this.channelDataMap.get(QuadrupedXBoxBindings.leftTurnMapping);
        ChannelData rightTurnChannel = this.channelDataMap.get(QuadrupedXBoxBindings.rightTurnMapping);
        if (xVelocityChannel.hasNewData() || yVelocityChannel.hasNewData() || leftTurnChannel.hasNewData() || rightTurnChannel.hasNewData()) {
            this.maxVelocityY.setValue(this.xGaitSettings.getMaxHorizontalSpeedFraction() * this.xGaitSettings.getMaxSpeed());
            this.maxVelocityYaw.setValue(this.xGaitSettings.getMaxYawSpeedFraction() * this.xGaitSettings.getMaxSpeed());
            double xVelocity = xVelocityChannel.getValue() * this.xGaitSettings.getMaxSpeed();
            double yVelocity = yVelocityChannel.getValue() * this.maxVelocityY.getValue();
            double yawRate = 0.5 * (leftTurnChannel.getValue() - rightTurnChannel.getValue()) * this.maxVelocityYaw.getValue();
            QuadrupedTeleopDesiredVelocity desiredVelocity = new QuadrupedTeleopDesiredVelocity();
            desiredVelocity.setDesiredXVelocity(xVelocity);
            desiredVelocity.setDesiredYVelocity(yVelocity);
            desiredVelocity.setDesiredYawVelocity(yawRate);
            this.messager.submitMessage(QuadrupedUIMessagerAPI.DesiredTeleopVelocity, (Object)desiredVelocity);
        }
    }

    public void processEvent(Event event) {
        this.channelDataMap.get(XBoxOneMapping.getMapping((Event)event)).update(event.getValue());
    }

    private class ChannelData {
        private boolean updateFlag = false;
        private double value = 0.0;
        private double previousValue = 0.0;

        private ChannelData() {
        }

        synchronized void update(double value) {
            this.updateFlag = true;
            this.previousValue = this.value;
            this.value = value;
        }

        void initialize(double value) {
            this.updateFlag = false;
            this.value = value;
            this.previousValue = value;
        }

        synchronized double getValue() {
            this.updateFlag = false;
            return this.value;
        }

        synchronized boolean hasNewData() {
            return this.updateFlag && this.value != this.previousValue;
        }
    }
}

