/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedUI.uiControllers;

import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.messager.TopicListener;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.quadrupedRobotics.controller.QuadrupedControllerManager;
import us.ihmc.quadrupedUI.QuadrupedUIMessagerAPI;

public class RobotControlTabController {
    @FXML
    private TextField currentStateViewer;
    @FXML
    private Button sitDownButton;
    @FXML
    private Button standUpButton;
    @FXML
    private Button stopWalkingButton;
    @FXML
    private CheckBox enablePoseTeleopControl;
    @FXML
    private CheckBox enableStepTeleopControl;
    @FXML
    private CheckBox enableHeightTeleopControl;
    @FXML
    private CheckBox enableJoystickControl;
    private AtomicReference<HighLevelControllerName> currentControllerState;
    private JavaFXMessager messager;

    public void attachMessager(JavaFXMessager messager) {
        this.messager = messager;
        this.currentControllerState = messager.createInput(QuadrupedUIMessagerAPI.CurrentControllerNameTopic, null);
        messager.addTopicListener(QuadrupedUIMessagerAPI.EnableBodyTeleopTopic, this::validateBodyTopic);
        messager.addTopicListener(QuadrupedUIMessagerAPI.EnableStepTeleopTopic, this::validateWalkingTopic);
    }

    private void validateBodyTopic(boolean request) {
        if (request) {
            this.messager.submitMessage(QuadrupedUIMessagerAPI.EnableStepTeleopTopic, (Object)false);
            if (this.currentControllerState.get() != null && this.currentControllerState.get() != HighLevelControllerName.WALKING) {
                this.messager.submitMessage(QuadrupedUIMessagerAPI.EnableBodyTeleopTopic, (Object)false);
            }
        }
    }

    private void validateWalkingTopic(boolean request) {
        if (request) {
            this.messager.submitMessage(QuadrupedUIMessagerAPI.EnableBodyTeleopTopic, (Object)false);
            if (this.currentControllerState.get() != null && this.currentControllerState.get() != HighLevelControllerName.WALKING) {
                this.messager.submitMessage(QuadrupedUIMessagerAPI.EnableStepTeleopTopic, (Object)false);
            }
        } else {
            this.messager.submitMessage(QuadrupedUIMessagerAPI.AbortWalkingTopic, (Object)true);
        }
    }

    public void requestStopWalking() {
        this.messager.submitMessage(QuadrupedUIMessagerAPI.EnableStepTeleopTopic, (Object)false);
        this.messager.submitMessage(QuadrupedUIMessagerAPI.AbortWalkingTopic, (Object)true);
    }

    public void requestSitDown() {
        if (this.currentControllerState.get() == HighLevelControllerName.WALKING) {
            this.messager.submitMessage(QuadrupedUIMessagerAPI.DesiredControllerNameTopic, (Object)HighLevelControllerName.EXIT_WALKING);
        } else {
            this.messager.submitMessage(QuadrupedUIMessagerAPI.DesiredControllerNameTopic, (Object)QuadrupedControllerManager.sitDownStateName);
        }
    }

    public void requestStandUp() {
        this.messager.submitMessage(QuadrupedUIMessagerAPI.DesiredControllerNameTopic, (Object)HighLevelControllerName.STAND_PREP_STATE);
    }

    public void bindControls() {
        this.messager.addFXTopicListener(QuadrupedUIMessagerAPI.CurrentControllerNameTopic, new TextViewerListener(this.currentStateViewer));
        this.messager.bindBidirectional(QuadrupedUIMessagerAPI.EnableBodyTeleopTopic, (Property)this.enablePoseTeleopControl.selectedProperty(), true);
        this.messager.bindBidirectional(QuadrupedUIMessagerAPI.EnableStepTeleopTopic, (Property)this.enableStepTeleopControl.selectedProperty(), true);
        this.messager.bindBidirectional(QuadrupedUIMessagerAPI.EnableHeightTeleopTopic, (Property)this.enableHeightTeleopControl.selectedProperty(), true);
        this.messager.bindBidirectional(QuadrupedUIMessagerAPI.EnableJoystickTopic, (Property)this.enableJoystickControl.selectedProperty(), true);
    }

    private class TextViewerListener<T>
    implements TopicListener<T> {
        private final TextField textField;

        public TextViewerListener(TextField textField) {
            this.textField = textField;
        }

        public void receivedMessageForTopic(T messageContent) {
            if (messageContent != null) {
                this.textField.promptTextProperty().setValue(messageContent.toString());
            }
        }
    }
}

