/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedUI.uiControllers;

import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.SoleTrajectoryMessage;
import ihmc_common_msgs.msg.dds.EuclideanTrajectoryPointMessage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Group;
import javafx.scene.SubScene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.paint.Color;
import quadruped_msgs.msg.dds.QuadrupedTimedStepListMessage;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.quadrupedBasics.referenceFrames.QuadrupedReferenceFrames;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.manual.ManualPawPlanGenerator;
import us.ihmc.quadrupedPlanning.QuadrupedXGaitSettingsReadOnly;
import us.ihmc.quadrupedUI.QuadrupedUIMessagerAPI;
import us.ihmc.quadrupedUI.graphics.ManualStepPlanGraphic;
import us.ihmc.quadrupedUI.graphics.PositionGraphic;
import us.ihmc.robotModels.FullQuadrupedRobotModel;
import us.ihmc.robotModels.FullQuadrupedRobotModelFactory;
import us.ihmc.robotics.robotSide.RobotQuadrant;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.robotics.sensors.IMUDefinition;
import us.ihmc.sensorProcessing.communication.packets.dataobjects.RobotConfigurationDataFactory;
import us.ihmc.sensorProcessing.frames.CommonQuadrupedReferenceFrames;
import us.ihmc.tools.thread.ExceptionHandlingThreadScheduler;

public class ManualStepTabController
extends Group {
    private static final double defaultStepHeight = 0.05;
    private static final double defaultStepDuration = 0.4;
    private static final double defaultDwellTime = 0.2;
    private static final String NO_FLAMINGO_QUADRANT_SELECTED = "None";
    private final AtomicBoolean useTrotOverCrawl = new AtomicBoolean(false);
    private final ManualPawPlanGenerator manualPlanGenerator = new ManualPawPlanGenerator();
    private final ManualStepPlanGraphic manualStepPlanGraphic = new ManualStepPlanGraphic();
    private JavaFXMessager messager;
    private AtomicReference<QuadrupedXGaitSettingsReadOnly> xGaitSettingsReference;
    private FullQuadrupedRobotModel fullRobotModel;
    private OneDoFJointBasics[] allJoints;
    private int jointNameHash;
    private QuadrupedReferenceFrames referenceFrames;
    @FXML
    private Spinner<Double> swingHeight;
    @FXML
    private Spinner<Double> stepDuration;
    @FXML
    private Spinner<Double> stepHeight;
    @FXML
    private Spinner<Double> stepLength;
    @FXML
    private Spinner<Double> stepWidth;
    @FXML
    private ComboBox<RobotQuadrant> firstFoot;
    @FXML
    private Spinner<Integer> numberOfSteps;
    @FXML
    private Spinner<Double> dwellTime;
    @FXML
    private CheckBox useTrot;
    @FXML
    private CheckBox visualizeManualStepPlan;
    @FXML
    private ComboBox<String> flamingoFoot;
    @FXML
    private Spinner<Double> flamingoTrajectoryTime;
    @FXML
    private Button requestLoadFoot;
    private PositionGraphic flamingoFootGraphic;
    private volatile boolean flamingoKeyIsHeld = false;
    private Vector3D flamingoVectorToAdd = new Vector3D();
    private final long flamingoMsPerMove = 10L;
    private final double flamingoStepAmount = 0.002;
    private ExceptionHandlingThreadScheduler flamingoPoseKeyHeldMover = new ExceptionHandlingThreadScheduler(((Object)((Object)this)).getClass().getSimpleName() + "Flamingo");

    public void setFullRobotModelFactory(FullQuadrupedRobotModelFactory fullRobotModelFactory) {
        this.fullRobotModel = fullRobotModelFactory.createFullRobotModel();
        this.allJoints = this.fullRobotModel.getOneDoFJoints();
        this.jointNameHash = RobotConfigurationDataFactory.calculateJointNameHash((OneDoFJointReadOnly[])this.allJoints, (ForceSensorDefinition[])this.fullRobotModel.getForceSensorDefinitions(), (IMUDefinition[])this.fullRobotModel.getIMUDefinitions());
        this.referenceFrames = new QuadrupedReferenceFrames(this.fullRobotModel);
    }

    public void attachMessager(JavaFXMessager messager, QuadrupedXGaitSettingsReadOnly defaultXGaitSettings) {
        this.messager = messager;
        this.xGaitSettingsReference = messager.createInput(QuadrupedUIMessagerAPI.XGaitSettingsTopic);
        messager.addTopicListener(QuadrupedUIMessagerAPI.RobotConfigurationDataTopic, this::handleRobotConfigurationData);
        this.xGaitSettingsReference.set(defaultXGaitSettings);
    }

    public void handleRobotConfigurationData(RobotConfigurationData robotConfigurationData) {
        if (this.referenceFrames == null || this.fullRobotModel == null) {
            return;
        }
        if (robotConfigurationData.getJointNameHash() != this.jointNameHash) {
            throw new RuntimeException("Joint names do not match for RobotConfigurationData");
        }
        RigidBodyTransform newRootJointPose = new RigidBodyTransform((Orientation3DReadOnly)robotConfigurationData.getRootOrientation(), (Tuple3DReadOnly)robotConfigurationData.getRootPosition());
        this.fullRobotModel.getRootJoint().setJointConfiguration((RigidBodyTransformReadOnly)newRootJointPose);
        float[] newJointConfiguration = robotConfigurationData.getJointAngles().toArray();
        for (int i = 0; i < this.allJoints.length; ++i) {
            this.allJoints[i].setQ((double)newJointConfiguration[i]);
        }
        this.fullRobotModel.getElevator().updateFramesRecursively();
        this.referenceFrames.updateFrames();
    }

    public void bindControls() {
        this.swingHeight.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.01, 0.2, 0.05, 0.01));
        this.stepHeight.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.0, 0.25, 0.0, 0.01));
        this.stepLength.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(-0.2, 0.45, 0.0, 0.02));
        this.stepWidth.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(-0.1, 0.1, 0.0, 0.02));
        this.stepDuration.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.05, 3.0, 0.4, 0.05));
        this.dwellTime.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.0, 3.0, 0.2, 0.05));
        this.numberOfSteps.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(1, 60, 1));
        this.firstFoot.setItems(FXCollections.observableArrayList((Object[])new RobotQuadrant[]{RobotQuadrant.FRONT_LEFT, RobotQuadrant.FRONT_RIGHT, RobotQuadrant.HIND_LEFT, RobotQuadrant.HIND_RIGHT}));
        this.swingHeight.getValueFactory().valueProperty().addListener(ChangeListener -> this.visualizeManualStepPlan());
        this.stepHeight.getValueFactory().valueProperty().addListener(ChangeListener -> this.visualizeManualStepPlan());
        this.stepLength.getValueFactory().valueProperty().addListener(ChangeListener -> this.visualizeManualStepPlan());
        this.stepWidth.getValueFactory().valueProperty().addListener(ChangeListener -> this.visualizeManualStepPlan());
        this.stepDuration.getValueFactory().valueProperty().addListener(ChangeListener -> this.visualizeManualStepPlan());
        this.dwellTime.getValueFactory().valueProperty().addListener(ChangeListener -> this.visualizeManualStepPlan());
        this.numberOfSteps.getValueFactory().valueProperty().addListener(ChangeListener -> this.visualizeManualStepPlan());
        this.firstFoot.valueProperty().addListener(ChangeListener -> this.visualizeManualStepPlan());
        this.useTrot.selectedProperty().addListener(ChangeListener -> this.visualizeManualStepPlan());
        this.flamingoFoot.setItems(FXCollections.observableArrayList((Object[])new String[]{NO_FLAMINGO_QUADRANT_SELECTED, RobotQuadrant.FRONT_LEFT.getTitleCaseName(), RobotQuadrant.FRONT_RIGHT.getTitleCaseName(), RobotQuadrant.HIND_LEFT.getTitleCaseName(), RobotQuadrant.HIND_RIGHT.getTitleCaseName()}));
        this.flamingoTrajectoryTime.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.0, 500.0, 2.0, 0.1));
        this.useTrot.setSelected(false);
        this.firstFoot.getSelectionModel().select((Object)RobotQuadrant.FRONT_RIGHT);
        this.flamingoFoot.getSelectionModel().select((Object)NO_FLAMINGO_QUADRANT_SELECTED);
        this.requestLoadFoot.setOnAction(event -> {
            if (!((String)this.flamingoFoot.getValue()).equals(NO_FLAMINGO_QUADRANT_SELECTED)) {
                RobotQuadrant quadrant = RobotQuadrant.guessQuadrantFromName((String)((String)this.flamingoFoot.getValue()));
                this.messager.submitMessage(QuadrupedUIMessagerAPI.LoadBearingRequestTopic, (Object)quadrant);
            }
        });
    }

    public void initScene(SubScene subScene) {
        this.getChildren().add((Object)this.manualStepPlanGraphic);
        this.flamingoFootGraphic = new PositionGraphic(Color.PINK, 0.03);
        this.flamingoFootGraphic.clear();
        this.getChildren().add((Object)this.flamingoFootGraphic.getNode());
        subScene.addEventHandler(KeyEvent.ANY, this::onKeyEvent);
        this.flamingoFoot.addEventHandler(KeyEvent.ANY, this::onKeyEvent);
        this.flamingoPoseKeyHeldMover.schedule(() -> {
            if (this.flamingoKeyIsHeld) {
                Platform.runLater(() -> {
                    this.flamingoFootGraphic.getPose().appendTranslation((Tuple3DReadOnly)this.flamingoVectorToAdd);
                    this.flamingoFootGraphic.update();
                });
            }
        }, 10L, TimeUnit.MILLISECONDS);
    }

    private void onKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getEventType() == KeyEvent.KEY_PRESSED && !this.flamingoKeyIsHeld) {
            if (this.isNumpadKey(keyEvent)) {
                this.flamingoKeyIsHeld = true;
                keyEvent.consume();
                if (keyEvent.getCode() == KeyCode.NUMPAD8) {
                    this.flamingoVectorToAdd.setY(0.002);
                } else if (keyEvent.getCode() == KeyCode.NUMPAD2) {
                    this.flamingoVectorToAdd.setY(-0.002);
                } else if (keyEvent.getCode() == KeyCode.NUMPAD7) {
                    this.flamingoVectorToAdd.setZ(0.002);
                } else if (keyEvent.getCode() == KeyCode.NUMPAD1) {
                    this.flamingoVectorToAdd.setZ(-0.002);
                } else if (keyEvent.getCode() == KeyCode.NUMPAD4) {
                    this.flamingoVectorToAdd.setX(-0.002);
                } else if (keyEvent.getCode() == KeyCode.NUMPAD6) {
                    this.flamingoVectorToAdd.setX(0.002);
                }
            }
        } else if (keyEvent.getEventType() == KeyEvent.KEY_RELEASED && this.flamingoKeyIsHeld) {
            if (this.isNumpadKey(keyEvent)) {
                this.flamingoKeyIsHeld = false;
                keyEvent.consume();
                this.flamingoVectorToAdd.setToZero();
            }
        } else if (keyEvent.getEventType() == KeyEvent.KEY_TYPED && keyEvent.getCharacter().equals(" ")) {
            keyEvent.consume();
            this.sendFlamingoFootPose();
        }
    }

    private boolean isNumpadKey(KeyEvent keyEvent) {
        return keyEvent.getCode() == KeyCode.NUMPAD8 || keyEvent.getCode() == KeyCode.NUMPAD2 || keyEvent.getCode() == KeyCode.NUMPAD7 || keyEvent.getCode() == KeyCode.NUMPAD1 || keyEvent.getCode() == KeyCode.NUMPAD4 || keyEvent.getCode() == KeyCode.NUMPAD6;
    }

    @FXML
    public void sendSteps() {
        if (this.firstFoot.getSelectionModel().isEmpty()) {
            LogTools.info((String)"Select a quadrant");
            return;
        }
        this.messager.submitMessage(QuadrupedUIMessagerAPI.ManualStepsListMessageTopic, (Object)this.generateManualStepPlan());
    }

    private QuadrupedTimedStepListMessage generateManualStepPlan() {
        return this.manualPlanGenerator.generateSteps(this.useTrot.isSelected(), (RobotQuadrant)this.firstFoot.getValue(), ((Double)this.swingHeight.getValue()).doubleValue(), ((Double)this.stepHeight.getValue()).doubleValue(), ((Double)this.stepLength.getValue()).doubleValue(), ((Double)this.stepWidth.getValue()).doubleValue(), ((Double)this.stepDuration.getValue()).doubleValue(), ((Double)this.dwellTime.getValue()).doubleValue(), ((Integer)this.numberOfSteps.getValue()).intValue(), this.xGaitSettingsReference.get(), (CommonQuadrupedReferenceFrames)this.referenceFrames);
    }

    public void setUseTrot() {
        this.useTrotOverCrawl.set(this.useTrot.isSelected());
    }

    @FXML
    public void visualizeManualStepPlan() {
        if (this.visualizeManualStepPlan.isSelected()) {
            this.manualStepPlanGraphic.generateMeshesAsynchronously(this.generateManualStepPlan());
        } else {
            this.manualStepPlanGraphic.clear();
        }
    }

    @FXML
    public void flamingoFoot() {
        String quadrantSelection = (String)this.flamingoFoot.getValue();
        if (!quadrantSelection.equals(NO_FLAMINGO_QUADRANT_SELECTED)) {
            FramePose3D solePose = new FramePose3D();
            solePose.setFromReferenceFrame((ReferenceFrame)this.referenceFrames.getSoleFrame(RobotQuadrant.guessQuadrantFromName((String)((String)this.flamingoFoot.getValue()))));
            this.flamingoFootGraphic.setPosition((Point3DReadOnly)solePose.getPosition());
            this.flamingoFootGraphic.update();
        } else {
            this.flamingoFootGraphic.clear();
        }
    }

    public void sendFlamingoFootPose() {
        String quadrantSelection = (String)this.flamingoFoot.getValue();
        if (!quadrantSelection.equals(NO_FLAMINGO_QUADRANT_SELECTED)) {
            SoleTrajectoryMessage soleTrajectoryMessage = new SoleTrajectoryMessage();
            soleTrajectoryMessage.setRobotQuadrant(RobotQuadrant.guessQuadrantFromName((String)quadrantSelection).toByte());
            EuclideanTrajectoryPointMessage trajectoryPointMessage = (EuclideanTrajectoryPointMessage)soleTrajectoryMessage.getPositionTrajectory().getTaskspaceTrajectoryPoints().add();
            trajectoryPointMessage.setTime(((Double)this.flamingoTrajectoryTime.getValue()).doubleValue());
            trajectoryPointMessage.getPosition().set((Tuple3DReadOnly)this.flamingoFootGraphic.getPose().getPosition());
            this.messager.submitMessage(QuadrupedUIMessagerAPI.SoleTrajectoryMessageTopic, (Object)soleTrajectoryMessage);
        }
    }

    public void stop() {
        this.flamingoPoseKeyHeldMover.shutdown();
        this.manualStepPlanGraphic.stop();
    }
}

