/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedUI.video;

import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import perception_msgs.msg.dds.VideoPacket;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.producers.JPEGDecompressor;
import us.ihmc.communication.producers.VideoSource;
import us.ihmc.concurrent.ConcurrentRingBuffer;
import us.ihmc.javafx.PrivateAnimationTimer;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Messager;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.ros2.ROS2Callback;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;

public class QuadrupedJavaFXROS2VideoView
extends ImageView {
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(ThreadTools.getNamedThreadFactory((String)((Object)((Object)this)).getClass().getSimpleName()));
    private final PrivateAnimationTimer animationTimer = new PrivateAnimationTimer(this::handle);
    private final JPEGDecompressor jpegDecompressor = new JPEGDecompressor();
    private final ConcurrentRingBuffer<WritableImage> writableImageBuffer;
    private final boolean flipX;
    private final boolean flipY;
    private volatile boolean running = false;

    public QuadrupedJavaFXROS2VideoView(int width, int height, boolean flipX, boolean flipY) {
        this.flipX = flipX;
        this.flipY = flipY;
        this.writableImageBuffer = new ConcurrentRingBuffer(() -> new WritableImage(width, height), 4);
    }

    public void start(ROS2Node ros2Node) {
        if (this.running) {
            LogTools.error((String)"Video view is already running.");
            return;
        }
        this.running = true;
        new ROS2Callback((ROS2NodeInterface)ros2Node, VideoPacket.class, ROS2Tools.IHMC_ROOT, this::acceptVideo);
        this.animationTimer.start();
    }

    public void start(Messager messager, MessagerAPIFactory.Topic<VideoPacket> videoTopic) {
        if (this.running) {
            LogTools.error((String)"Video view is already running.");
            return;
        }
        this.running = true;
        messager.registerTopicListener(videoTopic, this::acceptVideo);
        this.animationTimer.start();
    }

    public void stop() {
        this.running = false;
        this.animationTimer.stop();
        this.executorService.shutdownNow();
    }

    private void acceptVideo(VideoPacket message) {
        if (this.running && VideoSource.fromByte((byte)message.getVideoSource()) == VideoSource.MULTISENSE_LEFT_EYE) {
            this.executorService.submit(() -> {
                BufferedImage bufferedImage = this.jpegDecompressor.decompressJPEGDataToBufferedImage(message.getData().toArray());
                LogTools.trace((String)"res x: {}, y: {}", (Object)bufferedImage.getWidth(), (Object)bufferedImage.getHeight());
                WritableImage nextImage = (WritableImage)this.writableImageBuffer.next();
                if (nextImage != null) {
                    PixelWriter pixelWriter = nextImage.getPixelWriter();
                    for (int x = 0; x < bufferedImage.getWidth(); ++x) {
                        for (int y = 0; y < bufferedImage.getHeight(); ++y) {
                            pixelWriter.setArgb(this.flipX ? bufferedImage.getWidth() - 1 - x : x, this.flipY ? bufferedImage.getHeight() - 1 - y : y, bufferedImage.getRGB(x, y));
                        }
                    }
                    this.writableImageBuffer.commit();
                }
            });
        }
    }

    private void handle(long now) {
        if (this.writableImageBuffer.poll()) {
            WritableImage latestImage = null;
            WritableImage image = null;
            while ((image = (WritableImage)this.writableImageBuffer.read()) != null) {
                latestImage = image;
            }
            if (latestImage != null) {
                this.setImage((Image)latestImage);
            }
            this.writableImageBuffer.flush();
        }
    }
}

