/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedUI.graphics;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import quadruped_msgs.msg.dds.QuadrupedTimedStepListMessage;
import quadruped_msgs.msg.dds.QuadrupedTimedStepMessage;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.javaFXToolkit.shapes.JavaFXMultiColorMeshBuilder;
import us.ihmc.javaFXToolkit.shapes.TextureColorAdaptivePalette;
import us.ihmc.javaFXToolkit.shapes.TextureColorPalette;
import us.ihmc.javafx.PrivateAnimationTimer;
import us.ihmc.log.LogTools;
import us.ihmc.quadrupedUI.QuadrupedUserInterface;
import us.ihmc.robotics.robotSide.QuadrantDependentList;
import us.ihmc.robotics.robotSide.RobotQuadrant;

public class ManualStepPlanGraphic
extends Group {
    private static final double RADIUS = 0.02;
    private static final double zOffset = 0.01;
    private final MeshView meshView = new MeshView();
    private final PrivateAnimationTimer animationTimer = new PrivateAnimationTimer(this::handle);
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(ThreadTools.getNamedThreadFactory((String)((Object)((Object)this)).getClass().getSimpleName()));
    private final TextureColorAdaptivePalette palette = new TextureColorAdaptivePalette(1024, false);
    private final JavaFXMultiColorMeshBuilder meshBuilder = new JavaFXMultiColorMeshBuilder((TextureColorPalette)this.palette);
    private Mesh mesh;
    private Material material;

    public ManualStepPlanGraphic() {
        this.getChildren().addAll((Object[])new Node[]{this.meshView});
        this.animationTimer.start();
    }

    public void generateMeshesAsynchronously(QuadrupedTimedStepListMessage plan) {
        this.executorService.submit(() -> {
            LogTools.debug((String)"Received pawstep plan containing {} steps", (Object)plan.getQuadrupedStepList().size());
            this.generateMeshes(plan);
        });
    }

    public void generateMeshes(QuadrupedTimedStepListMessage message) {
        this.meshBuilder.clear();
        QuadrantDependentList<Color> colors = QuadrupedUserInterface.feetColors;
        FramePoint3D footPosition = new FramePoint3D();
        for (int i = 0; i < message.getQuadrupedStepList().size(); ++i) {
            QuadrupedTimedStepMessage footstep = (QuadrupedTimedStepMessage)message.getQuadrupedStepList().get(i);
            Color regionColor = (Color)colors.get((Enum)RobotQuadrant.fromByte((byte)footstep.getQuadrupedStepMessage().getRobotQuadrant()));
            footPosition.set((Tuple3DReadOnly)footstep.getQuadrupedStepMessage().getGoalPosition());
            footPosition.addZ(0.01);
            this.meshBuilder.addSphere(0.02, (Tuple3DReadOnly)footPosition, regionColor);
        }
        this.generateAndQueueForJavaFXUpdate();
    }

    public void clear() {
        this.meshBuilder.clear();
        this.generateAndQueueForJavaFXUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateAndQueueForJavaFXUpdate() {
        Mesh mesh = this.meshBuilder.generateMesh();
        Material material = this.meshBuilder.generateMaterial();
        ManualStepPlanGraphic manualStepPlanGraphic = this;
        synchronized (manualStepPlanGraphic) {
            this.mesh = mesh;
            this.material = material;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(long now) {
        ManualStepPlanGraphic manualStepPlanGraphic = this;
        synchronized (manualStepPlanGraphic) {
            this.meshView.setMesh(this.mesh);
            this.meshView.setMaterial(this.material);
        }
    }

    public void stop() {
        this.executorService.shutdown();
        this.animationTimer.stop();
    }
}

