/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedUI;

import controller_msgs.msg.dds.RobotConfigurationData;
import java.text.DecimalFormat;
import java.util.concurrent.atomic.AtomicReference;
import javafx.animation.AnimationTimer;
import javafx.scene.control.Label;
import us.ihmc.commons.Conversions;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.messager.MessagerAPIFactory;

public class TimeStatisticsManager
extends AnimationTimer {
    private final Label timeSinceLastUpdateLabel;
    private final Label lastControllerTimeLabel;
    private final DecimalFormat format = new DecimalFormat("0.000");
    private final AtomicReference<RobotConfigurationData> robotConfigurationDataReference;
    private final AtomicReference<String> newTimeToDisplay = new AtomicReference<Object>(null);
    private long lastUpdateTimestamp = -1L;

    public TimeStatisticsManager(Label timeSinceLastUpdateLabel, Label lastControllerTimeLabel, JavaFXMessager messager, MessagerAPIFactory.Topic<RobotConfigurationData> robotConfigurationDataTopic) {
        this.timeSinceLastUpdateLabel = timeSinceLastUpdateLabel;
        this.lastControllerTimeLabel = lastControllerTimeLabel;
        this.robotConfigurationDataReference = messager.createInput(robotConfigurationDataTopic, null);
        messager.registerTopicListener(robotConfigurationDataTopic, m -> {
            if (m != null && this.newTimeToDisplay.get() == null) {
                this.newTimeToDisplay.set(this.format.format(Conversions.nanosecondsToSeconds((long)m.getMonotonicTime())));
            }
        });
    }

    public void handle(long now) {
        String timeFormatted;
        RobotConfigurationData robotConfigurationData = this.robotConfigurationDataReference.getAndSet(null);
        if (robotConfigurationData != null) {
            this.lastUpdateTimestamp = now;
            timeFormatted = this.format.format(Conversions.nanosecondsToSeconds((long)robotConfigurationData.getMonotonicTime()));
            this.lastControllerTimeLabel.setText(timeFormatted);
        }
        if (this.lastUpdateTimestamp > 0L) {
            timeFormatted = this.format.format(Conversions.nanosecondsToSeconds((long)(now - this.lastUpdateTimestamp)));
            this.timeSinceLastUpdateLabel.setText(timeFormatted);
        }
    }
}

