/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedUI;

import controller_msgs.msg.dds.RobotConfigurationData;
import java.util.function.Consumer;
import javafx.animation.AnimationTimer;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SubScene;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javafx.stage.Stage;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.javaFXToolkit.cameraControllers.FocusBasedCameraMouseEventHandler;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.javaFXToolkit.scenes.View3DFactory;
import us.ihmc.javafx.JavaFXQuadrupedVisualizer;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Messager;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.VisibilityGraphsParametersBasics;
import us.ihmc.pathPlanning.visibilityGraphs.ui.StartGoalPositionEditor;
import us.ihmc.pathPlanning.visibilityGraphs.ui.viewers.PlanarRegionViewer;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.parameters.PawStepPlannerParametersBasics;
import us.ihmc.quadrupedFootstepPlanning.ui.components.StartGoalOrientationEditor;
import us.ihmc.quadrupedFootstepPlanning.ui.controllers.PawStepPlannerMenuUIController;
import us.ihmc.quadrupedFootstepPlanning.ui.controllers.PawStepPlannerParametersUIController;
import us.ihmc.quadrupedFootstepPlanning.ui.controllers.PlannerReachParametersUIController;
import us.ihmc.quadrupedFootstepPlanning.ui.controllers.QuadrupedMainTabController;
import us.ihmc.quadrupedFootstepPlanning.ui.controllers.VisibilityGraphsParametersUIController;
import us.ihmc.quadrupedFootstepPlanning.ui.viewers.BodyPawPathMeshViewer;
import us.ihmc.quadrupedFootstepPlanning.ui.viewers.PawPathMeshViewer;
import us.ihmc.quadrupedFootstepPlanning.ui.viewers.StartGoalPawOrientationViewer;
import us.ihmc.quadrupedFootstepPlanning.ui.viewers.StartGoalPawPositionViewer;
import us.ihmc.quadrupedPlanning.QuadrupedXGaitSettingsReadOnly;
import us.ihmc.quadrupedRobotics.model.QuadrupedModelFactory;
import us.ihmc.quadrupedUI.QuadrupedJoystickModule;
import us.ihmc.quadrupedUI.QuadrupedUIMessagerAPI;
import us.ihmc.quadrupedUI.TimeStatisticsManager;
import us.ihmc.quadrupedUI.skybox.QuadrupedSkybox3D;
import us.ihmc.quadrupedUI.uiControllers.ManualStepTabController;
import us.ihmc.quadrupedUI.uiControllers.RobotControlTabController;
import us.ihmc.quadrupedUI.uiControllers.XGaitSettingsController;
import us.ihmc.quadrupedUI.video.QuadrupedVideoViewOverlay;
import us.ihmc.robotModels.FullQuadrupedRobotModelFactory;
import us.ihmc.robotics.robotSide.QuadrantDependentList;
import us.ihmc.tools.inputDevices.joystick.Joystick;
import us.ihmc.tools.inputDevices.joystick.JoystickModel;

public class QuadrupedUserInterface {
    public static final QuadrantDependentList<Color> feetColors = new QuadrantDependentList((Object)Color.web((String)"#DA5526"), (Object)Color.web((String)"#F68930"), (Object)Color.web((String)"#0C695D"), (Object)Color.web((String)"#37AFA9"));
    private final Stage primaryStage;
    private final BorderPane mainPane;
    private final JavaFXMessager messager;
    private final PlanarRegionViewer planarRegionViewer;
    private final StartGoalPawPositionViewer startGoalPositionViewer;
    private final StartGoalPawOrientationViewer startGoalOrientationViewer;
    private final StartGoalPositionEditor startGoalPositionEditor;
    private final StartGoalOrientationEditor startGoalOrientationEditor;
    private final PawPathMeshViewer pawPathViewer;
    private final BodyPawPathMeshViewer bodyPathMeshViewer;
    private final TimeStatisticsManager timeStatisticsManager;
    private final JavaFXQuadrupedVisualizer robotVisualizer;
    private final AnimationTimer cameraTracking;
    private final Joystick joystick;
    private final AnimationTimer joystickModule;
    private final QuadrupedVideoViewOverlay videoViewOverlay;
    @FXML
    private AnchorPane sceneAnchorPane;
    @FXML
    private Label timeSinceLastUpdateLabel;
    @FXML
    private Label lastControllerTimeLabel;
    @FXML
    private PawStepPlannerMenuUIController pawStepPlannerMenuUIController;
    @FXML
    private QuadrupedMainTabController plannerTabController;
    @FXML
    private RobotControlTabController robotControlTabController;
    @FXML
    private XGaitSettingsController xGaitSettingsController;
    @FXML
    private PawStepPlannerParametersUIController pawStepPlannerParametersUIController;
    @FXML
    private PlannerReachParametersUIController plannerReachParametersUIController;
    @FXML
    private VisibilityGraphsParametersUIController visibilityGraphsParametersUIController;
    @FXML
    private ManualStepTabController manualStepTabController;

    public QuadrupedUserInterface(Stage primaryStage, JavaFXMessager messager, QuadrupedModelFactory modelFactory, double nominalBodyHeight, PawStepPlannerParametersBasics pawPlannerParameters, VisibilityGraphsParametersBasics visibilityGraphsParameters, QuadrupedXGaitSettingsReadOnly xGaitSettings, Consumer<Graphics3DNode> graphicsMutator) throws Exception {
        this.primaryStage = primaryStage;
        this.messager = messager;
        FXMLLoader loader = new FXMLLoader();
        loader.setController((Object)this);
        loader.setLocation(this.getClass().getResource(this.getClass().getSimpleName() + ".fxml"));
        this.mainPane = (BorderPane)loader.load();
        this.pawStepPlannerParametersUIController.setPlannerParameters(pawPlannerParameters);
        this.plannerReachParametersUIController.setPlannerParameters(pawPlannerParameters);
        this.visibilityGraphsParametersUIController.setVisbilityGraphsParameters(visibilityGraphsParameters);
        this.plannerTabController.attachMessager(messager);
        this.robotControlTabController.attachMessager(messager);
        this.xGaitSettingsController.attachMessager(messager, xGaitSettings);
        this.pawStepPlannerParametersUIController.attachMessager(messager);
        this.plannerReachParametersUIController.attachMessager(messager);
        this.visibilityGraphsParametersUIController.attachMessager(messager);
        this.manualStepTabController.attachMessager(messager, xGaitSettings);
        this.manualStepTabController.setFullRobotModelFactory((FullQuadrupedRobotModelFactory)modelFactory);
        this.setPlannerTabTopics();
        this.pawStepPlannerParametersUIController.setPlannerParametersTopic(QuadrupedUIMessagerAPI.FootstepPlannerParametersTopic);
        this.plannerReachParametersUIController.setPlannerParametersTopic(QuadrupedUIMessagerAPI.FootstepPlannerParametersTopic);
        this.visibilityGraphsParametersUIController.setVisibilityGraphsParametersTopic(QuadrupedUIMessagerAPI.VisibilityGraphsParametersTopic);
        this.plannerTabController.bindControls();
        this.robotControlTabController.bindControls();
        this.pawStepPlannerParametersUIController.bindControls();
        this.plannerReachParametersUIController.bindControls();
        this.visibilityGraphsParametersUIController.bindControls();
        this.xGaitSettingsController.bindControls();
        this.manualStepTabController.bindControls();
        this.pawStepPlannerParametersUIController.loadFromFile();
        this.plannerReachParametersUIController.loadFromFile();
        View3DFactory view3dFactory = View3DFactory.createSubscene();
        view3dFactory.addDefaultLighting();
        FocusBasedCameraMouseEventHandler cameraController = view3dFactory.addCameraController(0.05, 1000000.0, true);
        SubScene subScene = view3dFactory.getSubScene();
        view3dFactory.addWorldCoordinateSystem(0.3);
        view3dFactory.addNodeToView(new QuadrupedSkybox3D(subScene).getSkybox());
        Pane subScenePane = view3dFactory.getSubSceneWrappedInsidePane();
        this.timeStatisticsManager = new TimeStatisticsManager(this.timeSinceLastUpdateLabel, this.lastControllerTimeLabel, messager, QuadrupedUIMessagerAPI.RobotConfigurationDataTopic);
        this.planarRegionViewer = new PlanarRegionViewer((Messager)messager, QuadrupedUIMessagerAPI.PlanarRegionDataTopic, QuadrupedUIMessagerAPI.ShowPlanarRegionsTopic);
        this.startGoalPositionViewer = new StartGoalPawPositionViewer((Messager)messager, QuadrupedUIMessagerAPI.StartPositionEditModeEnabledTopic, QuadrupedUIMessagerAPI.GoalPositionEditModeEnabledTopic, QuadrupedUIMessagerAPI.StartPositionTopic, QuadrupedUIMessagerAPI.StartOrientationTopic, QuadrupedUIMessagerAPI.LowLevelGoalPositionTopic, QuadrupedUIMessagerAPI.GoalPositionTopic, QuadrupedUIMessagerAPI.GoalOrientationTopic, QuadrupedUIMessagerAPI.StartFeetPositionTopic, QuadrupedUIMessagerAPI.XGaitSettingsTopic, QuadrupedUIMessagerAPI.PlanarRegionDataTopic);
        this.startGoalOrientationViewer = new StartGoalPawOrientationViewer((Messager)messager, QuadrupedUIMessagerAPI.StartOrientationEditModeEnabledTopic, QuadrupedUIMessagerAPI.GoalOrientationEditModeEnabledTopic, QuadrupedUIMessagerAPI.StartPositionTopic, QuadrupedUIMessagerAPI.StartOrientationTopic, QuadrupedUIMessagerAPI.LowLevelGoalPositionTopic, QuadrupedUIMessagerAPI.LowLevelGoalOrientationTopic, QuadrupedUIMessagerAPI.GoalPositionTopic, QuadrupedUIMessagerAPI.GoalOrientationTopic);
        this.startGoalPositionEditor = new StartGoalPositionEditor((Messager)messager, (Node)subScenePane, QuadrupedUIMessagerAPI.StartPositionEditModeEnabledTopic, QuadrupedUIMessagerAPI.GoalPositionEditModeEnabledTopic, QuadrupedUIMessagerAPI.StartPositionTopic, QuadrupedUIMessagerAPI.GoalPositionTopic, QuadrupedUIMessagerAPI.PlanarRegionDataTopic, QuadrupedUIMessagerAPI.SelectedRegionTopic, QuadrupedUIMessagerAPI.StartOrientationEditModeEnabledTopic, QuadrupedUIMessagerAPI.GoalOrientationEditModeEnabledTopic);
        this.startGoalOrientationEditor = new StartGoalOrientationEditor((Messager)messager, subScene, QuadrupedUIMessagerAPI.EditModeEnabledTopic, QuadrupedUIMessagerAPI.StartOrientationEditModeEnabledTopic, QuadrupedUIMessagerAPI.GoalOrientationEditModeEnabledTopic, QuadrupedUIMessagerAPI.StartPositionTopic, QuadrupedUIMessagerAPI.StartOrientationTopic, QuadrupedUIMessagerAPI.GoalPositionTopic, QuadrupedUIMessagerAPI.GoalOrientationTopic, QuadrupedUIMessagerAPI.SelectedRegionTopic);
        this.pawPathViewer = new PawPathMeshViewer((Messager)messager, QuadrupedUIMessagerAPI.FootstepPlanTopic, QuadrupedUIMessagerAPI.ComputePathTopic, QuadrupedUIMessagerAPI.ShowFootstepPlanTopic, QuadrupedUIMessagerAPI.ShowFootstepPreviewTopic);
        this.pawPathViewer.setFootstepRadius(0.025);
        this.pawPathViewer.setFootstepColors(feetColors);
        this.bodyPathMeshViewer = new BodyPawPathMeshViewer((Messager)messager, QuadrupedUIMessagerAPI.ShowBodyPathTopic, QuadrupedUIMessagerAPI.ComputePathTopic, QuadrupedUIMessagerAPI.BodyPathDataTopic);
        this.plannerTabController.setPreviewFootstepPositions(this.pawPathViewer.getPreviewFootstepPositions());
        this.manualStepTabController.initScene(subScene);
        primaryStage.addEventHandler(KeyEvent.ANY, this::onKeyEvent);
        this.robotVisualizer = new JavaFXQuadrupedVisualizer((FullQuadrupedRobotModelFactory)modelFactory, graphicsMutator);
        this.robotVisualizer.attachMessager((Messager)messager, QuadrupedUIMessagerAPI.RobotModelTopic);
        messager.registerTopicListener(QuadrupedUIMessagerAPI.RobotConfigurationDataTopic, this::submitNewConfiguration);
        this.plannerTabController.setFullRobotModel(this.robotVisualizer.getFullRobotModel());
        messager.submitMessage(QuadrupedUIMessagerAPI.XGaitSettingsTopic, (Object)xGaitSettings);
        view3dFactory.addNodeToView(this.planarRegionViewer.getRoot());
        view3dFactory.addNodeToView(this.startGoalPositionViewer.getRoot());
        view3dFactory.addNodeToView(this.startGoalOrientationViewer.getRoot());
        view3dFactory.addNodeToView(this.robotVisualizer.getRootNode());
        view3dFactory.addNodeToView(this.pawPathViewer.getRoot());
        view3dFactory.addNodeToView(this.bodyPathMeshViewer.getRoot());
        view3dFactory.addNodeToView((Node)this.manualStepTabController);
        final Translate rootJointOffset = new Translate();
        cameraController.prependTransform((Transform)rootJointOffset);
        this.cameraTracking = new AnimationTimer(){

            public void handle(long now) {
                FramePoint3D rootJointPosition = new FramePoint3D((ReferenceFrame)QuadrupedUserInterface.this.robotVisualizer.getFullRobotModel().getRootJoint().getFrameAfterJoint());
                rootJointPosition.changeFrame(ReferenceFrame.getWorldFrame());
                rootJointOffset.setX(rootJointPosition.getX());
                rootJointOffset.setY(rootJointPosition.getY());
                rootJointOffset.setZ(rootJointPosition.getZ());
            }
        };
        if (Joystick.isAJoystickConnectedToSystem()) {
            this.joystick = new Joystick(JoystickModel.XBOX_ONE, 0);
            this.joystickModule = new QuadrupedJoystickModule((Messager)messager, xGaitSettings, this.robotVisualizer.getFullRobotModel(), nominalBodyHeight, this.joystick);
            this.joystickModule.start();
        } else {
            this.joystick = null;
            this.joystickModule = null;
            LogTools.warn((String)"No joystick detected, running without xbox module");
        }
        int width = 1024;
        int height = 544;
        this.videoViewOverlay = new QuadrupedVideoViewOverlay(width, height, true, true);
        this.sceneAnchorPane.getChildren().set(1, (Object)this.videoViewOverlay.getNode());
        AnchorPane.setTopAnchor((Node)this.videoViewOverlay.getNode(), (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.videoViewOverlay.getNode(), (Double)0.0);
        this.videoViewOverlay.getNode().addEventHandler(MouseEvent.MOUSE_PRESSED, event -> this.videoViewOverlay.toggleMode());
        this.videoViewOverlay.start((Messager)messager, QuadrupedUIMessagerAPI.LeftCameraVideo);
        this.timeStatisticsManager.start();
        this.planarRegionViewer.start();
        this.startGoalPositionViewer.start();
        this.startGoalOrientationViewer.start();
        this.startGoalPositionEditor.start();
        this.startGoalOrientationEditor.start();
        this.pawPathViewer.start();
        this.bodyPathMeshViewer.start();
        this.robotVisualizer.start();
        this.cameraTracking.start();
        this.sceneAnchorPane.getChildren().set(0, (Object)subScenePane);
        AnchorPane.setTopAnchor((Node)subScenePane, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)subScenePane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)subScenePane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)subScenePane, (Double)0.0);
        primaryStage.setTitle(this.getClass().getSimpleName());
        primaryStage.setMaximized(true);
        Scene mainScene = new Scene((Parent)this.mainPane, 600.0, 400.0);
        primaryStage.setScene(mainScene);
        primaryStage.setOnCloseRequest(event -> this.stop());
    }

    private void onKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getEventType() == KeyEvent.KEY_PRESSED && keyEvent.getCode() == KeyCode.ESCAPE) {
            this.messager.submitMessage(QuadrupedUIMessagerAPI.EnableStepTeleopTopic, (Object)false);
            this.messager.submitMessage(QuadrupedUIMessagerAPI.AbortWalkingTopic, (Object)true);
        }
    }

    private void submitNewConfiguration(RobotConfigurationData configuration) {
        this.robotVisualizer.submitNewConfiguration(configuration);
    }

    public void show() {
        this.primaryStage.show();
    }

    public void stop() {
        this.timeStatisticsManager.stop();
        this.plannerTabController.stop();
        this.planarRegionViewer.stop();
        this.startGoalPositionViewer.stop();
        this.startGoalOrientationViewer.stop();
        this.startGoalPositionEditor.stop();
        this.startGoalOrientationEditor.stop();
        this.pawPathViewer.stop();
        this.bodyPathMeshViewer.stop();
        this.cameraTracking.stop();
        this.videoViewOverlay.stop();
        this.manualStepTabController.stop();
        if (this.joystick != null) {
            this.joystick.shutdown();
        }
        if (this.joystickModule != null) {
            this.joystickModule.stop();
        }
        try {
            this.robotVisualizer.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setPlannerTabTopics() {
        this.plannerTabController.setPlannerTypeTopic(QuadrupedUIMessagerAPI.PlannerTypeTopic);
        this.plannerTabController.setPlannerRequestIdTopic(QuadrupedUIMessagerAPI.PlannerRequestIdTopic);
        this.plannerTabController.setReceivedPlanIdTopic(QuadrupedUIMessagerAPI.ReceivedPlanIdTopic);
        this.plannerTabController.setFootstepPlanTopic(QuadrupedUIMessagerAPI.ShowFootstepPlanTopic, QuadrupedUIMessagerAPI.FootstepPlanTopic);
        this.plannerTabController.setPlanarRegionDataClearTopic(QuadrupedUIMessagerAPI.PlanarRegionDataClearTopic);
        this.plannerTabController.setPlanarRegionDataTopic(QuadrupedUIMessagerAPI.PlanarRegionDataTopic);
        this.plannerTabController.setPlannerTimeTakenTopic(QuadrupedUIMessagerAPI.PlannerTimeTakenTopic);
        this.plannerTabController.setPlannerTimeoutTopic(QuadrupedUIMessagerAPI.PlannerTimeoutTopic);
        this.plannerTabController.setComputePathTopic(QuadrupedUIMessagerAPI.ComputePathTopic);
        this.plannerTabController.setAbortPlanningTopic(QuadrupedUIMessagerAPI.AbortPlanningTopic);
        this.plannerTabController.setAcceptNewPlanarRegionsTopic(QuadrupedUIMessagerAPI.AcceptNewPlanarRegionsTopic);
        this.plannerTabController.setPlanningResultTopic(QuadrupedUIMessagerAPI.PlanningResultTopic);
        this.plannerTabController.setPlannerStatusTopic(QuadrupedUIMessagerAPI.PlannerStatusTopic);
        this.plannerTabController.setPlannerHorizonLengthTopic(QuadrupedUIMessagerAPI.PlannerHorizonLengthTopic);
        this.plannerTabController.setStartGoalTopics(QuadrupedUIMessagerAPI.EditModeEnabledTopic, QuadrupedUIMessagerAPI.StartPositionEditModeEnabledTopic, QuadrupedUIMessagerAPI.GoalPositionEditModeEnabledTopic, QuadrupedUIMessagerAPI.InitialSupportQuadrantTopic, QuadrupedUIMessagerAPI.StartPositionTopic, QuadrupedUIMessagerAPI.StartOrientationTopic, QuadrupedUIMessagerAPI.GoalPositionTopic, QuadrupedUIMessagerAPI.GoalOrientationTopic, QuadrupedUIMessagerAPI.StartTargetTypeTopic, QuadrupedUIMessagerAPI.StartFeetPositionTopic);
        this.plannerTabController.setAssumeFlatGroundTopic(QuadrupedUIMessagerAPI.AssumeFlatGroundTopic);
        this.plannerTabController.setGlobalResetTopic(QuadrupedUIMessagerAPI.GlobalResetTopic);
        this.plannerTabController.setPlannerPlaybackFractionTopic(QuadrupedUIMessagerAPI.PlannerPlaybackFractionTopic);
        this.plannerTabController.setXGaitSettingsTopic(QuadrupedUIMessagerAPI.XGaitSettingsTopic);
        this.plannerTabController.setShowFootstepPreviewTopic(QuadrupedUIMessagerAPI.ShowFootstepPreviewTopic);
        this.plannerTabController.setStepListMessageTopic(QuadrupedUIMessagerAPI.FootstepPlannerTimedStepsTopic);
        this.plannerTabController.setDesiredSteppingStateNameTopic(QuadrupedUIMessagerAPI.DesiredSteppingStateNameTopic, QuadrupedUIMessagerAPI.CurrentSteppingStateNameTopic);
        this.plannerTabController.setAbortWalkingTopic(QuadrupedUIMessagerAPI.AbortWalkingTopic);
        this.plannerTabController.setEnableStepTeleopTopic(QuadrupedUIMessagerAPI.EnableStepTeleopTopic);
    }

    public static QuadrupedUserInterface createUserInterface(Stage primaryStage, JavaFXMessager messager, QuadrupedModelFactory modelFactory, PawStepPlannerParametersBasics pawPlannerParameters, VisibilityGraphsParametersBasics visibilityGraphsParameters, double nominalBodyHeight, QuadrupedXGaitSettingsReadOnly xGaitSettings, Consumer<Graphics3DNode> graphicsMutator) throws Exception {
        return new QuadrupedUserInterface(primaryStage, messager, modelFactory, nominalBodyHeight, pawPlannerParameters, visibilityGraphsParameters, xGaitSettings, graphicsMutator);
    }
}

