/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedUI.video;

import controller_msgs.msg.dds.VideoPacket;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.effect.BlendMode;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;
import us.ihmc.messager.Messager;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.quadrupedUI.video.QuadrupedJavaFXROS2VideoView;

public class QuadrupedVideoViewOverlay {
    private final QuadrupedJavaFXROS2VideoView videoView;
    private SizeMode currentMode = SizeMode.MIN;
    private final DoubleProperty animationDurationProperty = new SimpleDoubleProperty((Object)this, "animationDuration", 0.15);

    public QuadrupedVideoViewOverlay(int width, int height, boolean flipX, boolean flipY) {
        this.videoView = new QuadrupedJavaFXROS2VideoView(width, height, flipX, flipY);
        this.videoView.setPreserveRatio(true);
        this.videoView.setFitWidth(this.currentMode.getWidth());
        this.videoView.setStyle("-fx-effect: dropshadow(three-pass-box, rgba(0,0,0,0.6), 5, 0, 0, 0);");
        this.videoView.setOpacity(0.5);
        this.videoView.setBlendMode(BlendMode.OVERLAY);
        this.videoView.addEventHandler(MouseEvent.MOUSE_ENTERED, e -> this.transitionBlending(1.0, null));
        this.videoView.addEventHandler(MouseEvent.MOUSE_EXITED, e -> this.transitionBlending(0.5, BlendMode.OVERLAY));
    }

    private void transitionBlending(double endOpacity, BlendMode endBlendMode) {
        Timeline timeline = new Timeline();
        timeline.setAutoReverse(false);
        timeline.setCycleCount(1);
        timeline.getKeyFrames().add((Object)new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.videoView.opacityProperty(), (Object)this.videoView.getOpacity())}));
        timeline.getKeyFrames().add((Object)new KeyFrame(Duration.seconds((double)this.animationDurationProperty.get()), new KeyValue[]{new KeyValue((WritableValue)this.videoView.opacityProperty(), (Object)endOpacity)}));
        timeline.setOnFinished(e2 -> this.videoView.setBlendMode(endBlendMode));
        timeline.play();
    }

    public void toggleMode() {
        SizeMode endMode;
        switch (this.currentMode) {
            case MIN: {
                endMode = SizeMode.MED;
                break;
            }
            case MED: {
                endMode = SizeMode.MAX;
                break;
            }
            case MAX: {
                endMode = SizeMode.MIN;
                break;
            }
            default: {
                throw new RuntimeException("Unhandle mode: " + (Object)((Object)this.currentMode));
            }
        }
        Timeline timeline = new Timeline();
        timeline.setAutoReverse(false);
        timeline.setCycleCount(1);
        timeline.getKeyFrames().add((Object)new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.videoView.fitWidthProperty(), (Object)this.videoView.getFitWidth())}));
        timeline.getKeyFrames().add((Object)new KeyFrame(Duration.seconds((double)this.animationDurationProperty.get()), new KeyValue[]{new KeyValue((WritableValue)this.videoView.fitWidthProperty(), (Object)endMode.getWidth())}));
        timeline.setOnFinished(event -> {
            this.currentMode = endMode;
        });
        timeline.play();
    }

    public void start(Messager messager, MessagerAPIFactory.Topic<VideoPacket> videoTopic) {
        this.videoView.start(messager, videoTopic);
    }

    public void stop() {
        this.videoView.stop();
    }

    public Node getNode() {
        return this.videoView;
    }

    private static enum SizeMode {
        MIN(200.0),
        MED(800.0),
        MAX(1600.0);

        private final double width;

        private SizeMode(double width) {
            this.width = width;
        }

        public double getWidth() {
            return this.width;
        }
    }
}

