/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedUI;

import controller_msgs.msg.dds.AbortWalkingMessage;
import controller_msgs.msg.dds.BodyPathPlanMessage;
import controller_msgs.msg.dds.FootstepPlannerStatusMessage;
import controller_msgs.msg.dds.HighLevelStateChangeStatusMessage;
import controller_msgs.msg.dds.HighLevelStateMessage;
import controller_msgs.msg.dds.PauseWalkingMessage;
import controller_msgs.msg.dds.PawStepPlannerParametersPacket;
import controller_msgs.msg.dds.PawStepPlanningRequestPacket;
import controller_msgs.msg.dds.PawStepPlanningToolboxOutputStatus;
import controller_msgs.msg.dds.PlanarRegionsListMessage;
import controller_msgs.msg.dds.QuadrupedBodyHeightMessage;
import controller_msgs.msg.dds.QuadrupedBodyTrajectoryMessage;
import controller_msgs.msg.dds.QuadrupedFootLoadBearingMessage;
import controller_msgs.msg.dds.QuadrupedFootstepStatusMessage;
import controller_msgs.msg.dds.QuadrupedRequestedSteppingStateMessage;
import controller_msgs.msg.dds.QuadrupedStepMessage;
import controller_msgs.msg.dds.QuadrupedSteppingStateChangeMessage;
import controller_msgs.msg.dds.QuadrupedTeleopDesiredVelocity;
import controller_msgs.msg.dds.QuadrupedTimedStepListMessage;
import controller_msgs.msg.dds.QuadrupedTimedStepMessage;
import controller_msgs.msg.dds.QuadrupedXGaitSettingsPacket;
import controller_msgs.msg.dds.REAStateRequestMessage;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.SoleTrajectoryMessage;
import controller_msgs.msg.dds.TimeIntervalMessage;
import controller_msgs.msg.dds.ToolboxStateMessage;
import controller_msgs.msg.dds.VideoPacket;
import controller_msgs.msg.dds.VisibilityGraphsParametersPacket;
import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.commons.PrintTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.IHMCRealtimeROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.communication.packets.PlanarRegionMessageConverter;
import us.ihmc.communication.packets.ToolboxState;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.idl.IDLSequence;
import us.ihmc.messager.Messager;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.VisibilityGraphsParametersReadOnly;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.quadrupedBasics.QuadrupedSteppingStateEnum;
import us.ihmc.quadrupedCommunication.QuadrupedMessageTools;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.PawStepPlan;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.PawStepPlannerStatus;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.PawStepPlannerTargetType;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.PawStepPlannerType;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.PawStepPlanningResult;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.communication.PawStepPlannerCommunicationProperties;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.parameters.PawStepPlannerParametersReadOnly;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.tools.PawStepPlannerMessageTools;
import us.ihmc.quadrupedPlanning.QuadrupedXGaitSettingsReadOnly;
import us.ihmc.quadrupedUI.QuadrupedUIMessagerAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.robotSide.QuadrantDependentList;
import us.ihmc.robotics.robotSide.RobotQuadrant;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;

public class QuadrupedUIMessageConverter {
    private static final boolean verbose = false;
    private final RealtimeROS2Node ros2Node;
    private final Messager messager;
    private final String robotName;
    private final AtomicReference<PawStepPlannerParametersReadOnly> footstepPlannerParametersReference;
    private final AtomicReference<VisibilityGraphsParametersReadOnly> visibilityGraphParametersReference;
    private final AtomicReference<QuadrupedXGaitSettingsReadOnly> xGaitSettingsReference;
    private final AtomicReference<Point3D> plannerStartPositionReference;
    private final AtomicReference<PawStepPlannerTargetType> plannerStartTargetTypeReference;
    private final AtomicReference<QuadrantDependentList<Point3D>> plannerStartFeetPositionsReference;
    private final AtomicReference<Quaternion> plannerStartOrientationReference;
    private final AtomicReference<Point3D> plannerGoalPositionReference;
    private final AtomicReference<Quaternion> plannerGoalOrientationReference;
    private final AtomicReference<PlanarRegionsList> plannerPlanarRegionReference;
    private final AtomicReference<PawStepPlannerType> plannerTypeReference;
    private final AtomicReference<Double> plannerTimeoutReference;
    private final AtomicReference<RobotQuadrant> plannerInitialSupportQuadrantReference;
    private final AtomicReference<Integer> plannerRequestIdReference;
    private final AtomicReference<Double> plannerHorizonLengthReference;
    private final AtomicReference<Boolean> acceptNewPlanarRegionsReference;
    private final AtomicReference<Integer> currentPlanRequestId;
    private final AtomicReference<Boolean> assumeFlatGround;
    private IHMCRealtimeROS2Publisher<HighLevelStateMessage> desiredHighLevelStatePublisher;
    private IHMCRealtimeROS2Publisher<QuadrupedBodyHeightMessage> bodyHeightPublisher;
    private IHMCRealtimeROS2Publisher<QuadrupedTeleopDesiredVelocity> desiredTeleopVelocityPublisher;
    private IHMCRealtimeROS2Publisher<QuadrupedBodyTrajectoryMessage> desiredBodyPosePublisher;
    private IHMCRealtimeROS2Publisher<ToolboxStateMessage> enableStepTeleopPublisher;
    private IHMCRealtimeROS2Publisher<ToolboxStateMessage> enableFootstepPlanningPublisher;
    private IHMCRealtimeROS2Publisher<QuadrupedXGaitSettingsPacket> stepTeleopXGaitSettingsPublisher;
    private IHMCRealtimeROS2Publisher<QuadrupedXGaitSettingsPacket> footstepPlanningXGaitSettingsPublisher;
    private IHMCRealtimeROS2Publisher<PawStepPlannerParametersPacket> footstepPlannerParametersPublisher;
    private IHMCRealtimeROS2Publisher<VisibilityGraphsParametersPacket> visibilityGraphsParametersPublisher;
    private IHMCRealtimeROS2Publisher<PawStepPlanningRequestPacket> pawPlanningRequestPublisher;
    private IHMCRealtimeROS2Publisher<QuadrupedTimedStepListMessage> stepListMessagePublisher;
    private IHMCRealtimeROS2Publisher<SoleTrajectoryMessage> soleTrajectoryMessagePublisher;
    private IHMCRealtimeROS2Publisher<QuadrupedRequestedSteppingStateMessage> desiredSteppingStatePublisher;
    private IHMCRealtimeROS2Publisher<PauseWalkingMessage> pauseWalkingPublisher;
    private IHMCRealtimeROS2Publisher<AbortWalkingMessage> abortWalkingPublisher;
    private IHMCRealtimeROS2Publisher<QuadrupedFootLoadBearingMessage> loadBearingRequestPublisher;
    private IHMCRealtimeROS2Publisher<REAStateRequestMessage> reaStateRequestPublisher;

    public QuadrupedUIMessageConverter(RealtimeROS2Node ros2Node, Messager messager, String robotName) {
        this.messager = messager;
        this.robotName = robotName;
        this.ros2Node = ros2Node;
        this.footstepPlannerParametersReference = messager.createInput(QuadrupedUIMessagerAPI.FootstepPlannerParametersTopic, null);
        this.visibilityGraphParametersReference = messager.createInput(QuadrupedUIMessagerAPI.VisibilityGraphsParametersTopic, null);
        this.xGaitSettingsReference = messager.createInput(QuadrupedUIMessagerAPI.XGaitSettingsTopic, null);
        this.plannerStartPositionReference = messager.createInput(QuadrupedUIMessagerAPI.StartPositionTopic);
        this.plannerStartTargetTypeReference = messager.createInput(QuadrupedUIMessagerAPI.StartTargetTypeTopic, (Object)PawStepPlannerTargetType.POSE_BETWEEN_FEET);
        this.plannerStartFeetPositionsReference = messager.createInput(QuadrupedUIMessagerAPI.StartFeetPositionTopic);
        this.plannerStartOrientationReference = messager.createInput(QuadrupedUIMessagerAPI.StartOrientationTopic, (Object)new Quaternion());
        this.plannerGoalPositionReference = messager.createInput(QuadrupedUIMessagerAPI.GoalPositionTopic);
        this.plannerGoalOrientationReference = messager.createInput(QuadrupedUIMessagerAPI.GoalOrientationTopic, (Object)new Quaternion());
        this.plannerPlanarRegionReference = messager.createInput(QuadrupedUIMessagerAPI.PlanarRegionDataTopic);
        this.plannerTypeReference = messager.createInput(QuadrupedUIMessagerAPI.PlannerTypeTopic, (Object)PawStepPlannerType.A_STAR);
        this.plannerTimeoutReference = messager.createInput(QuadrupedUIMessagerAPI.PlannerTimeoutTopic, (Object)5.0);
        this.plannerInitialSupportQuadrantReference = messager.createInput(QuadrupedUIMessagerAPI.InitialSupportQuadrantTopic, (Object)RobotQuadrant.FRONT_LEFT);
        this.plannerRequestIdReference = messager.createInput(QuadrupedUIMessagerAPI.PlannerRequestIdTopic);
        this.plannerHorizonLengthReference = messager.createInput(QuadrupedUIMessagerAPI.PlannerHorizonLengthTopic);
        this.acceptNewPlanarRegionsReference = messager.createInput(QuadrupedUIMessagerAPI.AcceptNewPlanarRegionsTopic, (Object)true);
        this.currentPlanRequestId = messager.createInput(QuadrupedUIMessagerAPI.PlannerRequestIdTopic, (Object)0);
        this.assumeFlatGround = messager.createInput(QuadrupedUIMessagerAPI.AssumeFlatGroundTopic, (Object)false);
        this.registerPubSubs();
        ros2Node.spin();
    }

    public void destroy() {
        this.ros2Node.destroy();
    }

    private void registerPubSubs() {
        ROS2Topic controllerOutputTopic = ROS2Tools.getQuadrupedControllerOutputTopic((String)this.robotName);
        ROS2Topic footstepPlannerOutputTopic = PawStepPlannerCommunicationProperties.outputTopic((String)this.robotName);
        ROS2Topic footstepPlannerInputTopicGenerator = PawStepPlannerCommunicationProperties.inputTopic((String)this.robotName);
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.ros2Node, RobotConfigurationData.class, (ROS2Topic)controllerOutputTopic, s -> this.processRobotConfigurationData((RobotConfigurationData)s.takeNextData()));
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.ros2Node, HighLevelStateChangeStatusMessage.class, (ROS2Topic)controllerOutputTopic, s -> this.processHighLevelStateChangeMessage((HighLevelStateChangeStatusMessage)s.takeNextData()));
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.ros2Node, QuadrupedSteppingStateChangeMessage.class, (ROS2Topic)controllerOutputTopic, s -> this.processSteppingStateStateChangeMessage((QuadrupedSteppingStateChangeMessage)s.takeNextData()));
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.ros2Node, QuadrupedFootstepStatusMessage.class, (ROS2Topic)controllerOutputTopic, s -> this.messager.submitMessage(QuadrupedUIMessagerAPI.FootstepStatusMessageTopic, s.takeNextData()));
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.ros2Node, PawStepPlanningRequestPacket.class, (ROS2Topic)footstepPlannerInputTopicGenerator, s -> this.processPawPlanningRequestPacket((PawStepPlanningRequestPacket)s.takeNextData()));
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.ros2Node, BodyPathPlanMessage.class, (ROS2Topic)footstepPlannerOutputTopic, s -> this.processBodyPathPlanMessage((BodyPathPlanMessage)s.takeNextData()));
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.ros2Node, FootstepPlannerStatusMessage.class, (ROS2Topic)footstepPlannerOutputTopic, s -> this.processFootstepPlannerStatus((FootstepPlannerStatusMessage)s.takeNextData()));
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.ros2Node, PawStepPlanningToolboxOutputStatus.class, (ROS2Topic)footstepPlannerOutputTopic, s -> this.processFootstepPlanningOutputStatus((PawStepPlanningToolboxOutputStatus)s.takeNextData()));
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.ros2Node, PlanarRegionsListMessage.class, (ROS2Topic)REACommunicationProperties.outputTopic, s -> this.processIncomingPlanarRegionMessage((PlanarRegionsListMessage)s.takeNextData()));
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.ros2Node, VideoPacket.class, (ROS2Topic)ROS2Tools.IHMC_ROOT, s -> this.messager.submitMessage(QuadrupedUIMessagerAPI.LeftCameraVideo, s.takeNextData()));
        ROS2Topic controllerInputTopic = ROS2Tools.getQuadrupedControllerInputTopic((String)this.robotName);
        ROS2Topic stepTeleopInputTopicGenerator = ROS2Tools.STEP_TELEOP_TOOLBOX.withRobot(this.robotName).withInput();
        this.desiredHighLevelStatePublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)this.ros2Node, HighLevelStateMessage.class, (ROS2Topic)controllerInputTopic);
        this.desiredSteppingStatePublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)this.ros2Node, QuadrupedRequestedSteppingStateMessage.class, (ROS2Topic)controllerInputTopic);
        this.soleTrajectoryMessagePublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)this.ros2Node, SoleTrajectoryMessage.class, (ROS2Topic)controllerInputTopic);
        this.pauseWalkingPublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)this.ros2Node, PauseWalkingMessage.class, (ROS2Topic)controllerInputTopic);
        this.abortWalkingPublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)this.ros2Node, AbortWalkingMessage.class, (ROS2Topic)controllerInputTopic);
        this.loadBearingRequestPublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)this.ros2Node, QuadrupedFootLoadBearingMessage.class, (ROS2Topic)controllerInputTopic);
        this.bodyHeightPublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)this.ros2Node, QuadrupedBodyHeightMessage.class, (ROS2Topic)controllerInputTopic);
        this.desiredBodyPosePublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)this.ros2Node, QuadrupedBodyTrajectoryMessage.class, (ROS2Topic)controllerInputTopic);
        this.enableStepTeleopPublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)this.ros2Node, ToolboxStateMessage.class, (ROS2Topic)stepTeleopInputTopicGenerator);
        this.enableFootstepPlanningPublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)this.ros2Node, ToolboxStateMessage.class, (ROS2Topic)footstepPlannerInputTopicGenerator);
        this.stepTeleopXGaitSettingsPublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)this.ros2Node, QuadrupedXGaitSettingsPacket.class, (ROS2Topic)stepTeleopInputTopicGenerator);
        this.footstepPlanningXGaitSettingsPublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)this.ros2Node, QuadrupedXGaitSettingsPacket.class, (ROS2Topic)footstepPlannerInputTopicGenerator);
        this.desiredTeleopVelocityPublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)this.ros2Node, QuadrupedTeleopDesiredVelocity.class, (ROS2Topic)stepTeleopInputTopicGenerator);
        this.footstepPlannerParametersPublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)this.ros2Node, PawStepPlannerParametersPacket.class, (ROS2Topic)footstepPlannerInputTopicGenerator);
        this.visibilityGraphsParametersPublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)this.ros2Node, VisibilityGraphsParametersPacket.class, (ROS2Topic)footstepPlannerInputTopicGenerator);
        this.pawPlanningRequestPublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)this.ros2Node, PawStepPlanningRequestPacket.class, (ROS2Topic)footstepPlannerInputTopicGenerator);
        this.stepListMessagePublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)this.ros2Node, QuadrupedTimedStepListMessage.class, (ROS2Topic)controllerInputTopic);
        this.reaStateRequestPublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)this.ros2Node, REAStateRequestMessage.class, (ROS2Topic)REACommunicationProperties.inputTopic);
        this.messager.registerTopicListener(QuadrupedUIMessagerAPI.DesiredControllerNameTopic, this::publishDesiredHighLevelControllerState);
        this.messager.registerTopicListener(QuadrupedUIMessagerAPI.DesiredSteppingStateNameTopic, this::publishDesiredQuadrupedSteppigState);
        this.messager.registerTopicListener(QuadrupedUIMessagerAPI.DesiredBodyHeightTopic, this::publishDesiredBodyHeight);
        this.messager.registerTopicListener(QuadrupedUIMessagerAPI.EnableStepTeleopTopic, this::publishEnableStepTeleop);
        this.messager.registerTopicListener(QuadrupedUIMessagerAPI.XGaitSettingsTopic, this::publishQuadrupedXGaitSettings);
        this.messager.registerTopicListener(QuadrupedUIMessagerAPI.ManualStepsListMessageTopic, this::publishStepListMessage);
        this.messager.registerTopicListener(QuadrupedUIMessagerAPI.SoleTrajectoryMessageTopic, this::publishSoleTrajectoryMessage);
        this.messager.registerTopicListener(QuadrupedUIMessagerAPI.FootstepPlannerTimedStepsTopic, this::publishStepListMessage);
        this.messager.registerTopicListener(QuadrupedUIMessagerAPI.ComputePathTopic, request -> this.requestNewPlan());
        this.messager.registerTopicListener(QuadrupedUIMessagerAPI.AbortPlanningTopic, request -> this.requestAbortPlanning());
        this.messager.registerTopicListener(QuadrupedUIMessagerAPI.DesiredTeleopVelocity, this::publishDesiredVelocity);
        this.messager.registerTopicListener(QuadrupedUIMessagerAPI.DesiredBodyTrajectoryTopic, arg_0 -> this.desiredBodyPosePublisher.publish(arg_0));
        this.messager.registerTopicListener(QuadrupedUIMessagerAPI.AbortWalkingTopic, m -> this.abortWalkingPublisher.publish((Object)new AbortWalkingMessage()));
        this.messager.registerTopicListener(QuadrupedUIMessagerAPI.PauseWalkingTopic, request -> {
            PauseWalkingMessage pauseWalkingMessage = new PauseWalkingMessage();
            pauseWalkingMessage.setPause(request.booleanValue());
            this.pauseWalkingPublisher.publish((Object)pauseWalkingMessage);
        });
        this.messager.registerTopicListener(QuadrupedUIMessagerAPI.LoadBearingRequestTopic, quadrant -> {
            QuadrupedFootLoadBearingMessage loadBearingMessage = new QuadrupedFootLoadBearingMessage();
            loadBearingMessage.setRobotQuadrant(quadrant.toByte());
            this.loadBearingRequestPublisher.publish((Object)loadBearingMessage);
        });
        this.messager.registerTopicListener(QuadrupedUIMessagerAPI.PlanarRegionDataClearTopic, m -> {
            REAStateRequestMessage clearRequest = new REAStateRequestMessage();
            clearRequest.setRequestClear(true);
            this.reaStateRequestPublisher.publish((Object)clearRequest);
        });
    }

    private void processRobotConfigurationData(RobotConfigurationData robotConfigurationData) {
        this.messager.submitMessage(QuadrupedUIMessagerAPI.RobotConfigurationDataTopic, (Object)robotConfigurationData);
    }

    private void processHighLevelStateChangeMessage(HighLevelStateChangeStatusMessage stateChangeStatusMessage) {
        HighLevelControllerName currentState = HighLevelControllerName.fromByte((byte)stateChangeStatusMessage.getEndHighLevelControllerName());
        this.messager.submitMessage(QuadrupedUIMessagerAPI.CurrentControllerNameTopic, (Object)currentState);
    }

    private void processSteppingStateStateChangeMessage(QuadrupedSteppingStateChangeMessage stateChangeStatusMessage) {
        QuadrupedSteppingStateEnum currentState = QuadrupedSteppingStateEnum.fromByte((byte)stateChangeStatusMessage.getEndQuadrupedSteppingStateEnum());
        this.messager.submitMessage(QuadrupedUIMessagerAPI.CurrentSteppingStateNameTopic, (Object)currentState);
    }

    private void processPawPlanningRequestPacket(PawStepPlanningRequestPacket packet) {
        Point3D goalPosition = packet.getGoalPositionInWorld();
        Quaternion goalOrientation = packet.getGoalOrientationInWorld();
        Point3D startPosition = packet.getBodyPositionInWorld();
        Quaternion startOrientation = packet.getBodyOrientationInWorld();
        PawStepPlannerType plannerType = PawStepPlannerType.fromByte((byte)packet.getRequestedPawPlannerType());
        RobotQuadrant initialSupportSide = RobotQuadrant.fromByte((byte)packet.getInitialStepRobotQuadrant());
        int plannerRequestId = packet.getPlannerRequestId();
        double timeout = packet.getTimeout();
        double horizonLength = packet.getHorizonLength();
        this.messager.submitMessage(QuadrupedUIMessagerAPI.StartPositionTopic, (Object)startPosition);
        this.messager.submitMessage(QuadrupedUIMessagerAPI.GoalPositionTopic, (Object)goalPosition);
        this.messager.submitMessage(QuadrupedUIMessagerAPI.StartOrientationTopic, (Object)startOrientation);
        this.messager.submitMessage(QuadrupedUIMessagerAPI.GoalOrientationTopic, (Object)goalOrientation);
        this.messager.submitMessage(QuadrupedUIMessagerAPI.PlannerTypeTopic, (Object)plannerType);
        this.messager.submitMessage(QuadrupedUIMessagerAPI.PlannerTimeoutTopic, (Object)timeout);
        this.messager.submitMessage(QuadrupedUIMessagerAPI.InitialSupportQuadrantTopic, (Object)initialSupportSide);
        this.messager.submitMessage(QuadrupedUIMessagerAPI.PlannerRequestIdTopic, (Object)plannerRequestId);
        this.messager.submitMessage(QuadrupedUIMessagerAPI.PlannerHorizonLengthTopic, (Object)horizonLength);
    }

    private void processBodyPathPlanMessage(BodyPathPlanMessage packet) {
        PlanarRegionsListMessage planarRegionsListMessage = packet.getPlanarRegionsList();
        PlanarRegionsList planarRegionsList = PlanarRegionMessageConverter.convertToPlanarRegionsList((PlanarRegionsListMessage)planarRegionsListMessage);
        PawStepPlanningResult result = PawStepPlanningResult.fromByte((byte)packet.getFootstepPlanningResult());
        IDLSequence.Object bodyPath = packet.getBodyPath();
        this.messager.submitMessage(QuadrupedUIMessagerAPI.PlanarRegionDataTopic, (Object)planarRegionsList);
        this.messager.submitMessage(QuadrupedUIMessagerAPI.PlanningResultTopic, (Object)result);
        this.messager.submitMessage(QuadrupedUIMessagerAPI.BodyPathDataTopic, (Object)bodyPath);
    }

    private void processFootstepPlannerStatus(FootstepPlannerStatusMessage packet) {
        this.messager.submitMessage(QuadrupedUIMessagerAPI.PlannerStatusTopic, (Object)PawStepPlannerStatus.fromByte((byte)packet.getFootstepPlannerStatus()));
    }

    private void processFootstepPlanningOutputStatus(PawStepPlanningToolboxOutputStatus packet) {
        QuadrupedTimedStepListMessage footstepDataListMessage = packet.getFootstepDataList();
        int plannerRequestId = packet.getPlanId();
        PawStepPlanningResult result = PawStepPlanningResult.fromByte((byte)packet.getFootstepPlanningResult());
        PawStepPlan pawStepPlan = QuadrupedUIMessageConverter.convertToFootstepPlan(footstepDataListMessage);
        IDLSequence.Object bodyPath = packet.getBodyPath();
        Pose3D lowLevelGoal = packet.getLowLevelPlannerGoal();
        if (plannerRequestId > this.currentPlanRequestId.get()) {
            this.messager.submitMessage(QuadrupedUIMessagerAPI.PlannerRequestIdTopic, (Object)plannerRequestId);
        }
        ThreadTools.sleep((long)100L);
        this.messager.submitMessage(QuadrupedUIMessagerAPI.FootstepPlanTopic, (Object)pawStepPlan);
        this.messager.submitMessage(QuadrupedUIMessagerAPI.ReceivedPlanIdTopic, (Object)plannerRequestId);
        this.messager.submitMessage(QuadrupedUIMessagerAPI.PlanningResultTopic, (Object)result);
        this.messager.submitMessage(QuadrupedUIMessagerAPI.PlannerTimeTakenTopic, (Object)packet.getTimeTaken());
        this.messager.submitMessage(QuadrupedUIMessagerAPI.BodyPathDataTopic, (Object)bodyPath);
        if (lowLevelGoal != null) {
            this.messager.submitMessage(QuadrupedUIMessagerAPI.LowLevelGoalPositionTopic, (Object)lowLevelGoal.getPosition());
            this.messager.submitMessage(QuadrupedUIMessagerAPI.LowLevelGoalOrientationTopic, (Object)lowLevelGoal.getOrientation());
        }
    }

    private void processIncomingPlanarRegionMessage(PlanarRegionsListMessage packet) {
        if (this.acceptNewPlanarRegionsReference.get().booleanValue()) {
            this.messager.submitMessage(QuadrupedUIMessagerAPI.PlanarRegionDataTopic, (Object)PlanarRegionMessageConverter.convertToPlanarRegionsList((PlanarRegionsListMessage)packet));
        }
    }

    private void publishDesiredHighLevelControllerState(HighLevelControllerName controllerName) {
        this.desiredHighLevelStatePublisher.publish((Object)HumanoidMessageTools.createHighLevelStateMessage((HighLevelControllerName)controllerName));
    }

    private void publishDesiredQuadrupedSteppigState(QuadrupedSteppingStateEnum steppingStateName) {
        QuadrupedRequestedSteppingStateMessage message = new QuadrupedRequestedSteppingStateMessage();
        message.setQuadrupedSteppingRequestedEvent(steppingStateName.toByte());
        this.desiredSteppingStatePublisher.publish((Object)message);
    }

    private void publishSoleTrajectoryMessage(SoleTrajectoryMessage soleTrajectoryMessage) {
        this.soleTrajectoryMessagePublisher.publish((Object)soleTrajectoryMessage);
    }

    public void publishDesiredBodyHeight(double desiredBodyHeight) {
        QuadrupedBodyHeightMessage bodyHeightMessage = QuadrupedMessageTools.createQuadrupedBodyHeightMessage((double)0.0, (double)desiredBodyHeight);
        bodyHeightMessage.setControlBodyHeight(true);
        bodyHeightMessage.setIsExpressedInAbsoluteTime(false);
        this.bodyHeightPublisher.publish((Object)bodyHeightMessage);
    }

    public void publishDesiredVelocity(QuadrupedTeleopDesiredVelocity desiredVelocity) {
        this.desiredTeleopVelocityPublisher.publish((Object)desiredVelocity);
    }

    public void publishEnableStepTeleop(boolean enable) {
        if (enable) {
            this.enableStepTeleopPublisher.publish((Object)MessageTools.createToolboxStateMessage((ToolboxState)ToolboxState.WAKE_UP));
        } else {
            this.enableStepTeleopPublisher.publish((Object)MessageTools.createToolboxStateMessage((ToolboxState)ToolboxState.SLEEP));
        }
    }

    public void publishQuadrupedXGaitSettings(QuadrupedXGaitSettingsReadOnly xGaitSettings) {
        QuadrupedXGaitSettingsPacket packet = xGaitSettings.getAsPacket();
        this.stepTeleopXGaitSettingsPublisher.publish((Object)packet);
        this.footstepPlanningXGaitSettingsPublisher.publish((Object)packet);
    }

    public void publishStepListMessage(QuadrupedTimedStepListMessage stepListMessage) {
        this.stepListMessagePublisher.publish((Object)stepListMessage);
    }

    private void requestNewPlan() {
        if (!this.checkRequireds()) {
            return;
        }
        this.enableFootstepPlanningPublisher.publish((Object)MessageTools.createToolboxStateMessage((ToolboxState)ToolboxState.WAKE_UP));
        this.footstepPlannerParametersPublisher.publish((Object)this.footstepPlannerParametersReference.get().getAsPacket());
        this.footstepPlanningXGaitSettingsPublisher.publish((Object)this.xGaitSettingsReference.get().getAsPacket());
        VisibilityGraphsParametersPacket visibilityGraphsParametersPacket = new VisibilityGraphsParametersPacket();
        VisibilityGraphsParametersReadOnly visibilityGraphsParameters = this.visibilityGraphParametersReference.get();
        PawStepPlannerMessageTools.copyParametersToPacket((VisibilityGraphsParametersPacket)visibilityGraphsParametersPacket, (VisibilityGraphsParametersReadOnly)visibilityGraphsParameters);
        this.visibilityGraphsParametersPublisher.publish((Object)visibilityGraphsParametersPacket);
        this.submitFootstepPlanningRequestPacket();
    }

    private boolean checkRequireds() {
        if (this.plannerStartPositionReference.get() == null && this.plannerStartTargetTypeReference.get() == PawStepPlannerTargetType.POSE_BETWEEN_FEET) {
            PrintTools.warn((String)"Need to set start position.");
            return false;
        }
        if (this.plannerStartFeetPositionsReference.get() == null && this.plannerStartTargetTypeReference.get() == PawStepPlannerTargetType.FOOTSTEPS) {
            PrintTools.warn((String)"Need to set start position.");
            return false;
        }
        if (this.plannerGoalPositionReference.get() == null) {
            PrintTools.warn((String)"Need to set goal position.");
            return false;
        }
        return true;
    }

    private void submitFootstepPlanningRequestPacket() {
        PawStepPlanningRequestPacket packet = new PawStepPlanningRequestPacket();
        if (this.plannerStartTargetTypeReference.get() == PawStepPlannerTargetType.POSE_BETWEEN_FEET) {
            packet.getBodyPositionInWorld().set(this.plannerStartPositionReference.get());
            packet.getBodyOrientationInWorld().set(this.plannerStartOrientationReference.get());
        } else {
            packet.getFrontLeftPositionInWorld().set((Point3D)this.plannerStartFeetPositionsReference.get().get((Enum)RobotQuadrant.FRONT_LEFT));
            packet.getFrontRightPositionInWorld().set((Point3D)this.plannerStartFeetPositionsReference.get().get((Enum)RobotQuadrant.FRONT_RIGHT));
            packet.getHindLeftPositionInWorld().set((Point3D)this.plannerStartFeetPositionsReference.get().get((Enum)RobotQuadrant.HIND_LEFT));
            packet.getHindRightPositionInWorld().set((Point3D)this.plannerStartFeetPositionsReference.get().get((Enum)RobotQuadrant.HIND_RIGHT));
        }
        packet.setStartTargetType(this.plannerStartTargetTypeReference.get().toByte());
        packet.getGoalPositionInWorld().set(this.plannerGoalPositionReference.get());
        packet.getGoalOrientationInWorld().set(this.plannerGoalOrientationReference.get());
        if (this.plannerInitialSupportQuadrantReference.get() != null) {
            packet.setInitialStepRobotQuadrant(this.plannerInitialSupportQuadrantReference.get().toByte());
        }
        if (this.plannerTimeoutReference.get() != null) {
            packet.setTimeout(this.plannerTimeoutReference.get().doubleValue());
        }
        if (this.plannerTypeReference.get() != null) {
            packet.setRequestedPawPlannerType(this.plannerTypeReference.get().toByte());
        }
        if (this.plannerRequestIdReference.get() != null) {
            packet.setPlannerRequestId(this.plannerRequestIdReference.get().intValue());
        }
        if (this.plannerHorizonLengthReference.get() != null) {
            packet.setHorizonLength(this.plannerHorizonLengthReference.get().doubleValue());
        }
        if (this.plannerPlanarRegionReference.get() != null) {
            packet.getPlanarRegionsListMessage().set(PlanarRegionMessageConverter.convertToPlanarRegionsListMessage((PlanarRegionsList)this.plannerPlanarRegionReference.get()));
        }
        packet.setAssumeFlatGround(this.assumeFlatGround.get().booleanValue());
        this.pawPlanningRequestPublisher.publish((Object)packet);
    }

    private void requestAbortPlanning() {
        this.enableFootstepPlanningPublisher.publish((Object)MessageTools.createToolboxStateMessage((ToolboxState)ToolboxState.SLEEP));
    }

    private static PawStepPlan convertToFootstepPlan(QuadrupedTimedStepListMessage footstepDataListMessage) {
        PawStepPlan pawStepPlan = new PawStepPlan();
        for (QuadrupedTimedStepMessage timedStepMessage : footstepDataListMessage.getQuadrupedStepList()) {
            QuadrupedStepMessage stepMessage = timedStepMessage.getQuadrupedStepMessage();
            TimeIntervalMessage timeInterval = timedStepMessage.getTimeInterval();
            FramePoint3D stepPosition = new FramePoint3D();
            stepPosition.set((Tuple3DReadOnly)stepMessage.getGoalPosition());
            pawStepPlan.addPawStep(RobotQuadrant.fromByte((byte)stepMessage.getRobotQuadrant()), stepPosition, stepMessage.getGroundClearance(), timeInterval.getStartTime(), timeInterval.getEndTime());
        }
        return pawStepPlan;
    }

    public static QuadrupedUIMessageConverter createConverter(Messager messager, String robotName, DomainFactory.PubSubImplementation implementation) {
        RealtimeROS2Node ros2Node = ROS2Tools.createRealtimeROS2Node((DomainFactory.PubSubImplementation)implementation, (String)"ihmc_quadruped_ui");
        return QuadrupedUIMessageConverter.createConverter(ros2Node, messager, robotName);
    }

    public static QuadrupedUIMessageConverter createConverter(RealtimeROS2Node ros2Node, Messager messager, String robotName) {
        return new QuadrupedUIMessageConverter(ros2Node, messager, robotName);
    }
}

