/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedPlanning.footstepChooser;

import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.quadrupedPlanning.footstepChooser.PlanarRegionBasedPointFootSnapper;
import us.ihmc.quadrupedPlanning.footstepChooser.PointFootSnapperParameters;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.geometry.PlanarRegionsListGenerator;

public class PlanarRegionBasedPointFootSnapperTest {
    private static final double epsilon = 1.0E-6;

    @Test
    public void testSnappingToFlatSquare() {
        PointFootSnapperParameters testParameters = new PointFootSnapperParameters(){

            public double distanceInsidePlanarRegion() {
                return 0.1;
            }

            public double maximumNormalAngleFromVertical() {
                return 1.0;
            }
        };
        PlanarRegionsListGenerator planarRegionsListGenerator = new PlanarRegionsListGenerator();
        planarRegionsListGenerator.translate(1.0, 2.0, -0.5);
        planarRegionsListGenerator.addRectangle(1.0, 1.0);
        PlanarRegionsList planarRegionsList = planarRegionsListGenerator.getPlanarRegionsList();
        PlanarRegionBasedPointFootSnapper snapper = new PlanarRegionBasedPointFootSnapper(testParameters);
        snapper.setPlanarRegionsList(planarRegionsList);
        Point3DReadOnly snappedStep = snapper.snapStep(1.0, 2.0);
        Assert.assertTrue((boolean)snappedStep.epsilonEquals((EuclidGeometry)new Point3D(1.0, 2.0, -0.5), 1.0E-6));
        snappedStep = snapper.snapStep(1.1, 1.9);
        Assert.assertTrue((boolean)snappedStep.epsilonEquals((EuclidGeometry)new Point3D(1.1, 1.9, -0.5), 1.0E-6));
        snappedStep = snapper.snapStep(-0.1, 0.1);
        Assert.assertTrue((boolean)snappedStep.epsilonEquals((EuclidGeometry)new Point3D(0.6, 1.6, -0.5), 1.0E-6));
        snappedStep = snapper.snapStep(1.45, 2.25);
        Assert.assertTrue((boolean)snappedStep.epsilonEquals((EuclidGeometry)new Point3D(1.4, 2.25, -0.5), 1.0E-6));
    }

    @Test
    public void testSnappingToRotatedSquare() {
        PointFootSnapperParameters testParameters = new PointFootSnapperParameters(){

            public double distanceInsidePlanarRegion() {
                return 0.1;
            }

            public double maximumNormalAngleFromVertical() {
                return Math.PI;
            }
        };
        PlanarRegionsListGenerator planarRegionsListGenerator = new PlanarRegionsListGenerator();
        planarRegionsListGenerator.translate(-1.0, -1.0, 0.5);
        planarRegionsListGenerator.rotate(0.7853981633974483, Axis3D.X);
        planarRegionsListGenerator.addRectangle(2.0, 2.0);
        PlanarRegionsList planarRegionsList = planarRegionsListGenerator.getPlanarRegionsList();
        PlanarRegionBasedPointFootSnapper snapper = new PlanarRegionBasedPointFootSnapper(testParameters);
        snapper.setPlanarRegionsList(planarRegionsList);
        Point3DReadOnly snappedStep = snapper.snapStep(-1.0, -1.0);
        Assert.assertTrue((boolean)snappedStep.epsilonEquals((EuclidGeometry)new Point3D(-1.0, -1.0, 0.5), 1.0E-6));
        snappedStep = snapper.snapStep(-1.1, -1.1);
        Assert.assertTrue((boolean)snappedStep.epsilonEquals((EuclidGeometry)new Point3D(-1.1, -1.1, 0.4), 1.0E-6));
        snappedStep = snapper.snapStep(0.1, 0.1);
        Assert.assertTrue((boolean)snappedStep.epsilonEquals((EuclidGeometry)new Point3D(-0.1, -1.0 + 0.9 * Math.cos(0.7853981633974483), 0.5 + 0.9 * Math.sin(0.7853981633974483)), 1.0E-6));
        snappedStep = snapper.snapStep(-1.95, -1.3);
        Assert.assertTrue((boolean)snappedStep.epsilonEquals((EuclidGeometry)new Point3D(-1.9, -1.3, 0.5 - 0.3 * Math.tan(0.7853981633974483)), 1.0E-6));
    }
}

