/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedPlanning.stepStream;

import java.util.ArrayList;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.lists.PreallocatedList;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.quadrupedBasics.gait.QuadrupedTimedOrientedStep;
import us.ihmc.quadrupedBasics.gait.QuadrupedTimedStep;
import us.ihmc.quadrupedPlanning.QuadrupedSpeed;
import us.ihmc.quadrupedPlanning.QuadrupedXGaitSettings;
import us.ihmc.quadrupedPlanning.QuadrupedXGaitSettingsReadOnly;
import us.ihmc.quadrupedPlanning.stepStream.QuadrupedPlanarFootstepPlan;
import us.ihmc.quadrupedPlanning.stepStream.QuadrupedXGaitPlanner;
import us.ihmc.quadrupedPlanning.stepStream.bodyPath.QuadrupedPlanarBodyPathProvider;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.robotSide.RobotEnd;
import us.ihmc.robotics.robotSide.RobotQuadrant;
import us.ihmc.robotics.time.TimeIntervalReadOnly;

public class QuadrupedXGaitPlannerTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testInitialForwardVelocityPlan() {
        ForwardMotionBodyPathProvider bodyPathProvider = new ForwardMotionBodyPathProvider();
        QuadrupedXGaitSettings xGaitSettings = new QuadrupedXGaitSettings();
        xGaitSettings.setStanceLength(1.0);
        xGaitSettings.setStanceWidth(0.25);
        xGaitSettings.setStepGroundClearance(0.1);
        xGaitSettings.setQuadrupedSpeed(QuadrupedSpeed.FAST);
        xGaitSettings.getAmbleFastTimings().setStepDuration(0.25);
        xGaitSettings.getAmbleFastTimings().setEndDoubleSupportDuration(0.0);
        xGaitSettings.setEndPhaseShift(90.0);
        QuadrupedXGaitPlanner xGaitPlanner = new QuadrupedXGaitPlanner((QuadrupedPlanarBodyPathProvider)bodyPathProvider, (QuadrupedXGaitSettingsReadOnly)xGaitSettings);
        xGaitPlanner.setStepSnapper((x, y, minZ) -> new Point3D(x, y, 0.0));
        RobotQuadrant initialStepQuadrant = RobotQuadrant.HIND_RIGHT;
        FramePoint3D supportCentroidAtSoS = new FramePoint3D(ReferenceFrame.getWorldFrame());
        supportCentroidAtSoS.set(0.0, 0.0, 0.0);
        double timeAtSoS = 0.0;
        QuadrupedPlanarFootstepPlan footstepPlan = new QuadrupedPlanarFootstepPlan(4);
        bodyPathProvider.initialPose.setToZero(ReferenceFrame.getWorldFrame());
        bodyPathProvider.desiredForwardMotion = 1.0;
        xGaitPlanner.computeInitialPlan(footstepPlan, initialStepQuadrant, timeAtSoS);
        ArrayList<QuadrupedTimedOrientedStep> nominalSteps = new ArrayList<QuadrupedTimedOrientedStep>();
        for (int i = 0; i < 4; ++i) {
            nominalSteps.add(new QuadrupedTimedOrientedStep());
        }
        ((QuadrupedTimedOrientedStep)nominalSteps.get(0)).setRobotQuadrant(RobotQuadrant.HIND_RIGHT);
        ((QuadrupedTimedOrientedStep)nominalSteps.get(0)).setGroundClearance(xGaitSettings.getStepGroundClearance());
        ((QuadrupedTimedOrientedStep)nominalSteps.get(0)).setGoalPosition((Point3DReadOnly)new Point3D(-0.25, -0.125, 0.0));
        ((QuadrupedTimedOrientedStep)nominalSteps.get(0)).getTimeInterval().setInterval(0.0, 0.25);
        ((QuadrupedTimedOrientedStep)nominalSteps.get(0)).setStepYaw(0.0);
        ((QuadrupedTimedOrientedStep)nominalSteps.get(1)).setRobotQuadrant(RobotQuadrant.FRONT_RIGHT);
        ((QuadrupedTimedOrientedStep)nominalSteps.get(1)).setGroundClearance(xGaitSettings.getStepGroundClearance());
        ((QuadrupedTimedOrientedStep)nominalSteps.get(1)).setGoalPosition((Point3DReadOnly)new Point3D(0.875, -0.125, 0.0));
        ((QuadrupedTimedOrientedStep)nominalSteps.get(1)).getTimeInterval().setInterval(0.125, 0.375);
        ((QuadrupedTimedOrientedStep)nominalSteps.get(1)).setStepYaw(0.0);
        ((QuadrupedTimedOrientedStep)nominalSteps.get(2)).setRobotQuadrant(RobotQuadrant.HIND_LEFT);
        ((QuadrupedTimedOrientedStep)nominalSteps.get(2)).setGroundClearance(xGaitSettings.getStepGroundClearance());
        ((QuadrupedTimedOrientedStep)nominalSteps.get(2)).setGoalPosition((Point3DReadOnly)new Point3D(0.0, 0.125, 0.0));
        ((QuadrupedTimedOrientedStep)nominalSteps.get(2)).getTimeInterval().setInterval(0.25, 0.5);
        ((QuadrupedTimedOrientedStep)nominalSteps.get(2)).setStepYaw(0.0);
        ((QuadrupedTimedOrientedStep)nominalSteps.get(3)).setRobotQuadrant(RobotQuadrant.FRONT_LEFT);
        ((QuadrupedTimedOrientedStep)nominalSteps.get(3)).setGroundClearance(xGaitSettings.getStepGroundClearance());
        ((QuadrupedTimedOrientedStep)nominalSteps.get(3)).setGoalPosition((Point3DReadOnly)new Point3D(1.125, 0.125, 0.0));
        ((QuadrupedTimedOrientedStep)nominalSteps.get(3)).getTimeInterval().setInterval(0.375, 0.625);
        ((QuadrupedTimedOrientedStep)nominalSteps.get(3)).setStepYaw(0.0);
        double epsilon = 1.0E-5;
        PreallocatedList plannedSteps = footstepPlan.getPlannedSteps();
        for (int i = 0; i < 4; ++i) {
            Assert.assertTrue((String)("planned step " + i + " does not match nominal step"), (boolean)((QuadrupedTimedOrientedStep)plannedSteps.get(i)).epsilonEquals((QuadrupedTimedOrientedStep)nominalSteps.get(i), epsilon));
            QuadrupedXGaitPlannerTest.assertStepsEqual("planned step " + i + " does not match nominal step", (QuadrupedTimedStep)nominalSteps.get(i), (QuadrupedTimedStep)plannedSteps.get(i), epsilon);
        }
    }

    @Test
    public void testOnlineForwardVelocityPlan() {
        ForwardMotionBodyPathProvider bodyPathProvider = new ForwardMotionBodyPathProvider();
        QuadrupedXGaitSettings xGaitSettings = new QuadrupedXGaitSettings();
        xGaitSettings.setStanceLength(1.0);
        xGaitSettings.setStanceWidth(0.25);
        xGaitSettings.setStepGroundClearance(0.1);
        xGaitSettings.setQuadrupedSpeed(QuadrupedSpeed.FAST);
        xGaitSettings.getAmbleFastTimings().setStepDuration(0.25);
        xGaitSettings.getAmbleFastTimings().setEndDoubleSupportDuration(0.0);
        xGaitSettings.setEndPhaseShift(90.0);
        QuadrupedXGaitPlanner xGaitPlanner = new QuadrupedXGaitPlanner((QuadrupedPlanarBodyPathProvider)bodyPathProvider, (QuadrupedXGaitSettingsReadOnly)xGaitSettings);
        xGaitPlanner.setStepSnapper((x, y, minZ) -> new Point3D(x, y, 0.0));
        double currentTime = 0.125;
        double currentYaw = 0.0;
        double currentHeight = 0.0;
        QuadrupedPlanarFootstepPlan footstepPlan = new QuadrupedPlanarFootstepPlan(4);
        QuadrupedTimedOrientedStep currentHindStep = new QuadrupedTimedOrientedStep();
        currentHindStep.setRobotQuadrant(RobotQuadrant.HIND_RIGHT);
        currentHindStep.setGroundClearance(xGaitSettings.getStepGroundClearance());
        currentHindStep.setGoalPosition((Point3DReadOnly)new Point3D(-0.25, -0.125, 0.0));
        currentHindStep.getTimeInterval().setInterval(0.0, 0.25);
        currentHindStep.setStepYaw(0.0);
        currentHindStep.setGroundClearance(currentHeight);
        footstepPlan.getCurrentSteps().set(RobotEnd.HIND, (Object)currentHindStep);
        QuadrupedTimedOrientedStep currentFrontStep = new QuadrupedTimedOrientedStep();
        currentFrontStep.setRobotQuadrant(RobotQuadrant.FRONT_RIGHT);
        currentFrontStep.setGroundClearance(xGaitSettings.getStepGroundClearance());
        currentFrontStep.setGoalPosition((Point3DReadOnly)new Point3D(0.875, -0.125, 0.0));
        currentFrontStep.getTimeInterval().setInterval(0.125, 0.375);
        currentFrontStep.setStepYaw(0.0);
        currentHindStep.setGroundClearance(currentHeight);
        footstepPlan.getCurrentSteps().set(RobotEnd.FRONT, (Object)currentFrontStep);
        bodyPathProvider.initialPose.setToZero(ReferenceFrame.getWorldFrame());
        bodyPathProvider.desiredForwardMotion = 1.0;
        xGaitPlanner.computeOnlinePlan(footstepPlan, currentTime);
        ArrayList<QuadrupedTimedStep> nominalSteps = new ArrayList<QuadrupedTimedStep>();
        for (int i = 0; i < 2; ++i) {
            nominalSteps.add(new QuadrupedTimedStep());
        }
        ((QuadrupedTimedStep)nominalSteps.get(0)).setRobotQuadrant(RobotQuadrant.HIND_LEFT);
        ((QuadrupedTimedStep)nominalSteps.get(0)).setGroundClearance(xGaitSettings.getStepGroundClearance());
        ((QuadrupedTimedStep)nominalSteps.get(0)).setGoalPosition((Point3DReadOnly)new Point3D(0.0, 0.125, 0.0));
        ((QuadrupedTimedStep)nominalSteps.get(0)).getTimeInterval().setInterval(0.25, 0.5);
        ((QuadrupedTimedStep)nominalSteps.get(1)).setRobotQuadrant(RobotQuadrant.FRONT_LEFT);
        ((QuadrupedTimedStep)nominalSteps.get(1)).setGroundClearance(xGaitSettings.getStepGroundClearance());
        ((QuadrupedTimedStep)nominalSteps.get(1)).setGoalPosition((Point3DReadOnly)new Point3D(1.125, 0.125, 0.0));
        ((QuadrupedTimedStep)nominalSteps.get(1)).getTimeInterval().setInterval(0.375, 0.625);
        double epsilon = 1.0E-5;
        PreallocatedList plannedSteps = footstepPlan.getPlannedSteps();
        for (int i = 0; i < 2; ++i) {
            Assert.assertTrue((String)("planned step " + i + " does not match nominal step"), (boolean)((QuadrupedTimedOrientedStep)plannedSteps.get(i)).epsilonEquals((QuadrupedTimedStep)nominalSteps.get(i), epsilon));
            QuadrupedXGaitPlannerTest.assertStepsEqual("planned step " + i + " does not match nominal step", (QuadrupedTimedStep)nominalSteps.get(i), (QuadrupedTimedStep)plannedSteps.get(i), epsilon);
        }
    }

    private static void assertStepsEqual(String message, QuadrupedTimedStep desiredStep, QuadrupedTimedStep actualStep, double epsilon) {
        Assert.assertTrue((String)message, (desiredStep.getRobotQuadrant() == actualStep.getRobotQuadrant() ? 1 : 0) != 0);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((String)message, (Point3DReadOnly)desiredStep.getGoalPosition(), (Point3DReadOnly)actualStep.getGoalPosition(), (double)epsilon);
        Assert.assertEquals((String)message, (double)desiredStep.getGroundClearance(), (double)actualStep.getGroundClearance(), (double)epsilon);
        Assert.assertTrue((String)message, (desiredStep.getTrajectoryType() == actualStep.getTrajectoryType() ? 1 : 0) != 0);
        Assert.assertTrue((String)message, (boolean)desiredStep.getTimeInterval().epsilonEquals((TimeIntervalReadOnly)actualStep.getTimeInterval(), epsilon));
    }

    private class ForwardMotionBodyPathProvider
    implements QuadrupedPlanarBodyPathProvider {
        double desiredForwardMotion;
        FramePose2D initialPose = new FramePose2D();

        private ForwardMotionBodyPathProvider() {
        }

        public void initialize() {
        }

        public void getPlanarPose(double time, FramePose2D poseToPack) {
            double xDisplacement = this.desiredForwardMotion * time;
            poseToPack.setX(this.initialPose.getX() + xDisplacement);
        }
    }
}

