/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedFootstepPlanning.pawPlanning.turnWalkTurn;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.turnWalkTurn.QuadrupedTurnWalkTurnPathPlanner;
import us.ihmc.robotics.Assert;

public class TurnWalkTurnPawPathPlannerTest {
    private static final double epsilon = 1.0E-10;
    private static final int iters = 1000;

    @Test
    public void testComputeTimeToAccelerateToAchieveValueWithNoMaxRate() {
        double delta = 0.25;
        double maxAcceleration = 1.0;
        double time = QuadrupedTurnWalkTurnPathPlanner.computeTimeToAccelerateToAchieveValueWithNoMaxRate((double)0.0, (double)0.0, (double)delta, (double)0.0, (double)maxAcceleration);
        double timeExpected = Math.sqrt(delta / maxAcceleration);
        Assert.assertEquals((double)timeExpected, (double)time, (double)1.0E-10);
        time = QuadrupedTurnWalkTurnPathPlanner.computeTimeToAccelerateToAchieveValueWithNoMaxRate((double)0.0, (double)0.0, (double)(-delta), (double)0.0, (double)maxAcceleration);
        Assert.assertEquals((double)timeExpected, (double)time, (double)1.0E-10);
    }

    @Test
    public void testLargestQuadraticSolution() {
        Random random = new Random(1738L);
        for (int i = 0; i < 1000; ++i) {
            double a1 = RandomNumbers.nextDouble((Random)random, (double)100.0);
            double a2 = RandomNumbers.nextDouble((Random)random, (double)100.0);
            double b1 = RandomNumbers.nextDouble((Random)random, (double)100.0);
            double b2 = RandomNumbers.nextDouble((Random)random, (double)100.0);
            double a = a1 * a2;
            double b = a1 * b2 + a2 * b1;
            double c = b1 * b2;
            double expectedValue = Math.max(TurnWalkTurnPawPathPlannerTest.positiveQuadraticSolution(a, b, c), TurnWalkTurnPawPathPlannerTest.negativeQuadraticSolution(a, b, c));
            Assert.assertEquals((double)expectedValue, (double)QuadrupedTurnWalkTurnPathPlanner.largestQuadraticSolution((double)a, (double)b, (double)c), (double)1.0E-10);
        }
    }

    private static double positiveQuadraticSolution(double a, double b, double c) {
        double radical = Math.sqrt(MathTools.square((double)b) - 4.0 * a * c);
        return (-b + radical) / (2.0 * a);
    }

    private static double negativeQuadraticSolution(double a, double b, double c) {
        double radical = Math.sqrt(MathTools.square((double)b) - 4.0 * a * c);
        return (-b - radical) / (2.0 * a);
    }
}

