/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.tools;

import java.util.Random;
import org.junit.jupiter.api.Test;
import toolbox_msgs.msg.dds.VisibilityGraphsParametersPacket;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.DefaultVisibilityGraphParameters;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.VisibilityGraphParametersKeys;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.VisibilityGraphsParametersReadOnly;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.tools.PawStepPlannerMessageTools;
import us.ihmc.robotics.Assert;
import us.ihmc.tools.property.BooleanStoredPropertyKey;
import us.ihmc.tools.property.DoubleStoredPropertyKey;
import us.ihmc.tools.property.IntegerStoredPropertyKey;
import us.ihmc.tools.property.StoredPropertyKey;

public class PawStepPlannerMessageToolsTest {
    @Test
    public void testPacketCopying() {
        DefaultVisibilityGraphParameters parametersToSet = new DefaultVisibilityGraphParameters();
        VisibilityGraphsParametersPacket packet = new VisibilityGraphsParametersPacket();
        Random random = new Random(1738L);
        for (int i = 0; i < 1000; ++i) {
            VisibilityGraphsParametersReadOnly randomParameters = PawStepPlannerMessageToolsTest.createRandomParameters(random);
            PawStepPlannerMessageTools.copyParametersToPacket((VisibilityGraphsParametersPacket)packet, (VisibilityGraphsParametersReadOnly)randomParameters);
            parametersToSet.set(packet);
            PawStepPlannerMessageToolsTest.assertParametersEqual(randomParameters, (VisibilityGraphsParametersReadOnly)parametersToSet, 1.0E-5);
        }
    }

    private static VisibilityGraphsParametersReadOnly createRandomParameters(Random random) {
        DefaultVisibilityGraphParameters parameters = new DefaultVisibilityGraphParameters();
        for (StoredPropertyKey key : VisibilityGraphParametersKeys.keys.keys()) {
            if (key instanceof DoubleStoredPropertyKey) {
                DoubleStoredPropertyKey doubleKey = (DoubleStoredPropertyKey)key;
                parameters.set(doubleKey, RandomNumbers.nextDouble((Random)random, (double)10.0));
                continue;
            }
            if (key instanceof IntegerStoredPropertyKey) {
                IntegerStoredPropertyKey integerKey = (IntegerStoredPropertyKey)key;
                parameters.set(integerKey, RandomNumbers.nextInt((Random)random, (int)1, (int)10));
                continue;
            }
            if (!(key instanceof BooleanStoredPropertyKey)) continue;
            BooleanStoredPropertyKey booleanKey = (BooleanStoredPropertyKey)key;
            parameters.set(booleanKey, RandomNumbers.nextBoolean((Random)random, (double)0.5));
        }
        return parameters;
    }

    private static void assertParametersEqual(VisibilityGraphsParametersReadOnly parametersA, VisibilityGraphsParametersReadOnly parametersB, double epsilon) {
        for (StoredPropertyKey key : VisibilityGraphParametersKeys.keys.keys()) {
            String message = "Key " + key.getCamelCasedName() + " was not copied correctly.";
            if (key instanceof DoubleStoredPropertyKey) {
                DoubleStoredPropertyKey doubleKey = (DoubleStoredPropertyKey)key;
                Assert.assertEquals((String)message, (double)parametersA.get(doubleKey), (double)parametersB.get(doubleKey), (double)epsilon);
                continue;
            }
            if (key instanceof IntegerStoredPropertyKey) {
                IntegerStoredPropertyKey integerKey = (IntegerStoredPropertyKey)key;
                Assert.assertEquals((String)message, (long)parametersA.get(integerKey), (long)parametersB.get(integerKey));
                continue;
            }
            if (!(key instanceof BooleanStoredPropertyKey)) continue;
            BooleanStoredPropertyKey booleanKey = (BooleanStoredPropertyKey)key;
            Assert.assertEquals((String)message, (Object)parametersA.get(booleanKey), (Object)parametersB.get(booleanKey));
        }
    }
}

