/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.stepCost;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.PrintTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.humanoidRobotics.footstep.FootstepUtils;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.graph.PawNode;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.parameters.DefaultPawStepPlannerParameters;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.parameters.PawStepPlannerParametersReadOnly;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.stepCost.PawXGaitCost;
import us.ihmc.quadrupedPlanning.QuadrupedGait;
import us.ihmc.quadrupedPlanning.QuadrupedSpeed;
import us.ihmc.quadrupedPlanning.QuadrupedXGaitSettings;
import us.ihmc.quadrupedPlanning.QuadrupedXGaitSettingsReadOnly;
import us.ihmc.quadrupedPlanning.stepStream.QuadrupedXGaitTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.robotSide.QuadrantDependentList;
import us.ihmc.robotics.robotSide.RobotQuadrant;
import us.ihmc.robotics.robotSide.SegmentDependentList;

public class PawXGaitCostTest {
    private static final double stepDuration = 0.5;
    private static final double doubleSupportDuration = 0.2;
    private static final double maxSpeed = 0.3;
    private static final double planningSpeedFraction = 0.8;
    private static final double stanceLength = 1.0;
    private static final double stanceWidth = 0.5;
    private static final double epsilon = 1.0E-5;

    @Test
    public void testForwardWithFrontEndCost() {
        QuadrupedXGaitSettings xGaitSettings = new QuadrupedXGaitSettings();
        xGaitSettings.setEndPhaseShift(QuadrupedGait.TROT.getEndPhaseShift());
        xGaitSettings.setQuadrupedSpeed(QuadrupedSpeed.MEDIUM);
        xGaitSettings.getTrotMediumTimings().setStepDuration(0.5);
        xGaitSettings.getTrotMediumTimings().setEndDoubleSupportDuration(0.2);
        xGaitSettings.getTrotMediumTimings().setMaxSpeed(0.3);
        xGaitSettings.setStanceLength(1.0);
        xGaitSettings.setStanceWidth(0.5);
        TestParameters pawPlannerParameters = new TestParameters();
        PawXGaitCost xGaitCost = new PawXGaitCost((PawStepPlannerParametersReadOnly)pawPlannerParameters, (QuadrupedXGaitSettingsReadOnly)xGaitSettings);
        PoseReferenceFrame yawedFrame = new PoseReferenceFrame("yawedFrame", ReferenceFrame.getWorldFrame());
        double yaw = Math.toRadians(45.0);
        yawedFrame.setOrientationAndUpdate((Orientation3DReadOnly)new Quaternion(yaw, 0.0, 0.0));
        yawedFrame.setPositionAndUpdate((FramePoint3DReadOnly)new FramePoint3D(FootstepUtils.worldFrame, 0.74, -2.7, 0.93));
        FramePoint2D hindLeft = new FramePoint2D((ReferenceFrame)yawedFrame, -0.5, 0.25);
        FramePoint2D hindRight = new FramePoint2D((ReferenceFrame)yawedFrame, -0.5, -0.25);
        FramePoint2D frontLeft = new FramePoint2D((ReferenceFrame)yawedFrame, 0.5, 0.25);
        FramePoint2D frontRight = new FramePoint2D((ReferenceFrame)yawedFrame, 0.5, -0.25);
        double forwardVelocity = 0.24;
        double forwardDisplacement = forwardVelocity * 0.7;
        FramePoint2D nextFrontLeft = new FramePoint2D((ReferenceFrame)yawedFrame, 0.5 + forwardDisplacement, 0.25);
        hindLeft.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        hindRight.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        frontLeft.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        frontRight.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        nextFrontLeft.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        RobotQuadrant steppingQuadrant = RobotQuadrant.FRONT_LEFT;
        PawNode startNode = new PawNode(steppingQuadrant.getNextReversedRegularGaitSwingQuadrant(), (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, yaw, 1.0, 0.5);
        PawNode endNode = new PawNode(steppingQuadrant, (Tuple2DReadOnly)nextFrontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, yaw, 1.0, 0.5);
        Assert.assertEquals((double)0.0, (double)xGaitCost.compute(startNode, endNode), (double)0.05);
        FramePoint2D nextFrontRight = new FramePoint2D((ReferenceFrame)yawedFrame, 0.5 + forwardDisplacement, -0.25);
        nextFrontRight.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        steppingQuadrant = RobotQuadrant.FRONT_RIGHT;
        startNode = new PawNode(steppingQuadrant.getNextReversedRegularGaitSwingQuadrant(), (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, yaw, 1.0, 0.5);
        endNode = new PawNode(steppingQuadrant, (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)nextFrontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, yaw, 1.0, 0.5);
        Assert.assertEquals((double)0.0, (double)xGaitCost.compute(startNode, endNode), (double)0.05);
    }

    @Test
    public void testForwardTrotting() {
        PawNode.gridSizeXY = 0.001;
        PawNode.gridSizeYaw = 0.001;
        QuadrupedXGaitSettings xGaitSettings = new QuadrupedXGaitSettings();
        xGaitSettings.setEndPhaseShift(QuadrupedGait.TROT.getEndPhaseShift());
        xGaitSettings.setQuadrupedSpeed(QuadrupedSpeed.MEDIUM);
        xGaitSettings.getTrotMediumTimings().setStepDuration(0.5);
        xGaitSettings.getTrotMediumTimings().setEndDoubleSupportDuration(0.2);
        xGaitSettings.getTrotMediumTimings().setMaxSpeed(0.3);
        xGaitSettings.setStanceLength(1.0);
        xGaitSettings.setStanceWidth(0.5);
        Random random = new Random(1738L);
        TestParameters pawPlannerParameters = new TestParameters();
        PawXGaitCost xGaitCost = new PawXGaitCost((PawStepPlannerParametersReadOnly)pawPlannerParameters, (QuadrupedXGaitSettingsReadOnly)xGaitSettings);
        PoseReferenceFrame yawedFrame = new PoseReferenceFrame("yawedFrame", ReferenceFrame.getWorldFrame());
        double yaw = Math.toRadians(45.0);
        yawedFrame.setOrientationAndUpdate((Orientation3DReadOnly)new Quaternion(yaw, 0.0, 0.0));
        yawedFrame.setPositionAndUpdate((FramePoint3DReadOnly)new FramePoint3D(FootstepUtils.worldFrame, 0.74, -2.7, 0.93));
        double forwardVelocity = 0.24;
        double initialForwardDisplacement = forwardVelocity * 0.7;
        RobotQuadrant lastQuadrantStepping = RobotQuadrant.HIND_RIGHT;
        FramePoint2D hindLeft = new FramePoint2D((ReferenceFrame)yawedFrame, -0.5, 0.25);
        FramePoint2D hindRight = new FramePoint2D((ReferenceFrame)yawedFrame, -0.5 + initialForwardDisplacement, -0.25);
        FramePoint2D frontLeft = new FramePoint2D((ReferenceFrame)yawedFrame, 0.5 + initialForwardDisplacement, 0.25);
        FramePoint2D frontRight = new FramePoint2D((ReferenceFrame)yawedFrame, 0.5, -0.25);
        QuadrantDependentList footPositions = new QuadrantDependentList((Object)frontLeft, (Object)frontRight, (Object)hindLeft, (Object)hindRight);
        for (RobotQuadrant robotQuadrant : RobotQuadrant.values) {
            ((FramePoint2D)footPositions.get((Enum)robotQuadrant)).changeFrameAndProjectToXYPlane(FootstepUtils.worldFrame);
        }
        PawNode startNode = new PawNode(lastQuadrantStepping, footPositions, yaw, 1.0, 0.5);
        int stepsToTest = 20;
        for (int stepNumber = 0; stepNumber < stepsToTest; ++stepNumber) {
            RobotQuadrant movingQuadrant = lastQuadrantStepping.getNextRegularGaitSwingQuadrant();
            double nominalForwardDisplacement = movingQuadrant.isQuadrantInFront() ? forwardVelocity * 0.7 : 0.0;
            FramePoint2D endXGait = new FramePoint2D(FootstepUtils.worldFrame, (Tuple2DReadOnly)startNode.getOrComputeXGaitCenterPoint());
            endXGait.changeFrameAndProjectToXYPlane((ReferenceFrame)yawedFrame);
            endXGait.addX(nominalForwardDisplacement);
            FramePoint2D endFoot = new FramePoint2D((FrameTuple2DReadOnly)endXGait);
            endFoot.addX(movingQuadrant.getEnd().negateIfHindEnd(0.5));
            endFoot.addY(movingQuadrant.getSide().negateIfRightSide(0.25));
            endFoot.changeFrameAndProjectToXYPlane(FootstepUtils.worldFrame);
            FramePoint2D snappedXGait = new FramePoint2D(FootstepUtils.worldFrame, PawNode.gridSizeXY * (double)PawNode.snapToGrid((double)endFoot.getX()), PawNode.gridSizeXY * (double)PawNode.snapToGrid((double)endFoot.getY()));
            snappedXGait.changeFrameAndProjectToXYPlane((ReferenceFrame)yawedFrame);
            snappedXGait.subX(movingQuadrant.getEnd().negateIfHindEnd(0.5));
            snappedXGait.subY(movingQuadrant.getSide().negateIfRightSide(0.25));
            snappedXGait.changeFrameAndProjectToXYPlane(FootstepUtils.worldFrame);
            ((FramePoint2D)footPositions.get((Enum)movingQuadrant)).set(endFoot);
            PawNode endNode = new PawNode(movingQuadrant, footPositions, yaw, 1.0, 0.5);
            double epsilon = 0.02;
            double cost = xGaitCost.compute(startNode, endNode);
            Assert.assertEquals((String)("step number " + stepNumber + " was wrong cost"), (double)0.0, (double)cost, (double)epsilon);
            endXGait.changeFrameAndProjectToXYPlane(FootstepUtils.worldFrame);
            Point2D otherSnappedFoot = new Point2D((double)PawNode.snapToGrid((double)endFoot.getX()), (double)PawNode.snapToGrid((double)endFoot.getY()));
            otherSnappedFoot.scale(PawNode.gridSizeXY);
            int iteration = 0;
            while (iteration < 100) {
                FramePoint2D otherEndFoot = new FramePoint2D((FrameTuple2DReadOnly)endFoot);
                Vector2D offset = EuclidCoreRandomTools.nextVector2D((Random)random, (double)-0.2, (double)0.2);
                otherEndFoot.add((Tuple2DReadOnly)offset);
                QuadrantDependentList otherFootPositions = new QuadrantDependentList((SegmentDependentList)footPositions);
                ((FramePoint2D)otherFootPositions.get((Enum)movingQuadrant)).set(otherEndFoot);
                Point2D snappedFoot = new Point2D((double)PawNode.snapToGrid((double)otherEndFoot.getX()), (double)PawNode.snapToGrid((double)otherEndFoot.getY()));
                snappedFoot.scale(PawNode.gridSizeXY);
                if (snappedFoot.distance((Point2DReadOnly)otherSnappedFoot) < 0.01) continue;
                PawNode otherEndNode = new PawNode(movingQuadrant, otherFootPositions, yaw, 1.0, 0.5);
                if (stepNumber == 1 && iteration == 2) {
                    PrintTools.info((String)"pause)");
                }
                double otherCost = xGaitCost.compute(startNode, otherEndNode);
                Assert.assertTrue((String)("cost of step " + stepNumber + " on iteration " + iteration + " is not the best. Offset was " + offset + ",\noriginal point was " + endFoot + " and new point was " + otherEndFoot + ". Original cost was " + cost + " while modified cost was " + otherCost), (cost < otherCost + epsilon ? 1 : 0) != 0);
                ++iteration;
            }
            startNode = endNode;
            lastQuadrantStepping = movingQuadrant;
        }
    }

    @Test
    public void testForwardWithHindEndCost() {
        QuadrupedXGaitSettings xGaitSettings = new QuadrupedXGaitSettings();
        xGaitSettings.setEndPhaseShift(QuadrupedGait.TROT.getEndPhaseShift());
        xGaitSettings.setQuadrupedSpeed(QuadrupedSpeed.MEDIUM);
        xGaitSettings.getTrotMediumTimings().setStepDuration(0.5);
        xGaitSettings.getTrotMediumTimings().setEndDoubleSupportDuration(0.2);
        xGaitSettings.getTrotMediumTimings().setMaxSpeed(0.3);
        xGaitSettings.setStanceLength(1.0);
        xGaitSettings.setStanceWidth(0.5);
        TestParameters pawPlannerParameters = new TestParameters();
        PawXGaitCost xGaitCost = new PawXGaitCost((PawStepPlannerParametersReadOnly)pawPlannerParameters, (QuadrupedXGaitSettingsReadOnly)xGaitSettings);
        PoseReferenceFrame yawedFrame = new PoseReferenceFrame("yawedFrame", ReferenceFrame.getWorldFrame());
        double yaw = Math.toRadians(45.0);
        yawedFrame.setOrientationAndUpdate((Orientation3DReadOnly)new Quaternion(yaw, 0.0, 0.0));
        FramePoint2D hindLeft = new FramePoint2D((ReferenceFrame)yawedFrame, -0.5, 0.25);
        FramePoint2D hindRight = new FramePoint2D((ReferenceFrame)yawedFrame, -0.5, -0.25);
        FramePoint2D frontLeft = new FramePoint2D((ReferenceFrame)yawedFrame, 0.75, 0.25);
        FramePoint2D frontRight = new FramePoint2D((ReferenceFrame)yawedFrame, 0.5, -0.25);
        FramePoint2D nextHindRight = new FramePoint2D((ReferenceFrame)yawedFrame, -0.25, -0.25);
        hindLeft.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        hindRight.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        frontLeft.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        frontRight.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        nextHindRight.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        RobotQuadrant steppingQuadrant = RobotQuadrant.HIND_RIGHT;
        PawNode startNode = new PawNode(steppingQuadrant.getNextReversedRegularGaitSwingQuadrant(), (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, yaw, 1.0, 0.5);
        PawNode endNode = new PawNode(steppingQuadrant, (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)nextHindRight, yaw, 1.0, 0.5);
        Assert.assertEquals((double)0.0, (double)xGaitCost.compute(startNode, endNode), (double)0.05);
        frontLeft = new FramePoint2D((ReferenceFrame)yawedFrame, 0.5, 0.25);
        frontRight = new FramePoint2D((ReferenceFrame)yawedFrame, 0.75, -0.25);
        FramePoint2D nextHindLeft = new FramePoint2D((ReferenceFrame)yawedFrame, -0.25, 0.25);
        frontLeft.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        frontRight.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        nextHindLeft.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        steppingQuadrant = RobotQuadrant.HIND_LEFT;
        startNode = new PawNode(steppingQuadrant.getNextReversedRegularGaitSwingQuadrant(), (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, yaw, 1.0, 0.5);
        endNode = new PawNode(steppingQuadrant, (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)nextHindLeft, (Tuple2DReadOnly)hindRight, yaw, 1.0, 0.5);
        Assert.assertEquals((double)0.0, (double)xGaitCost.compute(startNode, endNode), (double)0.05);
    }

    @Test
    public void testBackwardCost() {
        QuadrupedXGaitSettings xGaitSettings = new QuadrupedXGaitSettings();
        xGaitSettings.setEndPhaseShift(QuadrupedGait.TROT.getEndPhaseShift());
        xGaitSettings.setQuadrupedSpeed(QuadrupedSpeed.MEDIUM);
        xGaitSettings.getTrotMediumTimings().setStepDuration(0.5);
        xGaitSettings.getTrotMediumTimings().setEndDoubleSupportDuration(0.2);
        xGaitSettings.getTrotMediumTimings().setMaxSpeed(0.3);
        xGaitSettings.setStanceLength(1.0);
        xGaitSettings.setStanceWidth(0.5);
        TestParameters pawPlannerParameters = new TestParameters();
        PawXGaitCost xGaitCost = new PawXGaitCost((PawStepPlannerParametersReadOnly)pawPlannerParameters, (QuadrupedXGaitSettingsReadOnly)xGaitSettings);
        PoseReferenceFrame yawedFrame = new PoseReferenceFrame("yawedFrame", ReferenceFrame.getWorldFrame());
        double yaw = Math.toRadians(45.0);
        yawedFrame.setOrientationAndUpdate((Orientation3DReadOnly)new Quaternion(yaw, 0.0, 0.0));
        FramePoint2D hindLeft = new FramePoint2D((ReferenceFrame)yawedFrame, -0.5, 0.25);
        FramePoint2D hindRight = new FramePoint2D((ReferenceFrame)yawedFrame, -0.5, -0.25);
        FramePoint2D frontLeft = new FramePoint2D((ReferenceFrame)yawedFrame, 0.5, 0.25);
        FramePoint2D frontRight = new FramePoint2D((ReferenceFrame)yawedFrame, 0.5, -0.25);
        FramePoint2D hindLeftGoal = new FramePoint2D((ReferenceFrame)yawedFrame, -3.5, 0.25);
        FramePoint2D hindRightGoal = new FramePoint2D((ReferenceFrame)yawedFrame, -3.5, -0.25);
        FramePoint2D frontLeftGoal = new FramePoint2D((ReferenceFrame)yawedFrame, -2.5, 0.25);
        FramePoint2D frontRightGoal = new FramePoint2D((ReferenceFrame)yawedFrame, -2.5, -0.25);
        RobotQuadrant startQuadrant = RobotQuadrant.FRONT_LEFT.getNextReversedRegularGaitSwingQuadrant();
        double forwardVelocity = xGaitSettings.getMaxSpeed() * pawPlannerParameters.getMaxWalkingSpeedMultiplier();
        double durationBetweenSteps = QuadrupedXGaitTools.computeTimeDeltaBetweenSteps((RobotQuadrant)startQuadrant, (QuadrupedXGaitSettingsReadOnly)xGaitSettings);
        double forwardDisplacement = durationBetweenSteps * forwardVelocity;
        FramePoint2D nextFrontLeft = new FramePoint2D((ReferenceFrame)yawedFrame, 0.5 - forwardDisplacement, 0.25);
        hindLeft.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        hindRight.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        frontLeft.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        frontRight.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        hindLeftGoal.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        hindRightGoal.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        frontLeftGoal.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        frontRightGoal.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        nextFrontLeft.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        PawNode startNode = new PawNode(startQuadrant, (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, yaw, 1.0, 0.5);
        PawNode endNode = new PawNode(RobotQuadrant.FRONT_LEFT, (Tuple2DReadOnly)nextFrontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, yaw, 1.0, 0.5);
        Assert.assertEquals((double)0.0, (double)xGaitCost.compute(startNode, endNode), (double)0.05);
    }

    private class TestParameters
    extends DefaultPawStepPlannerParameters {
        private TestParameters() {
        }

        public double getXGaitWeight() {
            return 1.0;
        }

        public double getMaxWalkingSpeedMultiplier() {
            return 0.8;
        }
    }
}

