/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.pawSnapping;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.fest.assertions.Fail;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.pawSnapping.PlanarRegionsListPointSnapper;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.geometry.PlanarRegionsListGenerator;
import us.ihmc.simulationConstructionSetTools.util.planarRegions.PlanarRegionsListExamples;

public class PlanarRegionsListPointSnapperTest {
    private static final double epsilon = 1.0E-7;

    @Test
    public void testSimpleVerticalSnap() {
        Point2D pointToSnap = new Point2D();
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        generator.addCubeReferencedAtBottomMiddle(1.0, 0.5, 0.7);
        PlanarRegionsList planarRegionsList = generator.getPlanarRegionsList();
        PlanarRegion planarRegion = new PlanarRegion();
        RigidBodyTransform snapTransform = PlanarRegionsListPointSnapper.snapPointToPlanarRegionsList((Point2DReadOnly)pointToSnap, (List)planarRegionsList.getPlanarRegionsAsList(), (PlanarRegion)planarRegion);
        RigidBodyTransform expectedTransform = new RigidBodyTransform();
        expectedTransform.getTranslation().set(0.0, 0.0, 0.7);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTransform, (EuclidGeometry)snapTransform, (double)1.0E-7);
    }

    @Test
    public void testSimpleVerticalAndRotatedSnap() {
        Point2D pointToSnap = new Point2D();
        RigidBodyTransform planarRegionTransform = new RigidBodyTransform();
        planarRegionTransform.setRotationEulerAndZeroTranslation(0.1, 0.2, 0.3);
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        generator.setTransform(planarRegionTransform);
        generator.addCubeReferencedAtBottomMiddle(1.0, 0.5, 0.7);
        PlanarRegionsList planarRegionsList = generator.getPlanarRegionsList();
        PlanarRegion planarRegion = new PlanarRegion();
        RigidBodyTransform snapTransform = PlanarRegionsListPointSnapper.snapPointToPlanarRegionsList((Point2DReadOnly)pointToSnap, (List)planarRegionsList.getPlanarRegionsAsList(), (PlanarRegion)planarRegion);
        PlanarRegionsListPointSnapperTest.assertSurfaceNormalsMatchAndSnapPreservesXFromAbove(snapTransform, planarRegionTransform);
    }

    @Test
    public void testMovingAcrossStaircase() {
        PlanarRegionsList planarRegionsList = PlanarRegionsListExamples.generateStairCase();
        ArrayList<double[]> xyYawToTest = new ArrayList<double[]>();
        for (double xTranslation = 0.0; xTranslation < 3.0; xTranslation += 0.1) {
            xyYawToTest.add(new double[]{xTranslation, 0.0, 0.0});
        }
        PlanarRegionsListPointSnapperTest.doATest(planarRegionsList, xyYawToTest);
    }

    @Disabled
    @Test
    public void testRandomPlanarRegions() {
        Random random = new Random(1776L);
        int numberOfRandomObjects = 100;
        double maxX = 2.0;
        double maxY = 1.0;
        double maxZ = 0.5;
        PlanarRegionsList planarRegionsList = PlanarRegionsListExamples.generateRandomObjects((Random)random, (int)numberOfRandomObjects, (double)maxX, (double)maxY, (double)maxZ);
        ArrayList<double[]> xyYawToTest = new ArrayList<double[]>();
        for (double x = -maxX; x < maxX; x += 0.1) {
            for (double y = -maxY; y < maxY; y += 0.1) {
                double yaw = RandomNumbers.nextDouble((Random)random, (double)Math.PI);
                xyYawToTest.add(new double[]{x, y, yaw});
            }
        }
        PlanarRegionsListPointSnapperTest.doATest(planarRegionsList, xyYawToTest);
    }

    @Test
    public void testBumpyGround() {
        Random random = new Random(1776L);
        double maxX = 2.0;
        double maxY = 1.0;
        double maxZ = 0.2;
        PlanarRegionsList planarRegionsList = PlanarRegionsListExamples.generateBumpyGround((Random)random, (double)maxX, (double)maxY, (double)maxZ);
        ArrayList<double[]> xyYawToTest = new ArrayList<double[]>();
        for (double x = -maxX; x < maxX; x += 0.1) {
            for (double y = -maxY; y < maxY; y += 0.1) {
                double yaw = RandomNumbers.nextDouble((Random)random, (double)Math.PI);
                xyYawToTest.add(new double[]{x, y, yaw});
            }
        }
        PlanarRegionsListPointSnapperTest.doATest(planarRegionsList, xyYawToTest);
    }

    @Test
    public void testSnapPolygonToFlatPlanarRegion() {
        Point2D pointToSnap = new Point2D();
        ArrayList<ConvexPolygon2D> planarRegionConvexPolygons = new ArrayList<ConvexPolygon2D>();
        ConvexPolygon2D planarRegionPolygon = new ConvexPolygon2D();
        planarRegionPolygon.addVertex(10.0, 10.0);
        planarRegionPolygon.addVertex(-10.0, 10.0);
        planarRegionPolygon.addVertex(-10.0, -10.0);
        planarRegionPolygon.addVertex(10.0, -10.0);
        planarRegionPolygon.update();
        planarRegionConvexPolygons.add(planarRegionPolygon);
        RigidBodyTransform planarRegionTransformToWorld = new RigidBodyTransform();
        PlanarRegion planarRegionToSnapTo = new PlanarRegion((RigidBodyTransformReadOnly)planarRegionTransformToWorld, planarRegionConvexPolygons);
        ArrayList<PlanarRegion> planarRegionList = new ArrayList<PlanarRegion>();
        planarRegionList.add(planarRegionToSnapTo);
        PlanarRegion planarRegion = new PlanarRegion();
        RigidBodyTransform polygonSnappingTransform = PlanarRegionsListPointSnapper.snapPointToPlanarRegionsList((Point2DReadOnly)pointToSnap, planarRegionList, (PlanarRegion)planarRegion);
        RigidBodyTransform identityTransform = new RigidBodyTransform();
        EuclidCoreTestTools.assertEquals((EuclidGeometry)identityTransform, (EuclidGeometry)polygonSnappingTransform, (double)1.0E-7);
        planarRegionTransformToWorld = new RigidBodyTransform();
        planarRegionTransformToWorld.getTranslation().set(1.2, 3.4, 7.6);
        planarRegionToSnapTo = new PlanarRegion((RigidBodyTransformReadOnly)planarRegionTransformToWorld, planarRegionConvexPolygons);
        planarRegionList.clear();
        planarRegionList.add(planarRegionToSnapTo);
        polygonSnappingTransform = PlanarRegionsListPointSnapper.snapPointToPlanarRegionsList((Point2DReadOnly)pointToSnap, planarRegionList, (PlanarRegion)planarRegion);
        RigidBodyTransform expectedTransform = new RigidBodyTransform();
        expectedTransform.getTranslation().set(0.0, 0.0, 7.6);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTransform, (EuclidGeometry)polygonSnappingTransform, (double)1.0E-7);
    }

    @Test
    public void testSnapPolygonToLargeRotatedRegion() {
        Point2D pointToSnap = new Point2D();
        ArrayList<ConvexPolygon2D> planarRegionConvexPolygons = new ArrayList<ConvexPolygon2D>();
        ConvexPolygon2D planarRegionPolygon = new ConvexPolygon2D();
        planarRegionPolygon.addVertex(10.0, 10.0);
        planarRegionPolygon.addVertex(-10.0, 10.0);
        planarRegionPolygon.addVertex(-10.0, -10.0);
        planarRegionPolygon.addVertex(10.0, -10.0);
        planarRegionPolygon.update();
        planarRegionConvexPolygons.add(planarRegionPolygon);
        RigidBodyTransform planarRegionTransformToWorld = new RigidBodyTransform();
        planarRegionTransformToWorld.getTranslation().set(1.2, 3.4, 7.6);
        double roll = 0.0;
        double pitch = 1.0471975511965976;
        double yaw = 0.0;
        planarRegionTransformToWorld.setRotationEulerAndZeroTranslation(roll, pitch, yaw);
        ArrayList<PlanarRegion> planarRegionList = new ArrayList<PlanarRegion>();
        PlanarRegion planarRegionToSnapTo = new PlanarRegion((RigidBodyTransformReadOnly)planarRegionTransformToWorld, planarRegionConvexPolygons);
        planarRegionList.add(planarRegionToSnapTo);
        PlanarRegion planarRegion = new PlanarRegion();
        RigidBodyTransform polygonSnappingTransform = PlanarRegionsListPointSnapper.snapPointToPlanarRegionsList((Point2DReadOnly)pointToSnap, planarRegionList, (PlanarRegion)planarRegion);
        Point3D highVertexOne = new Point3D(0.0, 0.0, 0.0);
        polygonSnappingTransform.transform((Point3DBasics)highVertexOne);
        Assert.assertEquals((double)0.0, (double)highVertexOne.getX(), (double)1.0E-7);
        Assert.assertEquals((double)0.0, (double)highVertexOne.getY(), (double)1.0E-7);
        Assert.assertEquals((double)planarRegionToSnapTo.getPlaneZGivenXY(0.0, 0.0), (double)highVertexOne.getZ(), (double)1.0E-7);
        PlanarRegionsListPointSnapperTest.assertSurfaceNormalsMatchAndSnapPreservesXFromAbove(polygonSnappingTransform, planarRegionTransformToWorld);
    }

    @Test
    public void testYawOfRegionDoesNotYawSnappedPolygon() {
        Point2D pointToSnap = new Point2D();
        ArrayList<ConvexPolygon2D> planarRegionConvexPolygons = new ArrayList<ConvexPolygon2D>();
        ConvexPolygon2D planarRegionPolygon = new ConvexPolygon2D();
        planarRegionPolygon.addVertex(10.0, 10.0);
        planarRegionPolygon.addVertex(-10.0, 10.0);
        planarRegionPolygon.addVertex(-10.0, -10.0);
        planarRegionPolygon.addVertex(10.0, -10.0);
        planarRegionPolygon.update();
        planarRegionConvexPolygons.add(planarRegionPolygon);
        RigidBodyTransform planarRegionTransformToWorld = new RigidBodyTransform();
        planarRegionTransformToWorld.getTranslation().set(1.2, 3.4, 7.6);
        double roll = 0.0;
        double pitch = 1.0471975511965976;
        double yaw = 0.2;
        planarRegionTransformToWorld.setRotationEulerAndZeroTranslation(roll, pitch, yaw);
        ArrayList<PlanarRegion> planarRegionList = new ArrayList<PlanarRegion>();
        PlanarRegion planarRegionToSnapTo = new PlanarRegion((RigidBodyTransformReadOnly)planarRegionTransformToWorld, planarRegionConvexPolygons);
        planarRegionList.add(planarRegionToSnapTo);
        PlanarRegion planarRegion = new PlanarRegion();
        RigidBodyTransform polygonSnappingTransform = PlanarRegionsListPointSnapper.snapPointToPlanarRegionsList((Point2DReadOnly)pointToSnap, planarRegionList, (PlanarRegion)planarRegion);
        Point3D highVertexOne = new Point3D(0.0, 0.0, 0.0);
        polygonSnappingTransform.transform((Point3DBasics)highVertexOne);
        Assert.assertEquals((double)0.0, (double)highVertexOne.getX(), (double)1.0E-7);
        Assert.assertEquals((double)0.0, (double)highVertexOne.getY(), (double)1.0E-7);
        Assert.assertEquals((double)planarRegionToSnapTo.getPlaneZGivenXY(0.0, 0.0), (double)highVertexOne.getZ(), (double)1.0E-7);
        PlanarRegionsListPointSnapperTest.assertSurfaceNormalsMatchAndSnapPreservesXFromAbove(polygonSnappingTransform, planarRegionTransformToWorld);
    }

    public static void assertSurfaceNormalsMatchAndSnapPreservesXFromAbove(RigidBodyTransform snapTransform, RigidBodyTransform planarRegionTransform) {
        Vector3D expectedSurfaceNormal = new Vector3D(0.0, 0.0, 1.0);
        planarRegionTransform.transform((Vector3DBasics)expectedSurfaceNormal);
        Vector3D actualSurfaceNormal = new Vector3D(0.0, 0.0, 1.0);
        snapTransform.transform((Vector3DBasics)actualSurfaceNormal);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSurfaceNormal, (EuclidGeometry)actualSurfaceNormal, (double)1.0E-7);
        Vector3D xAxis = new Vector3D(1.0, 0.0, 0.0);
        snapTransform.transform((Vector3DBasics)xAxis);
        Assert.assertEquals((double)0.0, (double)xAxis.getY(), (double)1.0E-7);
    }

    private static void doATest(PlanarRegionsList planarRegionsList, ArrayList<double[]> xyYawToTest) {
        Point2D originalPoint = new Point2D();
        RigidBodyTransform nonSnappedTransform = new RigidBodyTransform();
        for (double[] xyYaw : xyYawToTest) {
            Point2D pointToSnap = new Point2D((Tuple2DReadOnly)originalPoint);
            nonSnappedTransform = new RigidBodyTransform();
            nonSnappedTransform.setRotationEulerAndZeroTranslation(0.0, 0.0, xyYaw[2]);
            nonSnappedTransform.getTranslation().set(xyYaw[0], xyYaw[1], 0.0);
            pointToSnap.applyTransform((Transform)nonSnappedTransform, false);
            PlanarRegion planarRegionIntersection = new PlanarRegion();
            RigidBodyTransform snapTransform = PlanarRegionsListPointSnapper.snapPointToPlanarRegionsList((Point2DReadOnly)pointToSnap, (List)planarRegionsList.getPlanarRegionsAsList(), (PlanarRegion)planarRegionIntersection);
            if (snapTransform != null) {
                Point3D snappedVertex = new Point3D(pointToSnap.getX(), pointToSnap.getY(), 0.0);
                snapTransform.transform((Point3DBasics)snappedVertex);
                List planarRegions = planarRegionsList.findPlanarRegionsContainingPointByProjectionOntoXYPlane(snappedVertex.getX(), snappedVertex.getY());
                if (planarRegions != null) {
                    double highestZ = Double.NEGATIVE_INFINITY;
                    for (PlanarRegion planarRegion : planarRegions) {
                        double planeZGivenXY = planarRegion.getPlaneZGivenXY(snappedVertex.getX(), snappedVertex.getY());
                        if (!(planeZGivenXY > highestZ)) continue;
                        highestZ = planeZGivenXY;
                    }
                    Assert.assertEquals((double)pointToSnap.getX(), (double)snappedVertex.getX(), (double)1.0E-7);
                    Assert.assertEquals((double)pointToSnap.getY(), (double)snappedVertex.getY(), (double)1.0E-7);
                    Assert.assertEquals((String)("planeZGivenXY = " + highestZ + ", snappedVertex.getZ() = " + snappedVertex.getZ()), (double)highestZ, (double)snappedVertex.getZ(), (double)1.0E-7);
                    continue;
                }
                Fail.fail();
                continue;
            }
            List planarRegions = planarRegionsList.findPlanarRegionsContainingPointByProjectionOntoXYPlane(pointToSnap.getX(), pointToSnap.getY());
            if (planarRegions == null) continue;
            Assert.assertTrue((boolean)planarRegions.isEmpty());
        }
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(PlanarRegionsListPointSnapper.class, PlanarRegionsListPointSnapperTest.class);
    }
}

