/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.pawSnapping;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Conversions;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.pawSnapping.PlanarRegionPawConstraintData;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.ConvexPolygonScaler;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.geometry.PlanarRegionsListGenerator;

public class PlanarRegionPawConstraintDataTest {
    @Test
    public void testSimpleRectangle() {
        ConvexPolygonScaler scaler = new ConvexPolygonScaler();
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        generator.addRectangle(0.2, 1.0);
        PlanarRegionsList planarRegionsList = generator.getPlanarRegionsList();
        PlanarRegionPawConstraintData planarRegionPawConstraintData = new PlanarRegionPawConstraintData(scaler, planarRegionsList.getPlanarRegion(0), true, 0.2, -1.0);
        ConvexPolygon2DReadOnly scaledRegionPolygon = planarRegionPawConstraintData.getScaledRegionPolygon((Point2DReadOnly)new Point2D(0.0, 0.0));
        Point2D projectionPoint = new Point2D();
        double epsilon = 0.001;
        projectionPoint.set(0.0, 1.0);
        scaledRegionPolygon.orthogonalProjection((Point2DBasics)projectionPoint);
        Assert.assertTrue((boolean)projectionPoint.epsilonEquals((EuclidGeometry)new Point2D(0.0, 0.4), epsilon));
        projectionPoint.set(0.0, -1.0);
        scaledRegionPolygon.orthogonalProjection((Point2DBasics)projectionPoint);
        Assert.assertTrue((boolean)projectionPoint.epsilonEquals((EuclidGeometry)new Point2D(0.0, -0.4), epsilon));
        projectionPoint.set(1.0, 0.0);
        scaledRegionPolygon.orthogonalProjection((Point2DBasics)projectionPoint);
        Assert.assertTrue((boolean)projectionPoint.epsilonEquals((EuclidGeometry)new Point2D(0.0, 0.0), epsilon));
        projectionPoint.set(-1.0, 0.0);
        scaledRegionPolygon.orthogonalProjection((Point2DBasics)projectionPoint);
        Assert.assertTrue((boolean)projectionPoint.epsilonEquals((EuclidGeometry)new Point2D(0.0, 0.0), epsilon));
    }

    private static void testTiming() {
        int i;
        Random random = new Random(3290L);
        int numberOfRegions = 1000;
        double[] successfulProjectionDistance = new double[numberOfRegions];
        double[] unsuccessfulProjectionDistances = new double[numberOfRegions];
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        for (int i2 = 0; i2 < numberOfRegions; ++i2) {
            generator.translateThenRotate(EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
            double sideX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)2.0);
            double sideY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)2.0);
            generator.addRectangle(sideX, sideY);
            successfulProjectionDistance[i2] = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)(0.5 * Math.min(sideX, sideY) - 0.01));
            unsuccessfulProjectionDistances[i2] = EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * Math.min(sideX, sideY) + 0.01), (double)(Math.max(sideX, sideY) - 0.01));
        }
        PlanarRegionsList planarRegionsList = generator.getPlanarRegionsList();
        ConvexPolygonScaler scaler = new ConvexPolygonScaler();
        long start = System.nanoTime();
        for (i = 0; i < numberOfRegions; ++i) {
            new PlanarRegionPawConstraintData(scaler, planarRegionsList.getPlanarRegion(i), true, successfulProjectionDistance[i], -1.0);
        }
        long stop = System.nanoTime();
        System.out.println("Average time taken not using fallback projection: " + Conversions.nanosecondsToSeconds((long)(stop - start)) / (double)numberOfRegions + " sec");
        start = System.nanoTime();
        for (i = 0; i < numberOfRegions; ++i) {
            new PlanarRegionPawConstraintData(scaler, planarRegionsList.getPlanarRegion(i), true, unsuccessfulProjectionDistances[i], -1.0);
        }
        stop = System.nanoTime();
        System.out.println("Average time taken using fallback projection: " + Conversions.nanosecondsToSeconds((long)(stop - start)) / (double)numberOfRegions + " sec");
    }

    public static void main(String[] args) {
        PlanarRegionPawConstraintDataTest.testTiming();
    }
}

