/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.pawSnapping;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Random;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.graph.PawNode;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.pawSnapping.PawNodeSnapData;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.pawSnapping.PawNodeSnapper;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.robotSide.RobotQuadrant;

public class PawNodeSnapperTest {
    private final Random random = new Random(320L);
    private final double epsilon = 1.0E-8;
    private int[] frontLeftXIndices = new int[]{-30, 0, 23, 87, -100, 42};
    private int[] frontRightXIndices = new int[]{-30, 0, 23, 87, -100, 42};
    private int[] hindLeftXIndices = new int[]{-30, 0, 23, 87, -100, 42};
    private int[] hindRightXIndices = new int[]{-30, 0, 23, 87, -100, 42};
    private int[] frontLeftYIndices = new int[]{-35, 0, -777, 87, -50, 28};
    private int[] frontRightYIndices = new int[]{-35, 0, -777, 87, -50, 28};
    private int[] hindLeftYIndices = new int[]{-35, 0, -777, 87, -50, 28};
    private int[] hindRightYIndices = new int[]{-35, 0, -777, 87, -50, 28};

    @Disabled
    @Test
    public void testFootstepCacheing() {
        TestSnapper testSnapper = new TestSnapper();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(new PlanarRegion[]{new PlanarRegion()});
        testSnapper.setPlanarRegions(planarRegionsList);
        for (int i = 0; i < this.frontLeftXIndices.length; ++i) {
            for (int j = 0; j < this.frontLeftYIndices.length; ++j) {
                for (int k = 0; k < this.frontRightXIndices.length; ++k) {
                    for (int l = 0; l < this.frontRightYIndices.length; ++l) {
                        for (int m = 0; m < this.hindLeftXIndices.length; ++m) {
                            for (int n = 0; n < this.hindLeftYIndices.length; ++n) {
                                for (int o = 0; o < this.hindRightXIndices.length; ++o) {
                                    for (int p = 0; p < this.hindRightYIndices.length; ++p) {
                                        int xIndex;
                                        RobotQuadrant robotQuadrant = RobotQuadrant.generateRandomRobotQuadrant((Random)this.random);
                                        double frontLeftX = PawNode.gridSizeXY * (double)this.frontLeftXIndices[i];
                                        double frontLeftY = PawNode.gridSizeXY * (double)this.frontLeftYIndices[j];
                                        double frontRightX = PawNode.gridSizeXY * (double)this.frontRightXIndices[k];
                                        double frontRightY = PawNode.gridSizeXY * (double)this.frontRightYIndices[l];
                                        double hindLeftX = PawNode.gridSizeXY * (double)this.hindLeftXIndices[m];
                                        double hindLeftY = PawNode.gridSizeXY * (double)this.hindLeftYIndices[n];
                                        double hindRightX = PawNode.gridSizeXY * (double)this.hindRightXIndices[o];
                                        double hindRightY = PawNode.gridSizeXY * (double)this.hindRightYIndices[p];
                                        double length = 1.0;
                                        double width = 0.5;
                                        int yIndex = switch (robotQuadrant) {
                                            case RobotQuadrant.FRONT_LEFT -> {
                                                xIndex = PawNode.snapToGrid((double)frontLeftX);
                                                yield PawNode.snapToGrid((double)frontLeftY);
                                            }
                                            case RobotQuadrant.FRONT_RIGHT -> {
                                                xIndex = PawNode.snapToGrid((double)frontRightX);
                                                yield PawNode.snapToGrid((double)frontRightY);
                                            }
                                            case RobotQuadrant.HIND_LEFT -> {
                                                xIndex = PawNode.snapToGrid((double)hindLeftX);
                                                yield PawNode.snapToGrid((double)hindLeftY);
                                            }
                                            default -> {
                                                xIndex = PawNode.snapToGrid((double)hindRightX);
                                                yield PawNode.snapToGrid((double)hindRightY);
                                            }
                                        };
                                        testSnapper.dirtyBit = true;
                                        String string = "i " + i + " j " + j + " k " + k + " l " + l + " m " + m + " n " + n + " o " + o + " p " + p;
                                        testSnapper.snapPawNode(robotQuadrant, xIndex, yIndex, 0.0);
                                        Assert.assertTrue((String)string, (boolean)testSnapper.dirtyBit);
                                        testSnapper.dirtyBit = false;
                                        testSnapper.snapPawNode(robotQuadrant, xIndex, yIndex, 0.0);
                                        Assert.assertFalse((String)string, (boolean)testSnapper.dirtyBit);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testWithoutPlanarRegions() {
        TestSnapper testSnapper = new TestSnapper();
        for (int i = 0; i < this.frontLeftXIndices.length; ++i) {
            for (int j = 0; j < this.frontLeftYIndices.length; ++j) {
                for (int k = 0; k < this.frontRightXIndices.length; ++k) {
                    for (int l = 0; l < this.frontRightYIndices.length; ++l) {
                        for (int m = 0; m < this.hindLeftXIndices.length; ++m) {
                            for (int n = 0; n < this.hindLeftYIndices.length; ++n) {
                                for (int o = 0; o < this.hindRightXIndices.length; ++o) {
                                    for (int p = 0; p < this.hindRightYIndices.length; ++p) {
                                        int xIndex;
                                        RobotQuadrant newQuadrant = RobotQuadrant.generateRandomRobotQuadrant((Random)this.random);
                                        double frontLeftX = PawNode.gridSizeXY * (double)this.frontLeftXIndices[i];
                                        double frontLeftY = PawNode.gridSizeXY * (double)this.frontLeftYIndices[j];
                                        double frontRightX = PawNode.gridSizeXY * (double)this.frontRightXIndices[k];
                                        double frontRightY = PawNode.gridSizeXY * (double)this.frontRightYIndices[l];
                                        double hindLeftX = PawNode.gridSizeXY * (double)this.hindLeftXIndices[m];
                                        double hindLeftY = PawNode.gridSizeXY * (double)this.hindLeftYIndices[n];
                                        double hindRightX = PawNode.gridSizeXY * (double)this.hindRightXIndices[o];
                                        double hindRightY = PawNode.gridSizeXY * (double)this.hindRightYIndices[p];
                                        double length = 1.0;
                                        double width = 0.5;
                                        PawNodeSnapData snapData = testSnapper.snapPawNode(newQuadrant, xIndex, switch (newQuadrant) {
                                            case RobotQuadrant.FRONT_LEFT -> {
                                                xIndex = PawNode.snapToGrid((double)frontLeftX);
                                                yield PawNode.snapToGrid((double)frontLeftY);
                                            }
                                            case RobotQuadrant.FRONT_RIGHT -> {
                                                xIndex = PawNode.snapToGrid((double)frontRightX);
                                                yield PawNode.snapToGrid((double)frontRightY);
                                            }
                                            case RobotQuadrant.HIND_LEFT -> {
                                                xIndex = PawNode.snapToGrid((double)hindLeftX);
                                                yield PawNode.snapToGrid((double)hindLeftY);
                                            }
                                            default -> {
                                                xIndex = PawNode.snapToGrid((double)hindRightX);
                                                yield PawNode.snapToGrid((double)hindRightY);
                                            }
                                        }, 0.0);
                                        Assert.assertTrue((!testSnapper.dirtyBit ? 1 : 0) != 0);
                                        Assert.assertTrue((boolean)snapData.getSnapTransform().epsilonEquals((EuclidGeometry)new RigidBodyTransform(), 1.0E-8));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testHashMapStorage() {
        Random random = new Random(3823L);
        int numTrials = 100;
        for (int i = 0; i < numTrials; ++i) {
            RobotQuadrant robotQuadrant = RobotQuadrant.FRONT_LEFT;
            Point2D frontLeft = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)1.0);
            Point2D frontRight = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)1.0);
            Point2D otherFrontRight = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)1.0);
            Point2D hindLeft = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)1.0);
            Point2D otherHindLeft = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)1.0);
            Point2D hindRight = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)1.0);
            Point2D otherHindRight = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)1.0);
            double yaw = PawNode.computeNominalYaw((double)frontLeft.getX(), (double)frontLeft.getY(), (double)frontRight.getX(), (double)frontRight.getY(), (double)hindLeft.getX(), (double)hindLeft.getY(), (double)hindRight.getX(), (double)hindRight.getY());
            PawNode nodeA = new PawNode(robotQuadrant, (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, yaw, 1.5, 0.5);
            PawNode nodeB = new PawNode(robotQuadrant, (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)otherFrontRight, (Tuple2DReadOnly)otherHindLeft, (Tuple2DReadOnly)otherHindRight, yaw, 1.5, 0.5);
            TIntObjectHashMap snapDataHolder = new TIntObjectHashMap();
            Assert.assertFalse((String)("number : " + i), (boolean)snapDataHolder.containsKey(nodeB.hashCode()));
            snapDataHolder.put(nodeA.hashCode(), (Object)PawNodeSnapData.emptyData());
            Assert.assertTrue((String)("number : " + i), (boolean)snapDataHolder.containsKey(nodeA.hashCode()));
            if (nodeA.getYawIndex() != nodeB.getYawIndex()) continue;
            Assert.assertEquals((String)("number : " + i), (long)nodeA.hashCode(), (long)nodeB.hashCode());
            Assert.assertTrue((String)("number : " + i), (boolean)snapDataHolder.containsKey(nodeB.hashCode()));
        }
    }

    private class TestSnapper
    extends PawNodeSnapper {
        boolean dirtyBit = false;

        private TestSnapper() {
        }

        protected PawNodeSnapData snapInternal(RobotQuadrant robotQuadrant, int xIndex, int yIndex, double yaw) {
            this.dirtyBit = true;
            return PawNodeSnapData.emptyData();
        }
    }
}

