/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.nodeExpansion;

import java.util.HashSet;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.graph.PawNode;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.nodeExpansion.ParameterBasedPawNodeExpansion;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.parameters.DefaultPawStepPlannerParameters;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.parameters.PawStepPlannerParametersReadOnly;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.pawSnapping.PawNodeSnapData;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.pawSnapping.PawNodeSnapper;
import us.ihmc.quadrupedPlanning.QuadrupedSpeed;
import us.ihmc.quadrupedPlanning.QuadrupedXGaitSettings;
import us.ihmc.quadrupedPlanning.QuadrupedXGaitSettingsReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.robotSide.QuadrantDependentList;
import us.ihmc.robotics.robotSide.RobotQuadrant;
import us.ihmc.robotics.robotSide.RobotSide;

public class ParameterBasedNodeExpansionTest {
    private static final int iters = 1000;
    private static final RobotQuadrant quadrantToCheck = RobotQuadrant.HIND_LEFT;
    private static final double epsilon = 1.0E-7;
    private static final double stanceLength = 1.0;
    private static final double stanceWidth = 0.5;
    private static final boolean visualize = false;
    private static final QuadrantDependentList<AppearanceDefinition> colorDefinitions = new QuadrantDependentList((Object)YoAppearance.Red(), (Object)YoAppearance.Yellow(), (Object)YoAppearance.Blue(), (Object)YoAppearance.Beige());

    @Test
    public void testExpandNodeWithBaseAtOrigin() {
        DefaultPawStepPlannerParameters parameters = new DefaultPawStepPlannerParameters();
        QuadrupedXGaitSettings xGaitSettings = new QuadrupedXGaitSettings();
        xGaitSettings.setQuadrupedSpeed(QuadrupedSpeed.MEDIUM);
        xGaitSettings.setStanceWidth(0.5);
        xGaitSettings.setStanceLength(1.0);
        ParameterBasedPawNodeExpansion expansion = new ParameterBasedPawNodeExpansion((PawStepPlannerParametersReadOnly)parameters, (QuadrupedXGaitSettingsReadOnly)xGaitSettings);
        double yaw = 0.0;
        PawNode baseNode = new PawNode(quadrantToCheck, 0.5, 0.25, 0.5, -0.25, -0.5, 0.25, -0.5, -0.25, yaw, 1.0, 0.5);
        HashSet expandedNodes = expansion.expandNode(baseNode);
        for (PawNode expandedNode : expandedNodes) {
            Assert.assertFalse((String)("baseNode " + expandedNode + " is not supposed to be equal to " + baseNode), (boolean)expandedNode.equals((Object)baseNode));
        }
        RobotQuadrant expectedNewQuadrant = quadrantToCheck.getNextRegularGaitSwingQuadrant();
        for (PawNode node : expandedNodes) {
            Assert.assertEquals((Object)expectedNewQuadrant, (Object)node.getMovingQuadrant());
            for (RobotQuadrant robotQuadrant : RobotQuadrant.values) {
                if (expectedNewQuadrant == robotQuadrant) {
                    Point2DReadOnly center = baseNode.getOrComputeXGaitCenterPoint();
                    Point2D foot = new Point2D((Tuple2DReadOnly)center);
                    foot.add(0.5 * expectedNewQuadrant.getEnd().negateIfHindEnd(baseNode.getNominalStanceLength()), 0.5 * expectedNewQuadrant.getSide().negateIfRightSide(baseNode.getNominalStanceWidth()));
                    double lowerXBound = foot.getX() + (expectedNewQuadrant.isQuadrantInFront() ? parameters.getMinimumFrontStepLength() : parameters.getMinimumHindStepLength());
                    double upperXBound = foot.getX() + (expectedNewQuadrant.isQuadrantInFront() ? parameters.getMaximumFrontStepLength() : parameters.getMaximumHindStepLength());
                    double lowerYBound = foot.getY() - (robotQuadrant.getSide() == RobotSide.LEFT ? -parameters.getMaximumStepInward() : parameters.getMaximumStepOutward());
                    double upperYBound = foot.getY() + (robotQuadrant.getSide() == RobotSide.LEFT ? parameters.getMaximumStepOutward() : -parameters.getMaximumStepInward());
                    double xFoot = node.getX(robotQuadrant);
                    double yFoot = node.getY(robotQuadrant);
                    Assert.assertTrue((String)(robotQuadrant.getCamelCaseName() + " foot X " + xFoot + " is not within bounds " + lowerXBound + " < x < " + upperXBound), (boolean)MathTools.intervalContains((double)xFoot, (double)lowerXBound, (double)upperXBound, (double)PawNode.gridSizeXY));
                    Assert.assertTrue((String)(robotQuadrant.getCamelCaseName() + " foot Y " + yFoot + " is not within bounds " + lowerYBound + " < x < " + upperYBound), (boolean)MathTools.intervalContains((double)yFoot, (double)lowerYBound, (double)upperYBound, (double)PawNode.gridSizeXY));
                    continue;
                }
                Assert.assertEquals((double)baseNode.getX(robotQuadrant), (double)node.getX(robotQuadrant), (double)1.0E-7);
                Assert.assertEquals((double)baseNode.getY(robotQuadrant), (double)node.getY(robotQuadrant), (double)1.0E-7);
            }
        }
    }

    @Test
    public void testExpandNodeWithTranslatedAndRotated() {
        DefaultPawStepPlannerParameters parameters = new DefaultPawStepPlannerParameters();
        QuadrupedXGaitSettings xGaitSettings = new QuadrupedXGaitSettings();
        xGaitSettings.setQuadrupedSpeed(QuadrupedSpeed.MEDIUM);
        xGaitSettings.setStanceLength(1.0);
        xGaitSettings.setStanceWidth(0.5);
        ParameterBasedPawNodeExpansion expansion = new ParameterBasedPawNodeExpansion((PawStepPlannerParametersReadOnly)parameters, (QuadrupedXGaitSettingsReadOnly)xGaitSettings);
        PoseReferenceFrame centerFrame = new PoseReferenceFrame("centerFrame", ReferenceFrame.getWorldFrame());
        FramePoint2D frontLeft = new FramePoint2D((ReferenceFrame)centerFrame, 0.5, 0.25);
        FramePoint2D frontRight = new FramePoint2D((ReferenceFrame)centerFrame, 0.5, -0.25);
        FramePoint2D hindLeft = new FramePoint2D((ReferenceFrame)centerFrame, -0.5, 0.25);
        FramePoint2D hindRight = new FramePoint2D((ReferenceFrame)centerFrame, -0.5, -0.25);
        FramePose3D poseInWorld = new FramePose3D();
        poseInWorld.getPosition().set(1.1, -0.5, 0.0);
        poseInWorld.getOrientation().setToYawOrientation(0.7853981633974483);
        centerFrame.setPoseAndUpdate((FramePose3DReadOnly)poseInWorld);
        frontLeft.changeFrame(ReferenceFrame.getWorldFrame());
        frontRight.changeFrame(ReferenceFrame.getWorldFrame());
        hindLeft.changeFrame(ReferenceFrame.getWorldFrame());
        hindRight.changeFrame(ReferenceFrame.getWorldFrame());
        double yaw = PawNode.computeNominalYaw((double)frontLeft.getX(), (double)frontLeft.getY(), (double)frontRight.getX(), (double)frontRight.getY(), (double)hindLeft.getX(), (double)hindLeft.getY(), (double)hindRight.getX(), (double)hindRight.getY());
        PawNode baseNode = new PawNode(quadrantToCheck, (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, yaw, 1.0, 0.5);
        HashSet expandedNodes = expansion.expandNode(baseNode);
        RobotQuadrant expectedNewQuadrant = quadrantToCheck.getNextRegularGaitSwingQuadrant();
        for (PawNode node : expandedNodes) {
            Assert.assertEquals((Object)expectedNewQuadrant, (Object)node.getMovingQuadrant());
            for (RobotQuadrant robotQuadrant : RobotQuadrant.values) {
                if (expectedNewQuadrant == robotQuadrant) continue;
                Assert.assertEquals((double)baseNode.getX(robotQuadrant), (double)node.getX(robotQuadrant), (double)1.0E-7);
                Assert.assertEquals((double)baseNode.getY(robotQuadrant), (double)node.getY(robotQuadrant), (double)1.0E-7);
            }
        }
    }

    @Test
    public void testWeirdFeet() {
        DefaultPawStepPlannerParameters parameters = new DefaultPawStepPlannerParameters(){

            public double getMaximumFrontStepReach() {
                return 0.7;
            }

            public double getMaximumFrontStepLength() {
                return 0.6;
            }

            public double getMinimumFrontStepLength() {
                return -0.3;
            }

            public double getMaximumStepInward() {
                return -0.3;
            }

            public double getMaximumStepOutward() {
                return 0.35;
            }
        };
        QuadrupedXGaitSettings xGaitSettings = new QuadrupedXGaitSettings();
        xGaitSettings.setStanceLength(1.0);
        xGaitSettings.setStanceWidth(0.5);
        xGaitSettings.setQuadrupedSpeed(QuadrupedSpeed.MEDIUM);
        ParameterBasedPawNodeExpansion expansion = new ParameterBasedPawNodeExpansion((PawStepPlannerParametersReadOnly)parameters, (QuadrupedXGaitSettingsReadOnly)xGaitSettings);
        double frontLeftX = 0.5;
        double frontLeftY = 0.5;
        double gridSizeXY = PawNode.gridSizeXY;
        FramePoint2D frontLeft = new FramePoint2D(ReferenceFrame.getWorldFrame(), frontLeftX, frontLeftY);
        FramePoint2D frontRight = new FramePoint2D(ReferenceFrame.getWorldFrame(), frontLeftX + 6.0 * gridSizeXY, frontLeftY - 10.0 * gridSizeXY);
        FramePoint2D hindLeft = new FramePoint2D(ReferenceFrame.getWorldFrame(), frontLeftX - 13.0 * gridSizeXY, frontLeftY - 2.0 * gridSizeXY);
        FramePoint2D hindRight = new FramePoint2D(ReferenceFrame.getWorldFrame(), frontLeftX - 8.0 * gridSizeXY, frontLeftY - 6.0 * gridSizeXY);
        RobotQuadrant expectedNewQuadrant = RobotQuadrant.HIND_LEFT;
        double yaw = PawNode.computeNominalYaw((double)frontLeft.getX(), (double)frontLeft.getY(), (double)frontRight.getX(), (double)frontRight.getY(), (double)hindLeft.getX(), (double)hindLeft.getY(), (double)hindRight.getX(), (double)hindRight.getY());
        PawNode baseNode = new PawNode(expectedNewQuadrant.getNextReversedRegularGaitSwingQuadrant(), (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, yaw, 1.0, 0.5);
        HashSet expandedNodes = expansion.expandNode(baseNode);
        for (PawNode node : expandedNodes) {
            Assert.assertEquals((Object)expectedNewQuadrant, (Object)node.getMovingQuadrant());
            for (RobotQuadrant robotQuadrant : RobotQuadrant.values) {
                if (expectedNewQuadrant == robotQuadrant) continue;
                Assert.assertEquals((double)baseNode.getX(robotQuadrant), (double)node.getX(robotQuadrant), (double)1.0E-7);
                Assert.assertEquals((double)baseNode.getY(robotQuadrant), (double)node.getY(robotQuadrant), (double)1.0E-7);
            }
        }
    }

    @Test
    public void testCheckNodeIsFarEnoughFromOtherFoot() {
        Random random = new Random(1738L);
        for (int iter = 0; iter < 1000; ++iter) {
            Vector2D requiredClearance = EuclidCoreRandomTools.nextVector2D((Random)random);
            requiredClearance.setX(Math.abs(requiredClearance.getX()));
            requiredClearance.setY(Math.abs(requiredClearance.getY()));
            Point2D previousNodePoint = EuclidCoreRandomTools.nextPoint2D((Random)random);
            String message = "iter = " + iter + " failed.";
            Vector2D offset = new Vector2D((Tuple2DReadOnly)requiredClearance);
            Point2D positionToCheck = new Point2D();
            positionToCheck.set((Tuple2DReadOnly)previousNodePoint);
            positionToCheck.add((Tuple2DReadOnly)offset);
            Assert.assertFalse((String)message, (boolean)ParameterBasedPawNodeExpansion.checkNodeIsFarEnoughFromOtherPaw((Point2DReadOnly)positionToCheck, (Vector2DReadOnly)requiredClearance, (double)previousNodePoint.getX(), (double)previousNodePoint.getY()));
            positionToCheck.set((Tuple2DReadOnly)previousNodePoint);
            positionToCheck.sub((Tuple2DReadOnly)offset);
            Assert.assertFalse((String)message, (boolean)ParameterBasedPawNodeExpansion.checkNodeIsFarEnoughFromOtherPaw((Point2DReadOnly)positionToCheck, (Vector2DReadOnly)requiredClearance, (double)previousNodePoint.getX(), (double)previousNodePoint.getY()));
            offset.set(requiredClearance);
            offset.scale(0.9);
            positionToCheck.set((Tuple2DReadOnly)previousNodePoint);
            positionToCheck.add((Tuple2DReadOnly)offset);
            Assert.assertFalse((String)message, (boolean)ParameterBasedPawNodeExpansion.checkNodeIsFarEnoughFromOtherPaw((Point2DReadOnly)positionToCheck, (Vector2DReadOnly)requiredClearance, (double)previousNodePoint.getX(), (double)previousNodePoint.getY()));
            positionToCheck.set((Tuple2DReadOnly)previousNodePoint);
            positionToCheck.sub((Tuple2DReadOnly)offset);
            Assert.assertFalse((String)message, (boolean)ParameterBasedPawNodeExpansion.checkNodeIsFarEnoughFromOtherPaw((Point2DReadOnly)positionToCheck, (Vector2DReadOnly)requiredClearance, (double)previousNodePoint.getX(), (double)previousNodePoint.getY()));
            offset.set(requiredClearance);
            offset.scale(1.1);
            positionToCheck.set((Tuple2DReadOnly)previousNodePoint);
            positionToCheck.add((Tuple2DReadOnly)offset);
            Assert.assertTrue((String)message, (boolean)ParameterBasedPawNodeExpansion.checkNodeIsFarEnoughFromOtherPaw((Point2DReadOnly)positionToCheck, (Vector2DReadOnly)requiredClearance, (double)previousNodePoint.getX(), (double)previousNodePoint.getY()));
            positionToCheck.set((Tuple2DReadOnly)previousNodePoint);
            positionToCheck.sub((Tuple2DReadOnly)offset);
            Assert.assertTrue((String)message, (boolean)ParameterBasedPawNodeExpansion.checkNodeIsFarEnoughFromOtherPaw((Point2DReadOnly)positionToCheck, (Vector2DReadOnly)requiredClearance, (double)previousNodePoint.getX(), (double)previousNodePoint.getY()));
        }
    }

    private void visualizeNodes(PawStepPlannerParametersReadOnly parameters, HashSet<PawNode> neighboringNodes, PawNode baseNode) {
    }

    private static QuadrantDependentList<Point3D> getSnappedStepPositions(PawNode node, PawNodeSnapper snapper) {
        QuadrantDependentList snappedStepPositions = new QuadrantDependentList();
        for (RobotQuadrant robotQuadrant : RobotQuadrant.values) {
            PawNodeSnapData snapData = snapper.snapPawNode(robotQuadrant, node.getXIndex(robotQuadrant), node.getYIndex(robotQuadrant), node.getStepYaw());
            RigidBodyTransform footSnapTransform = snapData.getSnapTransform();
            Point3D stepPosition = new Point3D(node.getX(robotQuadrant), node.getY(robotQuadrant), 0.0);
            footSnapTransform.transform((Point3DBasics)stepPosition);
            snappedStepPositions.put((Enum)robotQuadrant, (Object)stepPosition);
        }
        return snappedStepPositions;
    }

    private static QuadrantDependentList<PoseReferenceFrame> getFootFrames(QuadrantDependentList<Point3D> stepPositions, Orientation3DReadOnly orientation) {
        QuadrantDependentList footFrames = new QuadrantDependentList();
        for (RobotQuadrant robotQuadrant : RobotQuadrant.values) {
            PoseReferenceFrame footFrame = new PoseReferenceFrame(robotQuadrant.getCamelCaseName() + "FootFrame", ReferenceFrame.getWorldFrame());
            footFrame.setPoseAndUpdate((Point3DReadOnly)stepPositions.get((Enum)robotQuadrant), orientation);
            footFrames.put((Enum)robotQuadrant, (Object)footFrame);
        }
        return footFrames;
    }
}

