/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.nodeChecking;

import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.PawStepPlannerNodeRejectionReason;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.graph.PawNode;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.listeners.PawStepPlannerListener;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.nodeChecking.SnapBasedPawNodeTransitionChecker;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.parameters.DefaultPawStepPlannerParameters;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.parameters.PawStepPlannerParametersReadOnly;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.pawSnapping.PawNodeSnapper;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.pawSnapping.SimplePlanarRegionPawNodeSnapper;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.robotSide.RobotQuadrant;

public class SnapBasedPawNodeTransitionCheckerTest {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();

    @Test
    public void testStepInPlace() {
        PawNode newNode;
        Point2D shiftedFrontLeft;
        double scaleFactor;
        Vector2D offsetVector;
        int iter;
        DefaultPawStepPlannerParameters parameters = new DefaultPawStepPlannerParameters();
        parameters.setMinimumFrontStepLength(-0.3);
        parameters.setProjectInsideDistance(0.0);
        SimplePlanarRegionPawNodeSnapper snapper = new SimplePlanarRegionPawNodeSnapper((PawStepPlannerParametersReadOnly)parameters, true);
        SnapBasedPawNodeTransitionChecker nodeChecker = new SnapBasedPawNodeTransitionChecker((PawStepPlannerParametersReadOnly)parameters, (PawNodeSnapper)snapper);
        TestListener testListener = new TestListener();
        nodeChecker.addPlannerListener((PawStepPlannerListener)testListener);
        PoseReferenceFrame footstepFrame = new PoseReferenceFrame("footstepFrame", worldFrame);
        footstepFrame.setPoseAndUpdate((Point3DReadOnly)new Point3D(0.6, 0.9, 0.0), (Orientation3DReadOnly)new AxisAngle(-0.7853981633974483, 0.0, 0.0));
        PawNode.gridSizeXY = 0.001;
        RobotQuadrant robotQuadrant = RobotQuadrant.FRONT_LEFT;
        FramePoint2D frontLeft = new FramePoint2D((ReferenceFrame)footstepFrame, 1.57, 0.67);
        FramePoint2D frontRight = new FramePoint2D((ReferenceFrame)footstepFrame, 1.63, 0.12);
        FramePoint2D hindLeft = new FramePoint2D((ReferenceFrame)footstepFrame, 0.67, 0.72);
        FramePoint2D otherHindLeft = new FramePoint2D((ReferenceFrame)footstepFrame, 0.69, 0.72);
        FramePoint2D hindRight = new FramePoint2D((ReferenceFrame)footstepFrame, 0.73, 0.05);
        frontLeft.changeFrame(worldFrame);
        frontRight.changeFrame(worldFrame);
        hindLeft.changeFrame(worldFrame);
        otherHindLeft.changeFrame(worldFrame);
        hindRight.changeFrame(worldFrame);
        double yaw = PawNode.computeNominalYaw((double)frontLeft.getX(), (double)frontLeft.getY(), (double)frontRight.getX(), (double)frontRight.getY(), (double)hindLeft.getX(), (double)hindLeft.getY(), (double)hindRight.getX(), (double)hindRight.getY());
        PawNode previousNode = new PawNode(robotQuadrant, (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)otherHindLeft, (Tuple2DReadOnly)hindRight, yaw, 1.0, 0.5);
        PawNode node = new PawNode(robotQuadrant, (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, yaw, 1.0, 0.5);
        PoseReferenceFrame nodeFrame = new PoseReferenceFrame("nodeFrame", worldFrame);
        nodeFrame.setPoseAndUpdate((Point3DReadOnly)new Point3D(previousNode.getOrComputeXGaitCenterPoint().getX(), previousNode.getOrComputeXGaitCenterPoint().getY(), 0.0), (Orientation3DReadOnly)new AxisAngle(yaw, 0.0, 0.0));
        String message = "Stepping from " + previousNode + " to " + node;
        FrameVector2D clearanceVector = new FrameVector2D((ReferenceFrame)nodeFrame, parameters.getMinXClearanceFromPaw(), parameters.getMinYClearanceFromPaw());
        clearanceVector.changeFrame(worldFrame);
        Random random = new Random(1738L);
        for (iter = 0; iter < 50; ++iter) {
            offsetVector = new Vector2D((Tuple2DReadOnly)clearanceVector);
            scaleFactor = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)0.8);
            offsetVector.scale(scaleFactor);
            if (RandomNumbers.nextBoolean((Random)random, (double)0.5)) {
                offsetVector.setX(-offsetVector.getX());
            }
            if (RandomNumbers.nextBoolean((Random)random, (double)0.5)) {
                offsetVector.setY(-offsetVector.getY());
            }
            shiftedFrontLeft = new Point2D((Tuple2DReadOnly)frontLeft);
            shiftedFrontLeft.add((Tuple2DReadOnly)offsetVector);
            newNode = new PawNode(robotQuadrant, (Tuple2DReadOnly)shiftedFrontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, yaw, 1.0, 0.5);
            if (newNode.getXIndex(robotQuadrant) == previousNode.getXIndex(robotQuadrant) && newNode.getYIndex(robotQuadrant) == previousNode.getYIndex(robotQuadrant)) continue;
            message = "iter = " + iter + ". Stepping from " + previousNode + "\nTo " + newNode + "\n, clearance amount in the moving foot is only " + offsetVector + "\n clearance required is " + clearanceVector;
            Assertions.assertFalse((boolean)nodeChecker.isNodeValid(newNode, previousNode), (String)message);
            testListener.assertCorrectRejection(message, newNode, previousNode, PawStepPlannerNodeRejectionReason.STEP_IN_PLACE);
        }
        for (iter = 0; iter < 10; ++iter) {
            offsetVector = new FrameVector2D((FrameTuple2DReadOnly)clearanceVector);
            scaleFactor = RandomNumbers.nextDouble((Random)random, (double)0.8, (double)0.9);
            offsetVector.scale(scaleFactor);
            if (RandomNumbers.nextBoolean((Random)random, (double)0.5)) {
                offsetVector.setX(-offsetVector.getX());
            }
            if (RandomNumbers.nextBoolean((Random)random, (double)0.5)) {
                offsetVector.setY(-offsetVector.getY());
            }
            shiftedFrontLeft = new FramePoint2D((FrameTuple2DReadOnly)frontLeft);
            shiftedFrontLeft.add((FrameTuple2DReadOnly)offsetVector);
            newNode = new PawNode(robotQuadrant, (Tuple2DReadOnly)shiftedFrontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, yaw, 1.0, 0.5);
            offsetVector.changeFrame((ReferenceFrame)nodeFrame);
            message = "Stepping from " + previousNode + "\n To " + newNode + "\n, clearance amount in the moving foot is only " + (FrameVector2D)offsetVector + "\n";
            Assertions.assertFalse((boolean)nodeChecker.isNodeValid(newNode, previousNode), (String)message);
            testListener.assertCorrectRejection(message, newNode, previousNode, PawStepPlannerNodeRejectionReason.STEP_IN_PLACE);
        }
        for (iter = 0; iter < 10; ++iter) {
            frontLeft.changeFrame(worldFrame);
            frontRight.changeFrame(worldFrame);
            clearanceVector.changeFrame((ReferenceFrame)nodeFrame);
            offsetVector = new FrameVector2D((FrameTuple2DReadOnly)clearanceVector);
            scaleFactor = RandomNumbers.nextDouble((Random)random, (double)1.1, (double)1.15);
            offsetVector.scale(scaleFactor);
            if (RandomNumbers.nextBoolean((Random)random, (double)0.5)) {
                offsetVector.setX(-offsetVector.getX());
            }
            offsetVector.changeFrame(worldFrame);
            shiftedFrontLeft = new FramePoint2D((FrameTuple2DReadOnly)frontLeft);
            shiftedFrontLeft.add((FrameTuple2DReadOnly)offsetVector);
            newNode = new PawNode(robotQuadrant, (Tuple2DReadOnly)shiftedFrontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, yaw, 1.0, 0.5);
            frontLeft.changeFrame((ReferenceFrame)nodeFrame);
            shiftedFrontLeft.changeFrame((ReferenceFrame)nodeFrame);
            frontRight.changeFrame((ReferenceFrame)nodeFrame);
            clearanceVector.changeFrame((ReferenceFrame)nodeFrame);
            offsetVector.changeFrame((ReferenceFrame)nodeFrame);
            message = "Stepping from " + previousNode + "\n To " + newNode + "\n";
            message = message + "Front left = " + frontLeft + "\nShifted front left = " + (FramePoint2D)shiftedFrontLeft + "\nFront right = " + frontRight + "\nOffset = " + (FrameVector2D)offsetVector + "\nRequired clearance = " + clearanceVector + "\n";
            boolean isValid = nodeChecker.isNodeValid(newNode, previousNode);
            testListener.assertCorrectRejection(message, null, null, null);
            Assertions.assertTrue((boolean)isValid);
        }
    }

    @Test
    public void testStepTooFarInwardFrontLeft() {
        boolean isValid;
        String message;
        PawNode newNode;
        FramePoint2D shiftedFrontLeft;
        double scaleFactor;
        FrameVector2D offsetVector;
        int iter;
        Random random = new Random(1738L);
        double stanceLength = 1.0;
        double stanceWidth = 0.5;
        TestParameters parameters = new TestParameters();
        SimplePlanarRegionPawNodeSnapper snapper = new SimplePlanarRegionPawNodeSnapper((PawStepPlannerParametersReadOnly)parameters, true);
        SnapBasedPawNodeTransitionChecker nodeChecker = new SnapBasedPawNodeTransitionChecker((PawStepPlannerParametersReadOnly)parameters, (PawNodeSnapper)snapper);
        TestListener testListener = new TestListener();
        nodeChecker.addPlannerListener((PawStepPlannerListener)testListener);
        double stepYaw = -0.7853981633974483;
        PoseReferenceFrame previousNodeXGaitFrame = new PoseReferenceFrame("nodeFrame", worldFrame);
        previousNodeXGaitFrame.setPoseAndUpdate((Point3DReadOnly)new Point3D(0.6, 0.9, 0.0), (Orientation3DReadOnly)new AxisAngle(stepYaw, 0.0, 0.0));
        PawNode.gridSizeXY = 0.001;
        RobotQuadrant robotQuadrant = RobotQuadrant.FRONT_LEFT;
        FramePoint2D frontLeft = new FramePoint2D((ReferenceFrame)previousNodeXGaitFrame, 0.57, 0.27);
        FramePoint2D frontRight = new FramePoint2D((ReferenceFrame)previousNodeXGaitFrame, 0.63, -0.42);
        FramePoint2D hindLeft = new FramePoint2D((ReferenceFrame)previousNodeXGaitFrame, -0.67, 0.32);
        FramePoint2D hindRight = new FramePoint2D((ReferenceFrame)previousNodeXGaitFrame, -0.73, -0.35);
        frontLeft.changeFrame(worldFrame);
        frontRight.changeFrame(worldFrame);
        hindLeft.changeFrame(worldFrame);
        hindRight.changeFrame(worldFrame);
        PawNode previousNode = new PawNode(robotQuadrant, (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, stepYaw, stanceLength, stanceWidth);
        previousNodeXGaitFrame.setPoseAndUpdate((Point3DReadOnly)new Point3D((Tuple2DReadOnly)previousNode.getOrComputeXGaitCenterPoint()), previousNode.getStepOrientation());
        FramePoint2D nominalFrontLeft = new FramePoint2D((ReferenceFrame)previousNodeXGaitFrame, 0.5 * previousNode.getNominalStanceLength(), 0.5 * previousNode.getNominalStanceWidth());
        for (iter = 0; iter < 50; ++iter) {
            offsetVector = new FrameVector2D((ReferenceFrame)previousNodeXGaitFrame, 0.0, parameters.getMaximumStepInward());
            scaleFactor = RandomNumbers.nextDouble((Random)random, (double)0.05, (double)0.95);
            offsetVector.scale(scaleFactor);
            shiftedFrontLeft = new FramePoint2D((FrameTuple2DReadOnly)nominalFrontLeft);
            shiftedFrontLeft.add((FrameTuple2DReadOnly)offsetVector);
            shiftedFrontLeft.changeFrameAndProjectToXYPlane(worldFrame);
            newNode = new PawNode(robotQuadrant, (Tuple2DReadOnly)shiftedFrontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, stepYaw, stanceLength, stanceWidth);
            frontLeft.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            shiftedFrontLeft.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            offsetVector.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            message = "\nIteration " + iter + ".\nStepping from " + previousNode + " to " + newNode + "\n";
            isValid = nodeChecker.isNodeValid(newNode, previousNode);
            testListener.assertCorrectRejection(message, null, null, null);
            Assertions.assertTrue((boolean)isValid);
        }
        for (iter = 0; iter < 50; ++iter) {
            offsetVector = new FrameVector2D((ReferenceFrame)previousNodeXGaitFrame, 0.0, parameters.getMaximumStepInward());
            scaleFactor = RandomNumbers.nextDouble((Random)random, (double)0.95, (double)0.99);
            offsetVector.scale(scaleFactor);
            shiftedFrontLeft = new FramePoint2D((FrameTuple2DReadOnly)nominalFrontLeft);
            shiftedFrontLeft.add((FrameTuple2DReadOnly)offsetVector);
            shiftedFrontLeft.changeFrameAndProjectToXYPlane(worldFrame);
            newNode = new PawNode(robotQuadrant, (Tuple2DReadOnly)shiftedFrontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, stepYaw, stanceLength, stanceWidth);
            frontLeft.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            shiftedFrontLeft.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            offsetVector.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            message = "\nIteration " + iter + ".\nStepping from " + previousNode + " to " + newNode + "\n";
            isValid = nodeChecker.isNodeValid(newNode, previousNode);
            testListener.assertCorrectRejection(message, null, null, null);
            Assertions.assertTrue((boolean)isValid);
        }
        for (iter = 0; iter < 50; ++iter) {
            offsetVector = new FrameVector2D((ReferenceFrame)previousNodeXGaitFrame, 0.0, parameters.getMaximumStepInward());
            scaleFactor = RandomNumbers.nextDouble((Random)random, (double)1.01, (double)1.2);
            offsetVector.scale(scaleFactor);
            shiftedFrontLeft = new FramePoint2D((FrameTuple2DReadOnly)nominalFrontLeft);
            shiftedFrontLeft.add((FrameTuple2DReadOnly)offsetVector);
            shiftedFrontLeft.changeFrameAndProjectToXYPlane(worldFrame);
            newNode = new PawNode(robotQuadrant, (Tuple2DReadOnly)shiftedFrontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, stepYaw, stanceLength, stanceWidth);
            frontLeft.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            shiftedFrontLeft.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            offsetVector.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            message = "\nIteration " + iter + ".\nStepping from " + previousNode + " to " + newNode + "\n";
            isValid = nodeChecker.isNodeValid(newNode, previousNode);
            testListener.assertCorrectRejection(message, newNode, previousNode, PawStepPlannerNodeRejectionReason.STEP_TOO_FAR_RIGHT);
            Assertions.assertFalse((boolean)isValid);
        }
    }

    @Test
    public void testStepTooFarInwardHindRight() {
        boolean isValid;
        String message;
        PawNode newNode;
        FramePoint2D shiftedHindRight;
        double scaleFactor;
        FrameVector2D offsetVector;
        int iter;
        double stanceLength = 1.0;
        double stanceWidth = 0.5;
        TestParameters parameters = new TestParameters();
        SimplePlanarRegionPawNodeSnapper snapper = new SimplePlanarRegionPawNodeSnapper((PawStepPlannerParametersReadOnly)parameters, true);
        SnapBasedPawNodeTransitionChecker nodeChecker = new SnapBasedPawNodeTransitionChecker((PawStepPlannerParametersReadOnly)parameters, (PawNodeSnapper)snapper);
        TestListener testListener = new TestListener();
        nodeChecker.addPlannerListener((PawStepPlannerListener)testListener);
        double stepYaw = -0.7853981633974483;
        PoseReferenceFrame previousNodeXGaitFrame = new PoseReferenceFrame("nodeFrame", worldFrame);
        previousNodeXGaitFrame.setPoseAndUpdate((Point3DReadOnly)new Point3D(0.6, 0.9, 0.0), (Orientation3DReadOnly)new AxisAngle(stepYaw, 0.0, 0.0));
        PawNode.gridSizeXY = 0.001;
        RobotQuadrant robotQuadrant = RobotQuadrant.HIND_RIGHT;
        FramePoint2D frontLeft = new FramePoint2D((ReferenceFrame)previousNodeXGaitFrame, 1.57, 0.67);
        FramePoint2D frontRight = new FramePoint2D((ReferenceFrame)previousNodeXGaitFrame, 1.63, 0.12);
        FramePoint2D hindLeft = new FramePoint2D((ReferenceFrame)previousNodeXGaitFrame, 0.67, 0.72);
        FramePoint2D hindRight = new FramePoint2D((ReferenceFrame)previousNodeXGaitFrame, 0.73, 0.05);
        frontLeft.changeFrame(worldFrame);
        frontRight.changeFrame(worldFrame);
        hindLeft.changeFrame(worldFrame);
        hindRight.changeFrame(worldFrame);
        PawNode previousNode = new PawNode(robotQuadrant, (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, stepYaw, stanceLength, stanceWidth);
        previousNodeXGaitFrame.setPoseAndUpdate((Point3DReadOnly)new Point3D((Tuple2DReadOnly)previousNode.getOrComputeXGaitCenterPoint()), previousNode.getStepOrientation());
        FramePoint2D nominalFrontLeft = new FramePoint2D((ReferenceFrame)previousNodeXGaitFrame, -0.5 * previousNode.getNominalStanceLength(), -0.5 * previousNode.getNominalStanceWidth());
        Random random = new Random(1738L);
        for (iter = 0; iter < 50; ++iter) {
            offsetVector = new FrameVector2D((ReferenceFrame)previousNodeXGaitFrame, 0.0, -parameters.getMaximumStepInward());
            scaleFactor = RandomNumbers.nextDouble((Random)random, (double)0.05, (double)0.95);
            offsetVector.scale(scaleFactor);
            shiftedHindRight = new FramePoint2D((FrameTuple2DReadOnly)nominalFrontLeft);
            shiftedHindRight.add((FrameTuple2DReadOnly)offsetVector);
            shiftedHindRight.changeFrameAndProjectToXYPlane(worldFrame);
            newNode = new PawNode(robotQuadrant, (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)shiftedHindRight, stepYaw, stanceLength, stanceWidth);
            hindRight.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            shiftedHindRight.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            offsetVector.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            message = "Stepping from " + previousNode + " to " + newNode + "\n";
            isValid = nodeChecker.isNodeValid(newNode, previousNode);
            testListener.assertCorrectRejection(message, null, null, null);
            Assertions.assertTrue((boolean)isValid);
        }
        for (iter = 0; iter < 50; ++iter) {
            offsetVector = new FrameVector2D((ReferenceFrame)previousNodeXGaitFrame, 0.0, -parameters.getMaximumStepInward());
            scaleFactor = RandomNumbers.nextDouble((Random)random, (double)0.95, (double)0.99);
            offsetVector.scale(scaleFactor);
            shiftedHindRight = new FramePoint2D((FrameTuple2DReadOnly)nominalFrontLeft);
            shiftedHindRight.add((FrameTuple2DReadOnly)offsetVector);
            shiftedHindRight.changeFrameAndProjectToXYPlane(worldFrame);
            newNode = new PawNode(robotQuadrant, (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)shiftedHindRight, stepYaw, stanceLength, stanceWidth);
            hindRight.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            shiftedHindRight.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            offsetVector.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            message = "Stepping from " + previousNode + " to " + newNode + "\n";
            isValid = nodeChecker.isNodeValid(newNode, previousNode);
            testListener.assertCorrectRejection(message, null, null, null);
            Assertions.assertTrue((boolean)isValid);
        }
        for (iter = 0; iter < 50; ++iter) {
            offsetVector = new FrameVector2D((ReferenceFrame)previousNodeXGaitFrame, 0.0, -parameters.getMaximumStepInward());
            scaleFactor = RandomNumbers.nextDouble((Random)random, (double)1.01, (double)1.2);
            offsetVector.scale(scaleFactor);
            shiftedHindRight = new FramePoint2D((FrameTuple2DReadOnly)nominalFrontLeft);
            shiftedHindRight.add((FrameTuple2DReadOnly)offsetVector);
            shiftedHindRight.changeFrameAndProjectToXYPlane(worldFrame);
            newNode = new PawNode(robotQuadrant, (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)shiftedHindRight, stepYaw, stanceLength, stanceWidth);
            hindRight.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            shiftedHindRight.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            offsetVector.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            message = "Stepping from " + previousNode + " to " + newNode + "\n";
            isValid = nodeChecker.isNodeValid(newNode, previousNode);
            testListener.assertCorrectRejection(message, newNode, previousNode, PawStepPlannerNodeRejectionReason.STEP_TOO_FAR_LEFT);
            Assertions.assertFalse((boolean)isValid);
        }
    }

    @Test
    public void testStepTooFarForwardFrontLeft() {
        boolean isValid;
        String message;
        PawNode newNode;
        FramePoint2D shiftedFrontLeft;
        double scaleFactor;
        FrameVector2D offsetVector;
        int iter;
        Random random = new Random(1738L);
        double stanceLength = 1.0;
        double stanceWidth = 0.5;
        TestParameters parameters = new TestParameters();
        SimplePlanarRegionPawNodeSnapper snapper = new SimplePlanarRegionPawNodeSnapper((PawStepPlannerParametersReadOnly)parameters, true);
        SnapBasedPawNodeTransitionChecker nodeChecker = new SnapBasedPawNodeTransitionChecker((PawStepPlannerParametersReadOnly)parameters, (PawNodeSnapper)snapper);
        TestListener testListener = new TestListener();
        nodeChecker.addPlannerListener((PawStepPlannerListener)testListener);
        double stepYaw = -0.7853981633974483;
        PoseReferenceFrame previousNodeXGaitFrame = new PoseReferenceFrame("nodeFrame", worldFrame);
        previousNodeXGaitFrame.setPoseAndUpdate((Point3DReadOnly)new Point3D(0.6, 0.9, 0.0), (Orientation3DReadOnly)new AxisAngle(stepYaw, 0.0, 0.0));
        PawNode.gridSizeXY = 0.001;
        RobotQuadrant robotQuadrant = RobotQuadrant.FRONT_LEFT;
        FramePoint2D frontLeft = new FramePoint2D((ReferenceFrame)previousNodeXGaitFrame, 0.57, 0.27);
        FramePoint2D frontRight = new FramePoint2D((ReferenceFrame)previousNodeXGaitFrame, 0.63, -0.42);
        FramePoint2D hindLeft = new FramePoint2D((ReferenceFrame)previousNodeXGaitFrame, -0.67, 0.32);
        FramePoint2D hindRight = new FramePoint2D((ReferenceFrame)previousNodeXGaitFrame, -0.73, -0.35);
        frontLeft.changeFrame(worldFrame);
        frontRight.changeFrame(worldFrame);
        hindLeft.changeFrame(worldFrame);
        hindRight.changeFrame(worldFrame);
        PawNode previousNode = new PawNode(robotQuadrant, (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, stepYaw, stanceLength, stanceWidth);
        previousNodeXGaitFrame.setPoseAndUpdate((Point3DReadOnly)new Point3D((Tuple2DReadOnly)previousNode.getOrComputeXGaitCenterPoint()), previousNode.getStepOrientation());
        FramePoint2D nominalFrontLeft = new FramePoint2D((ReferenceFrame)previousNodeXGaitFrame, 0.5 * previousNode.getNominalStanceLength(), 0.5 * previousNode.getNominalStanceWidth());
        for (iter = 0; iter < 50; ++iter) {
            offsetVector = new FrameVector2D((ReferenceFrame)previousNodeXGaitFrame, parameters.getMaximumFrontStepLength(), 0.0);
            scaleFactor = RandomNumbers.nextDouble((Random)random, (double)0.05, (double)0.95);
            offsetVector.scale(scaleFactor);
            shiftedFrontLeft = new FramePoint2D((FrameTuple2DReadOnly)nominalFrontLeft);
            shiftedFrontLeft.add((FrameTuple2DReadOnly)offsetVector);
            shiftedFrontLeft.changeFrameAndProjectToXYPlane(worldFrame);
            newNode = new PawNode(robotQuadrant, (Tuple2DReadOnly)shiftedFrontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, stepYaw, stanceLength, stanceWidth);
            frontLeft.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            shiftedFrontLeft.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            offsetVector.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            message = "\nIteration " + iter + ".\nStepping from " + previousNode + " to " + newNode + "\n";
            isValid = nodeChecker.isNodeValid(newNode, previousNode);
            testListener.assertCorrectRejection(message, null, null, null);
            Assertions.assertTrue((boolean)isValid);
        }
        for (iter = 0; iter < 50; ++iter) {
            offsetVector = new FrameVector2D((ReferenceFrame)previousNodeXGaitFrame, parameters.getMaximumFrontStepLength(), 0.0);
            scaleFactor = RandomNumbers.nextDouble((Random)random, (double)0.95, (double)0.99);
            offsetVector.scale(scaleFactor);
            shiftedFrontLeft = new FramePoint2D((FrameTuple2DReadOnly)nominalFrontLeft);
            shiftedFrontLeft.add((FrameTuple2DReadOnly)offsetVector);
            shiftedFrontLeft.changeFrameAndProjectToXYPlane(worldFrame);
            newNode = new PawNode(robotQuadrant, (Tuple2DReadOnly)shiftedFrontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, stepYaw, stanceLength, stanceWidth);
            frontLeft.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            shiftedFrontLeft.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            offsetVector.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            message = "\nIteration " + iter + ".\nStepping from " + previousNode + " to " + newNode + "\n";
            isValid = nodeChecker.isNodeValid(newNode, previousNode);
            testListener.assertCorrectRejection(message, null, null, null);
            Assertions.assertTrue((boolean)isValid);
        }
        double maxScale = parameters.getMaximumFrontStepReach() / parameters.getMaximumFrontStepLength() - 0.001;
        for (int iter2 = 0; iter2 < 50; ++iter2) {
            FrameVector2D offsetVector2 = new FrameVector2D((ReferenceFrame)previousNodeXGaitFrame, parameters.getMaximumFrontStepLength(), 0.0);
            double scaleFactor2 = RandomNumbers.nextDouble((Random)random, (double)1.01, (double)maxScale);
            offsetVector2.scale(scaleFactor2);
            FramePoint2D shiftedFrontLeft2 = new FramePoint2D((FrameTuple2DReadOnly)nominalFrontLeft);
            shiftedFrontLeft2.add((FrameTuple2DReadOnly)offsetVector2);
            shiftedFrontLeft2.changeFrameAndProjectToXYPlane(worldFrame);
            PawNode newNode2 = new PawNode(robotQuadrant, (Tuple2DReadOnly)shiftedFrontLeft2, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, stepYaw, stanceLength, stanceWidth);
            frontLeft.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            shiftedFrontLeft2.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            offsetVector2.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            String message2 = "\nIteration " + iter2 + ".\nStepping from " + previousNode + " to " + newNode2 + "\n";
            boolean isValid2 = nodeChecker.isNodeValid(newNode2, previousNode);
            testListener.assertCorrectRejection(message2, newNode2, previousNode, PawStepPlannerNodeRejectionReason.STEP_TOO_FAR_FORWARD);
            Assertions.assertFalse((boolean)isValid2);
        }
    }

    @Test
    public void testStepTooFarBackwardFrontLeft() {
        boolean isValid;
        String message;
        PawNode newNode;
        FramePoint2D shiftedFrontLeft;
        double scaleFactor;
        FrameVector2D offsetVector;
        int iter;
        Random random = new Random(1738L);
        double stanceLength = 1.0;
        double stanceWidth = 0.5;
        TestParameters parameters = new TestParameters();
        SimplePlanarRegionPawNodeSnapper snapper = new SimplePlanarRegionPawNodeSnapper((PawStepPlannerParametersReadOnly)parameters, true);
        SnapBasedPawNodeTransitionChecker nodeChecker = new SnapBasedPawNodeTransitionChecker((PawStepPlannerParametersReadOnly)parameters, (PawNodeSnapper)snapper);
        TestListener testListener = new TestListener();
        nodeChecker.addPlannerListener((PawStepPlannerListener)testListener);
        double stepYaw = -0.7853981633974483;
        PoseReferenceFrame previousNodeXGaitFrame = new PoseReferenceFrame("nodeFrame", worldFrame);
        previousNodeXGaitFrame.setPoseAndUpdate((Point3DReadOnly)new Point3D(0.6, 0.9, 0.0), (Orientation3DReadOnly)new AxisAngle(stepYaw, 0.0, 0.0));
        PawNode.gridSizeXY = 0.001;
        RobotQuadrant robotQuadrant = RobotQuadrant.FRONT_LEFT;
        FramePoint2D frontLeft = new FramePoint2D((ReferenceFrame)previousNodeXGaitFrame, 0.57, 0.27);
        FramePoint2D frontRight = new FramePoint2D((ReferenceFrame)previousNodeXGaitFrame, 0.63, -0.42);
        FramePoint2D hindLeft = new FramePoint2D((ReferenceFrame)previousNodeXGaitFrame, -0.67, 0.32);
        FramePoint2D hindRight = new FramePoint2D((ReferenceFrame)previousNodeXGaitFrame, -0.73, -0.35);
        frontLeft.changeFrame(worldFrame);
        frontRight.changeFrame(worldFrame);
        hindLeft.changeFrame(worldFrame);
        hindRight.changeFrame(worldFrame);
        PawNode previousNode = new PawNode(robotQuadrant, (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, stepYaw, stanceLength, stanceWidth);
        previousNodeXGaitFrame.setPoseAndUpdate((Point3DReadOnly)new Point3D((Tuple2DReadOnly)previousNode.getOrComputeXGaitCenterPoint()), previousNode.getStepOrientation());
        FramePoint2D nominalFrontLeft = new FramePoint2D((ReferenceFrame)previousNodeXGaitFrame, 0.5 * previousNode.getNominalStanceLength(), 0.5 * previousNode.getNominalStanceWidth());
        for (iter = 0; iter < 50; ++iter) {
            offsetVector = new FrameVector2D((ReferenceFrame)previousNodeXGaitFrame, parameters.getMinimumFrontStepLength(), 0.0);
            scaleFactor = RandomNumbers.nextDouble((Random)random, (double)0.05, (double)0.95);
            offsetVector.scale(scaleFactor);
            shiftedFrontLeft = new FramePoint2D((FrameTuple2DReadOnly)nominalFrontLeft);
            shiftedFrontLeft.add((FrameTuple2DReadOnly)offsetVector);
            shiftedFrontLeft.changeFrameAndProjectToXYPlane(worldFrame);
            newNode = new PawNode(robotQuadrant, (Tuple2DReadOnly)shiftedFrontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, stepYaw, stanceLength, stanceWidth);
            frontLeft.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            shiftedFrontLeft.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            offsetVector.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            message = "\nIteration " + iter + ".\nStepping from " + previousNode + " to " + newNode + "\n";
            isValid = nodeChecker.isNodeValid(newNode, previousNode);
            testListener.assertCorrectRejection(message, null, null, null);
            Assertions.assertTrue((boolean)isValid);
        }
        for (iter = 0; iter < 50; ++iter) {
            offsetVector = new FrameVector2D((ReferenceFrame)previousNodeXGaitFrame, parameters.getMinimumFrontStepLength(), 0.0);
            scaleFactor = RandomNumbers.nextDouble((Random)random, (double)0.95, (double)0.99);
            offsetVector.scale(scaleFactor);
            shiftedFrontLeft = new FramePoint2D((FrameTuple2DReadOnly)nominalFrontLeft);
            shiftedFrontLeft.add((FrameTuple2DReadOnly)offsetVector);
            shiftedFrontLeft.changeFrameAndProjectToXYPlane(worldFrame);
            newNode = new PawNode(robotQuadrant, (Tuple2DReadOnly)shiftedFrontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, stepYaw, stanceLength, stanceWidth);
            frontLeft.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            shiftedFrontLeft.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            offsetVector.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            message = "\nIteration " + iter + ".\nStepping from " + previousNode + " to " + newNode + "\n";
            isValid = nodeChecker.isNodeValid(newNode, previousNode);
            testListener.assertCorrectRejection(message, null, null, null);
            Assertions.assertTrue((boolean)isValid);
        }
        double maxScale = parameters.getMaximumFrontStepReach() / Math.abs(parameters.getMinimumFrontStepLength()) - 0.001;
        for (int iter2 = 0; iter2 < 50; ++iter2) {
            FrameVector2D offsetVector2 = new FrameVector2D((ReferenceFrame)previousNodeXGaitFrame, parameters.getMinimumFrontStepLength(), 0.0);
            double scaleFactor2 = RandomNumbers.nextDouble((Random)random, (double)1.01, (double)maxScale);
            offsetVector2.scale(scaleFactor2);
            FramePoint2D shiftedFrontLeft2 = new FramePoint2D((FrameTuple2DReadOnly)nominalFrontLeft);
            shiftedFrontLeft2.add((FrameTuple2DReadOnly)offsetVector2);
            shiftedFrontLeft2.changeFrameAndProjectToXYPlane(worldFrame);
            PawNode newNode2 = new PawNode(robotQuadrant, (Tuple2DReadOnly)shiftedFrontLeft2, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, stepYaw, stanceLength, stanceWidth);
            frontLeft.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            shiftedFrontLeft2.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            offsetVector2.changeFrame((ReferenceFrame)previousNodeXGaitFrame);
            String message2 = "\nIteration " + iter2 + ".\nStepping from " + previousNode + " to " + newNode2 + "\n";
            boolean isValid2 = nodeChecker.isNodeValid(newNode2, previousNode);
            testListener.assertCorrectRejection(message2, newNode2, previousNode, PawStepPlannerNodeRejectionReason.STEP_TOO_FAR_BACKWARD);
            Assertions.assertFalse((boolean)isValid2);
        }
    }

    private class TestListener
    implements PawStepPlannerListener {
        private final AtomicReference<PawStepPlannerNodeRejectionReason> reason = new AtomicReference();
        private final AtomicReference<PawNode> rejectedNode = new AtomicReference();
        private final AtomicReference<PawNode> rejectedParentNode = new AtomicReference();

        private TestListener() {
        }

        public void addNode(PawNode node, PawNode previousNode) {
        }

        public void assertCorrectRejection(String message, PawNode node, PawNode parentNode, PawStepPlannerNodeRejectionReason rejectionReason) {
            Assertions.assertEquals((Object)rejectionReason, this.reason.getAndSet(null), (String)message);
            Assertions.assertEquals((Object)node, this.rejectedNode.getAndSet(null), (String)message);
            Assertions.assertEquals((Object)parentNode, this.rejectedParentNode.getAndSet(null), (String)message);
        }

        public void rejectNode(PawNode node, PawNode parentNode, PawStepPlannerNodeRejectionReason rejectionReason) {
            this.rejectedNode.set(node);
            this.rejectedParentNode.set(parentNode);
            this.reason.set(rejectionReason);
        }

        public void rejectNode(PawNode node, PawStepPlannerNodeRejectionReason rejectionReason) {
            this.rejectedNode.set(node);
            this.reason.set(rejectionReason);
        }

        public void plannerFinished(List<PawNode> plan) {
        }

        public void reportLowestCostNodeList(List<PawNode> plan) {
        }

        public void tickAndUpdate() {
        }
    }

    private class TestParameters
    extends DefaultPawStepPlannerParameters {
        private TestParameters() {
        }

        public double getMinXClearanceFromPaw() {
            return 0.0;
        }

        public double getMinYClearanceFromPaw() {
            return 0.0;
        }

        public double getMinimumFrontStepLength() {
            return -0.3;
        }

        public double getProjectInsideDistance() {
            return 0.0;
        }
    }
}

