/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.nodeChecking;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.PawStepPlannerNodeRejectionReason;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.graph.PawNode;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.listeners.PawStepPlannerListener;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.nodeChecking.SnapBasedPawNodeChecker;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.parameters.DefaultPawStepPlannerParameters;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.parameters.PawStepPlannerParametersReadOnly;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.pawSnapping.PawNodeSnapper;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.pawSnapping.SimplePlanarRegionPawNodeSnapper;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.robotSide.RobotQuadrant;

public class SnapBasedPawNodeCheckerTest {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();

    @Test
    public void testSnappingToBlock() {
        double stanceLength = 1.0;
        double stanceWidth = 0.5;
        double cinderWidth = 0.1905;
        double cinderLength = 0.3937;
        double cinderHeight = 0.1905;
        TestParameters parameters = new TestParameters();
        parameters.setDistanceInside(0.5 * cinderWidth);
        SimplePlanarRegionPawNodeSnapper snapper = new SimplePlanarRegionPawNodeSnapper((PawStepPlannerParametersReadOnly)parameters, true);
        SnapBasedPawNodeChecker nodeChecker = new SnapBasedPawNodeChecker((PawStepPlannerParametersReadOnly)parameters, (PawNodeSnapper)snapper);
        TestListener testListener = new TestListener();
        nodeChecker.addPlannerListener((PawStepPlannerListener)testListener);
        ConvexPolygon2D groundPlanePolygon = new ConvexPolygon2D();
        groundPlanePolygon.addVertex(10.0, 10.0);
        groundPlanePolygon.addVertex(-10.0, 10.0);
        groundPlanePolygon.addVertex(10.0, -10.0);
        groundPlanePolygon.addVertex(-10.0, -10.0);
        groundPlanePolygon.update();
        ConvexPolygon2D cinderPolygon = new ConvexPolygon2D();
        cinderPolygon.addVertex(0.5 * cinderWidth, 0.5 * cinderLength);
        cinderPolygon.addVertex(0.5 * cinderWidth, -0.5 * cinderLength);
        cinderPolygon.addVertex(-0.5 * cinderWidth, -0.5 * cinderLength);
        cinderPolygon.addVertex(-0.5 * cinderWidth, 0.5 * cinderLength);
        cinderPolygon.update();
        RigidBodyTransform cinderTransform = new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)new Vector3D(0.0, 0.0, cinderHeight));
        PlanarRegionsList planarRegionList = new PlanarRegionsList();
        planarRegionList.addPlanarRegion(new PlanarRegion((RigidBodyTransformReadOnly)new RigidBodyTransform(), (Vertex2DSupplier)groundPlanePolygon));
        planarRegionList.addPlanarRegion(new PlanarRegion((RigidBodyTransformReadOnly)cinderTransform, (Vertex2DSupplier)cinderPolygon));
        nodeChecker.setPlanarRegions(planarRegionList);
        RobotQuadrant robotQuadrant = RobotQuadrant.FRONT_LEFT;
        FramePoint2D frontLeft = new FramePoint2D(worldFrame, 0.0, 0.0);
        FramePoint2D frontRight = new FramePoint2D(worldFrame, 0.0, -stanceWidth);
        FramePoint2D hindLeft = new FramePoint2D(worldFrame, -stanceLength, 0.0);
        FramePoint2D hindRight = new FramePoint2D(worldFrame, -stanceLength, -stanceWidth);
        double yaw = PawNode.computeNominalYaw((double)frontLeft.getX(), (double)frontLeft.getY(), (double)frontRight.getX(), (double)frontRight.getY(), (double)hindLeft.getX(), (double)hindLeft.getY(), (double)hindRight.getX(), (double)hindRight.getY());
        PawNode node = new PawNode(robotQuadrant, (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, yaw, stanceLength, stanceWidth);
        boolean isValid = nodeChecker.isNodeValid(node);
        testListener.assertCorrectRejection("", null, null);
        Assertions.assertTrue((boolean)isValid);
        parameters.setDistanceInside(0.5 * cinderWidth + 0.01);
        snapper.setPlanarRegions(planarRegionList);
        isValid = nodeChecker.isNodeValid(node);
        testListener.assertCorrectRejection("", null, null);
        Assertions.assertTrue((boolean)isValid);
        snapper.setPlanarRegions(planarRegionList);
        parameters.setDistanceInside(0.08);
        frontLeft.setX(0.45 * cinderWidth);
        node = new PawNode(robotQuadrant, (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, yaw, stanceLength, stanceWidth);
        isValid = nodeChecker.isNodeValid(node);
        testListener.assertCorrectRejection("", node, PawStepPlannerNodeRejectionReason.COULD_NOT_SNAP);
        Assertions.assertFalse((boolean)isValid);
    }

    private class TestParameters
    extends DefaultPawStepPlannerParameters {
        double distance;

        private TestParameters() {
        }

        public double getProjectInsideDistance() {
            return this.distance;
        }

        public void setDistanceInside(double distanceInside) {
            this.distance = distanceInside;
        }
    }

    private class TestListener
    implements PawStepPlannerListener {
        private final AtomicReference<PawStepPlannerNodeRejectionReason> reason = new AtomicReference();
        private final AtomicReference<PawNode> rejectedNode = new AtomicReference();

        private TestListener() {
        }

        public void addNode(PawNode node, PawNode previousNode) {
        }

        public void assertCorrectRejection(String message, PawNode node, PawStepPlannerNodeRejectionReason rejectionReason) {
            Assertions.assertEquals((Object)rejectionReason, this.reason.getAndSet(null), (String)message);
            Assertions.assertEquals((Object)node, this.rejectedNode.getAndSet(null), (String)message);
        }

        public void rejectNode(PawNode node, PawNode parentNode, PawStepPlannerNodeRejectionReason rejectionReason) {
            this.rejectedNode.set(node);
            this.reason.set(rejectionReason);
        }

        public void rejectNode(PawNode node, PawStepPlannerNodeRejectionReason rejectionReason) {
            this.rejectedNode.set(node);
            this.reason.set(rejectionReason);
        }

        public void plannerFinished(List<PawNode> plan) {
        }

        public void reportLowestCostNodeList(List<PawNode> plan) {
        }

        public void tickAndUpdate() {
        }
    }
}

