/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.graph;

import gnu.trove.list.array.TIntArrayList;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.PawStepPlanningRandomTools;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.graph.PawNode;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.robotSide.RobotQuadrant;

public class PawNodeTest {
    @Test
    public void testEqualsAndHashMethodsWithRandomTransforms() {
        Random random = new Random(3823L);
        int numTrials = 100;
        for (int i = 0; i < numTrials; ++i) {
            PawNode nodeA = PawStepPlanningRandomTools.createRandomFootstepNode(random);
            PawNode nodeB = new PawNode(nodeA);
            Assert.assertTrue((boolean)nodeA.equals((Object)nodeB));
            Assert.assertTrue((nodeA.hashCode() == nodeB.hashCode() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testQuadrantEquals() {
        Random random = new Random(3823L);
        int numTrials = 100;
        for (int i = 0; i < numTrials; ++i) {
            RobotQuadrant robotQuadrant = RobotQuadrant.FRONT_LEFT;
            Point2D frontLeft = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)1.0);
            Point2D frontRight = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)1.0);
            Point2D otherFrontRight = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)1.0);
            Point2D hindLeft = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)1.0);
            Point2D otherHindLeft = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)1.0);
            Point2D hindRight = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)1.0);
            Point2D otherHindRight = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)1.0);
            double yaw = PawNode.computeNominalYaw((double)frontLeft.getX(), (double)frontLeft.getY(), (double)frontRight.getX(), (double)frontRight.getY(), (double)hindLeft.getX(), (double)hindLeft.getY(), (double)hindRight.getX(), (double)hindRight.getY());
            PawNode nodeA = new PawNode(robotQuadrant, (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, yaw, 1.5, 0.5);
            PawNode nodeB = new PawNode(robotQuadrant, (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)otherFrontRight, (Tuple2DReadOnly)otherHindLeft, (Tuple2DReadOnly)otherHindRight, yaw, 1.5, 0.5);
            Assert.assertTrue((String)("number : " + i), (boolean)nodeA.quadrantGeometricallyEquals(nodeB));
            TIntArrayList expandedNodes = new TIntArrayList();
            Assert.assertFalse((String)("number : " + i), (boolean)expandedNodes.contains(nodeB.hashCode()));
            expandedNodes.add(nodeA.hashCode());
            if (nodeA.getYawIndex() == nodeB.getYawIndex()) {
                Assert.assertEquals((String)("number : " + i), (long)nodeA.hashCode(), (long)nodeB.hashCode());
                Assert.assertTrue((String)("number : " + i), (boolean)expandedNodes.contains(nodeB.hashCode()));
                continue;
            }
            Assert.assertFalse((String)("number : " + i), (nodeA.hashCode() == nodeB.hashCode() ? 1 : 0) != 0);
            Assert.assertFalse((String)("number : " + i), (boolean)expandedNodes.contains(nodeB.hashCode()));
        }
    }

    @Test
    public void testPiToPiRollOver() {
        PawNode nodeA = PawNodeTest.createNodeAtOrigin(Math.PI);
        PawNode nodeB = PawNodeTest.createNodeAtOrigin(-Math.PI);
        Assertions.assertTrue((boolean)nodeA.equals((Object)nodeB));
        Assertions.assertTrue((nodeA.hashCode() == nodeB.hashCode() ? 1 : 0) != 0);
        nodeA = PawNodeTest.createNodeAtOrigin(3.141582653589793);
        nodeB = PawNodeTest.createNodeAtOrigin(-3.141582653589793);
        Assertions.assertTrue((boolean)nodeA.equals((Object)nodeB));
        Assertions.assertTrue((nodeA.hashCode() == nodeB.hashCode() ? 1 : 0) != 0);
        nodeA = PawNodeTest.createNodeAtOrigin(3.141602653589793);
        nodeB = PawNodeTest.createNodeAtOrigin(-3.141602653589793);
        Assertions.assertTrue((boolean)nodeA.equals((Object)nodeB));
        Assertions.assertTrue((nodeA.hashCode() == nodeB.hashCode() ? 1 : 0) != 0);
    }

    private static PawNode createNodeAtOrigin(double yaw) {
        return new PawNode(RobotQuadrant.FRONT_LEFT, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, yaw, 1.0, 0.5);
    }
}

